/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.items.weapons;

import com.cibernet.splatcraft.entities.InkProjectileEntity;
import com.cibernet.splatcraft.handlers.PlayerPosingHandler;
import com.cibernet.splatcraft.items.weapons.WeaponBaseItem;
import com.cibernet.splatcraft.registries.SplatcraftSounds;
import com.cibernet.splatcraft.util.InkBlockUtils;
import com.cibernet.splatcraft.util.PlayerCooldown;
import com.cibernet.splatcraft.util.WeaponStat;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;

public class SlosherItem
extends WeaponBaseItem {
    public float projectileSize;
    public float projectileSpeed;
    public float damage;
    public int startupTicks;
    public int projectileCount;
    public float diffAngle;
    public float inkConsumption;

    public SlosherItem(String name, float projectileSize, float projectileSpeed, int projectileCount, float offsetBetweenProj, float damage, int startupTicks, float inkConsumption) {
        this.setRegistryName(name);
        this.projectileSize = projectileSize;
        this.projectileSpeed = projectileSpeed;
        this.damage = damage;
        this.startupTicks = startupTicks;
        this.projectileCount = projectileCount;
        this.diffAngle = offsetBetweenProj;
        this.inkConsumption = inkConsumption;
        this.addStat(new WeaponStat("range", (stack, world) -> (int)(projectileSpeed / 1.2f * 100.0f)));
        this.addStat(new WeaponStat("damage", (stack, world) -> (int)(damage / 20.0f * 100.0f)));
        this.addStat(new WeaponStat("handling", (stack, world) -> (11 - startupTicks) * 10));
    }

    public SlosherItem(String name, SlosherItem parent) {
        this(name, parent.projectileSize, parent.projectileSpeed, parent.projectileCount, parent.diffAngle, parent.damage, parent.startupTicks, parent.inkConsumption);
    }

    @Override
    public void weaponUseTick(World world, LivingEntity entity, ItemStack stack, int timeLeft) {
        if (SlosherItem.getInkAmount(entity, stack) >= this.inkConsumption) {
            if (entity instanceof PlayerEntity && this.func_77626_a(stack) - timeLeft < this.startupTicks) {
                PlayerCooldown.setPlayerCooldown((PlayerEntity)entity, new PlayerCooldown(this.startupTicks, ((PlayerEntity)entity).field_71071_by.field_70461_c, true, false, true));
            }
        } else {
            SlosherItem.sendNoInkMessage(entity, null);
        }
    }

    @Override
    public void onPlayerCooldownEnd(World world, PlayerEntity player, ItemStack stack) {
        if (SlosherItem.getInkAmount((LivingEntity)player, stack) >= this.inkConsumption) {
            if (!world.field_72995_K) {
                for (int i = 0; i < this.projectileCount; ++i) {
                    boolean hasTrail = (double)i == Math.floor((float)(this.projectileCount - 1) / 2.0f) || (double)i == Math.ceil((float)(this.projectileCount - 1) / 2.0f);
                    float angle = this.diffAngle * (float)i - this.diffAngle * (float)(this.projectileCount - 1) / 2.0f;
                    InkProjectileEntity proj = new InkProjectileEntity(world, (LivingEntity)player, stack, InkBlockUtils.getInkType((LivingEntity)player), this.projectileSize * (hasTrail ? 1.0f : 0.8f), this.damage);
                    if (hasTrail) {
                        // empty if block
                    }
                    proj.setShooterTrail();
                    proj.shoot((Entity)player, player.field_70125_A, player.field_70177_z + angle, 0.0f, this.projectileSpeed, 2.0f);
                    world.func_217376_c((Entity)proj);
                }
                world.func_184133_a(null, player.func_233580_cy_(), SplatcraftSounds.slosherShot, SoundCategory.PLAYERS, 0.7f, ((world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.1f + 1.0f) * 0.95f);
                SlosherItem.reduceInk((LivingEntity)player, this.inkConsumption);
            }
        } else {
            SlosherItem.sendNoInkMessage((LivingEntity)player, null);
        }
    }

    @Override
    public PlayerPosingHandler.WeaponPose getPose() {
        return PlayerPosingHandler.WeaponPose.BUCKET_SWING;
    }
}

