/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.items.weapons;

import com.cibernet.splatcraft.blocks.InkwellBlock;
import com.cibernet.splatcraft.capabilities.playerinfo.PlayerInfoCapability;
import com.cibernet.splatcraft.handlers.PlayerPosingHandler;
import com.cibernet.splatcraft.items.InkTankItem;
import com.cibernet.splatcraft.registries.SplatcraftGameRules;
import com.cibernet.splatcraft.registries.SplatcraftItemGroups;
import com.cibernet.splatcraft.registries.SplatcraftItems;
import com.cibernet.splatcraft.registries.SplatcraftSounds;
import com.cibernet.splatcraft.tileentities.InkColorTileEntity;
import com.cibernet.splatcraft.util.ClientUtils;
import com.cibernet.splatcraft.util.ColorUtils;
import com.cibernet.splatcraft.util.WeaponStat;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class WeaponBaseItem
extends Item {
    protected final List<WeaponStat> stats = new ArrayList<WeaponStat>();

    public WeaponBaseItem() {
        super(new Item.Properties().func_200917_a(1).func_200916_a(SplatcraftItemGroups.GROUP_WEAPONS));
        SplatcraftItems.inkColoredItems.add(this);
        SplatcraftItems.weapons.add(this);
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        if (ColorUtils.isColorLocked(stack)) {
            tooltip.add(ColorUtils.getFormatedColorName(ColorUtils.getInkColor(stack), true));
        } else {
            tooltip.add((ITextComponent)new StringTextComponent(""));
        }
        for (WeaponStat stat : this.stats) {
            tooltip.add((ITextComponent)stat.getTextComponent(stack, world).func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.DARK_GREEN)));
        }
    }

    public void addStat(WeaponStat stat) {
        this.stats.add(stat);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, world, entity, itemSlot, isSelected);
        if (entity instanceof PlayerEntity && !ColorUtils.isColorLocked(stack) && ColorUtils.getInkColor(stack) != ColorUtils.getPlayerColor((PlayerEntity)entity) && PlayerInfoCapability.hasCapability((LivingEntity)entity)) {
            ColorUtils.setInkColor(stack, ColorUtils.getPlayerColor((PlayerEntity)entity));
        }
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        BlockPos pos = entity.func_233580_cy_().func_177977_b();
        if (entity.field_70170_p.func_180495_p(pos).func_177230_c() instanceof InkwellBlock) {
            InkColorTileEntity te = (InkColorTileEntity)entity.field_70170_p.func_175625_s(pos);
            if (ColorUtils.getInkColor(stack) != ColorUtils.getInkColor(te)) {
                ColorUtils.setInkColor(entity.func_92059_d(), ColorUtils.getInkColor(te));
                ColorUtils.setColorLocked(entity.func_92059_d(), true);
            }
        }
        return false;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        try {
            return ClientUtils.getDurabilityForDisplay(stack);
        }
        catch (NoClassDefFoundError e) {
            return 1.0;
        }
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return ColorUtils.getInkColor(stack);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        try {
            return ClientUtils.showDurabilityBar(stack);
        }
        catch (NoClassDefFoundError e) {
            return false;
        }
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        player.func_184598_c(hand);
        return super.func_77659_a(world, player, hand);
    }

    public void func_77615_a(ItemStack stack, World world, LivingEntity entity, int timeLeft) {
        entity.func_184602_cy();
        super.func_77615_a(stack, world, entity, timeLeft);
    }

    public void weaponUseTick(World world, LivingEntity entity, ItemStack stack, int timeLeft) {
    }

    public void onPlayerCooldownEnd(World world, PlayerEntity player, ItemStack stack) {
    }

    public static float getInkAmount(LivingEntity player, ItemStack weapon) {
        if (!SplatcraftGameRules.getBooleanRuleValue(player.field_70170_p, SplatcraftGameRules.REQUIRE_INK_TANK)) {
            return Float.MAX_VALUE;
        }
        ItemStack tank = player.func_184582_a(EquipmentSlotType.CHEST);
        if (!(tank.func_77973_b() instanceof InkTankItem)) {
            return 0.0f;
        }
        return InkTankItem.getInkAmount(tank, weapon);
    }

    public static boolean hasInk(LivingEntity player, ItemStack weapon) {
        return WeaponBaseItem.getInkAmount(player, weapon) > 0.0f;
    }

    public static void reduceInk(LivingEntity player, float amount) {
        ItemStack tank = player.func_184582_a(EquipmentSlotType.CHEST);
        if (!SplatcraftGameRules.getBooleanRuleValue(player.field_70170_p, SplatcraftGameRules.REQUIRE_INK_TANK)) {
            return;
        }
        if (!(tank.func_77973_b() instanceof InkTankItem)) {
            return;
        }
        InkTankItem.setInkAmount(tank, InkTankItem.getInkAmount(tank) - amount);
    }

    public static void sendNoInkMessage(LivingEntity entity) {
        WeaponBaseItem.sendNoInkMessage(entity, SplatcraftSounds.noInkMain);
    }

    public static void sendNoInkMessage(LivingEntity entity, SoundEvent sound) {
        if (entity instanceof PlayerEntity) {
            ((PlayerEntity)entity).func_146105_b((ITextComponent)new TranslationTextComponent("status.no_ink").func_240699_a_(TextFormatting.RED), true);
            if (sound != null) {
                entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), sound, SoundCategory.PLAYERS, 0.8f, ((entity.field_70170_p.field_73012_v.nextFloat() - entity.field_70170_p.field_73012_v.nextFloat()) * 0.1f + 1.0f) * 0.95f);
            }
        }
    }

    public PlayerPosingHandler.WeaponPose getPose() {
        return PlayerPosingHandler.WeaponPose.NONE;
    }
}

