/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.network;

import com.cibernet.splatcraft.capabilities.playerinfo.IPlayerInfo;
import com.cibernet.splatcraft.capabilities.playerinfo.PlayerInfoCapability;
import com.cibernet.splatcraft.network.PlayerSetSquidClientPacket;
import com.cibernet.splatcraft.network.SplatcraftPacketHandler;
import com.cibernet.splatcraft.network.base.PlayToServerPacket;
import com.cibernet.splatcraft.registries.SplatcraftSounds;
import java.util.UUID;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;

public class PlayerSetSquidServerPacket
extends PlayToServerPacket {
    private int squid = -1;
    UUID target;

    public PlayerSetSquidServerPacket(PlayerEntity player) {
        this.target = player.func_110124_au();
    }

    public PlayerSetSquidServerPacket(PlayerEntity player, boolean set) {
        this.squid = set ? 1 : 0;
        this.target = player.func_110124_au();
    }

    protected PlayerSetSquidServerPacket(UUID player, int squid) {
        this.squid = squid;
        this.target = player;
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.func_179252_a(this.target);
        buffer.writeInt(this.squid);
    }

    public static PlayerSetSquidServerPacket decode(PacketBuffer buffer) {
        return new PlayerSetSquidServerPacket(buffer.func_179253_g(), buffer.readInt());
    }

    @Override
    public void execute(PlayerEntity player) {
        World world = player.field_70170_p;
        IPlayerInfo target = PlayerInfoCapability.get((LivingEntity)world.func_217371_b(this.target));
        if (this.squid == -1) {
            this.squid = !target.isSquid() ? 1 : 0;
        }
        target.setIsSquid(this.squid == 1);
        world.func_184133_a(null, player.func_233580_cy_(), this.squid == 1 ? SplatcraftSounds.squidTransform : SplatcraftSounds.squidRevert, SoundCategory.PLAYERS, 0.75f, ((world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.1f + 1.0f) * 0.95f);
        SplatcraftPacketHandler.sendToDim(new PlayerSetSquidClientPacket(this.target, this.squid), player.field_70170_p);
    }
}

