/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.network;

import com.cibernet.splatcraft.network.base.PlayToClientPacket;
import com.cibernet.splatcraft.util.ClientUtils;
import com.cibernet.splatcraft.util.ColorUtils;
import java.util.ArrayList;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class SendScanTurfResultsPacket
extends PlayToClientPacket {
    Integer[] colors;
    Float[] scores;
    int length;

    public SendScanTurfResultsPacket(Integer[] colors, Float[] scores) {
        this.colors = colors;
        this.scores = scores;
        this.length = Math.min(colors.length, scores.length);
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.length);
        for (int i = 0; i < this.length; ++i) {
            buffer.writeInt(this.colors[i].intValue());
            buffer.writeFloat(this.scores[i].floatValue());
        }
    }

    public static SendScanTurfResultsPacket decode(PacketBuffer buffer) {
        ArrayList<Integer> colorList = new ArrayList<Integer>();
        ArrayList<Float> scoreList = new ArrayList<Float>();
        int length = buffer.readInt();
        for (int i = 0; i < length; ++i) {
            colorList.add(buffer.readInt());
            scoreList.add(Float.valueOf(buffer.readFloat()));
        }
        return new SendScanTurfResultsPacket(colorList.toArray(new Integer[colorList.size()]), scoreList.toArray(new Float[scoreList.size()]));
    }

    @Override
    public void execute() {
        PlayerEntity player = ClientUtils.getClientPlayer();
        int winner = -1;
        float winnerScore = -1.0f;
        for (int i = 0; i < this.colors.length; ++i) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("status.scan_turf.score", new Object[]{ColorUtils.getFormatedColorName(this.colors[i], false), String.format("%.1f", this.scores[i])}), false);
            if (!(winnerScore < this.scores[i].floatValue())) continue;
            winnerScore = this.scores[i].floatValue();
            winner = this.colors[i];
        }
        if (winner != -1) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("status.scan_turf.winner", new Object[]{ColorUtils.getFormatedColorName(winner, false)}), false);
        }
    }
}

