/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.network;

import com.cibernet.splatcraft.network.DodgeRollPacket;
import com.cibernet.splatcraft.network.PlayerColorPacket;
import com.cibernet.splatcraft.network.PlayerSetSquidClientPacket;
import com.cibernet.splatcraft.network.PlayerSetSquidServerPacket;
import com.cibernet.splatcraft.network.RequestPlayerInfoPacket;
import com.cibernet.splatcraft.network.SendScanTurfResultsPacket;
import com.cibernet.splatcraft.network.UpdateBlockColorPacket;
import com.cibernet.splatcraft.network.UpdateBooleanGamerulesPacket;
import com.cibernet.splatcraft.network.UpdateColorScoresPacket;
import com.cibernet.splatcraft.network.UpdatePlayerInfoPacket;
import com.cibernet.splatcraft.network.base.SplatcraftPacket;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;

public class SplatcraftPacketHandler {
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("splatcraft", "main"), () -> "1", "1"::equals, "1"::equals);
    private static int ID = 0;

    public static void registerMessages() {
        SplatcraftPacketHandler.registerMessage(UpdatePlayerInfoPacket.class, UpdatePlayerInfoPacket::decode);
        SplatcraftPacketHandler.registerMessage(PlayerColorPacket.class, PlayerColorPacket::decode);
        SplatcraftPacketHandler.registerMessage(PlayerSetSquidServerPacket.class, PlayerSetSquidServerPacket::decode);
        SplatcraftPacketHandler.registerMessage(PlayerSetSquidClientPacket.class, PlayerSetSquidClientPacket::decode);
        SplatcraftPacketHandler.registerMessage(UpdateBooleanGamerulesPacket.class, UpdateBooleanGamerulesPacket::decode);
        SplatcraftPacketHandler.registerMessage(RequestPlayerInfoPacket.class, RequestPlayerInfoPacket::decode);
        SplatcraftPacketHandler.registerMessage(SendScanTurfResultsPacket.class, SendScanTurfResultsPacket::decode);
        SplatcraftPacketHandler.registerMessage(UpdateColorScoresPacket.class, UpdateColorScoresPacket::decode);
        SplatcraftPacketHandler.registerMessage(UpdateBlockColorPacket.class, UpdateBlockColorPacket::decode);
        SplatcraftPacketHandler.registerMessage(DodgeRollPacket.class, DodgeRollPacket::decode);
    }

    private static <MSG extends SplatcraftPacket> void registerMessage(Class<MSG> messageType, Function<PacketBuffer, MSG> decoder) {
        SplatcraftPacketHandler.registerMessage(messageType, SplatcraftPacket::encode, decoder, SplatcraftPacket::consume);
    }

    private static <MSG> void registerMessage(Class<MSG> messageType, BiConsumer<MSG, PacketBuffer> encoder, Function<PacketBuffer, MSG> decoder, BiConsumer<MSG, Supplier<NetworkEvent.Context>> messageConsumer) {
        INSTANCE.registerMessage(ID++, messageType, encoder, decoder, messageConsumer);
    }

    public static <MSG> void sendToPlayer(MSG message, ServerPlayerEntity player) {
        INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), message);
    }

    public static <MSG> void sendToDim(MSG message, RegistryKey<World> world) {
        INSTANCE.send(PacketDistributor.DIMENSION.with(() -> world), message);
    }

    public static <MSG> void sendToDim(MSG message, World world) {
        SplatcraftPacketHandler.sendToDim(message, (RegistryKey<World>)world.func_234923_W_());
    }

    public static <MSG> void sendToAll(MSG message) {
        INSTANCE.send(PacketDistributor.ALL.noArg(), message);
    }

    public static <MSG> void sendToServer(MSG message) {
        INSTANCE.sendToServer(message);
    }
}

