/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.network;

import com.cibernet.splatcraft.network.base.PlayToServerPacket;
import com.cibernet.splatcraft.tileentities.InkVatTileEntity;
import com.cibernet.splatcraft.util.ColorUtils;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;

public class UpdateBlockColorPacket
extends PlayToServerPacket {
    BlockPos pos;
    int color;
    int inkVatPointer = -1;

    public UpdateBlockColorPacket(BlockPos pos, int color) {
        this.color = color;
        this.pos = pos;
    }

    public UpdateBlockColorPacket(BlockPos pos, int color, int pointer) {
        this(pos, color);
        this.inkVatPointer = pointer;
    }

    @Override
    public void execute(PlayerEntity player) {
        TileEntity te = player.field_70170_p.func_175625_s(this.pos);
        if (te instanceof InkVatTileEntity) {
            ((InkVatTileEntity)te).pointer = this.inkVatPointer;
        }
        ColorUtils.setInkColor(te, this.color);
    }

    public static UpdateBlockColorPacket decode(PacketBuffer buffer) {
        return new UpdateBlockColorPacket(new BlockPos(buffer.readInt(), buffer.readInt(), buffer.readInt()), buffer.readInt(), buffer.readInt());
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.pos.func_177958_n());
        buffer.writeInt(this.pos.func_177956_o());
        buffer.writeInt(this.pos.func_177952_p());
        buffer.writeInt(this.color);
        buffer.writeInt(this.inkVatPointer);
    }
}

