/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.network;

import com.cibernet.splatcraft.network.base.PlayToClientPacket;
import com.cibernet.splatcraft.registries.SplatcraftGameRules;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.GameRules;

public class UpdateBooleanGamerulesPacket
extends PlayToClientPacket {
    public TreeMap<Integer, Boolean> booleanRules;

    public UpdateBooleanGamerulesPacket(TreeMap<Integer, Boolean> booleanRules) {
        this.booleanRules = booleanRules;
    }

    public UpdateBooleanGamerulesPacket(final GameRules.RuleKey<GameRules.BooleanValue> rule, final boolean value) {
        this.booleanRules = new TreeMap<Integer, Boolean>(){
            {
                this.put(SplatcraftGameRules.getRuleIndex(rule), value);
            }
        };
    }

    @Override
    public void encode(PacketBuffer buffer) {
        Set<Map.Entry<Integer, Boolean>> entrySet = this.booleanRules.entrySet();
        buffer.writeInt(entrySet.size());
        for (Map.Entry<Integer, Boolean> rule : entrySet) {
            buffer.writeInt(rule.getKey().intValue());
            buffer.writeBoolean(rule.getValue().booleanValue());
        }
    }

    public static UpdateBooleanGamerulesPacket decode(PacketBuffer buffer) {
        TreeMap<Integer, Boolean> booleanRules = new TreeMap<Integer, Boolean>();
        int entrySize = buffer.readInt();
        for (int i = 0; i < entrySize; ++i) {
            booleanRules.put(buffer.readInt(), buffer.readBoolean());
        }
        return new UpdateBooleanGamerulesPacket(booleanRules);
    }

    @Override
    public void execute() {
        for (Map.Entry<Integer, Boolean> rule : this.booleanRules.entrySet()) {
            SplatcraftGameRules.booleanRules.put(rule.getKey(), rule.getValue());
        }
    }
}

