/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.registries;

import com.cibernet.splatcraft.client.renderer.InkProjectileRenderer;
import com.cibernet.splatcraft.client.renderer.InkSquidRenderer;
import com.cibernet.splatcraft.client.renderer.SquidBumperRenderer;
import com.cibernet.splatcraft.entities.InkProjectileEntity;
import com.cibernet.splatcraft.entities.InkSquidEntity;
import com.cibernet.splatcraft.entities.SquidBumperEntity;
import com.cibernet.splatcraft.registries.SplatcraftItems;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.GlobalEntityTypeAttributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.registries.IForgeRegistry;

@Mod.EventBusSubscriber(modid="splatcraft", bus=Mod.EventBusSubscriber.Bus.MOD)
public class SplatcraftEntities {
    public static final EntityType<InkProjectileEntity> INK_PROJECTILE = SplatcraftEntities.create("ink_projectile", InkProjectileEntity::new, EntityClassification.MISC);
    public static final EntityType<InkSquidEntity> INK_SQUID = SplatcraftEntities.create("ink_squid", InkSquidEntity::new, EntityClassification.AMBIENT, 0.6f, 0.6f);
    public static final EntityType<SquidBumperEntity> SQUID_BUMPER = SplatcraftEntities.create("squid_bumper", SquidBumperEntity::new, EntityClassification.MISC, 0.6f, 1.8f);

    @SubscribeEvent
    public static void registerEntities(RegistryEvent.Register<EntityType<?>> event) {
        IForgeRegistry registry = event.getRegistry();
        registry.register(INK_PROJECTILE);
        registry.register(INK_SQUID);
        registry.register(SQUID_BUMPER);
    }

    private static <T extends Entity> EntityType<T> create(String name, EntityType.IFactory<T> supplier, EntityClassification classification, float width, float height) {
        EntityType type = EntityType.Builder.func_220322_a(supplier, (EntityClassification)classification).func_220321_a(width, height).func_206830_a("splatcraft:" + name);
        type.setRegistryName(name);
        return type;
    }

    private static <T extends LivingEntity> EntityType<T> createLiving(String name, EntityType.IFactory<T> supplier, EntityClassification classification, float width, float height, Consumer<AttributeModifierMap> map) {
        EntityType type = EntityType.Builder.func_220322_a(supplier, (EntityClassification)classification).func_220321_a(width, height).func_206830_a("splatcraft:" + name);
        type.setRegistryName(name);
        return type;
    }

    private static <T extends Entity> EntityType<T> create(String name, EntityType.IFactory<T> supplier, EntityClassification classification) {
        return SplatcraftEntities.create(name, supplier, classification, 1.0f, 1.0f);
    }

    public static void bindRenderers() {
        RenderingRegistry.registerEntityRenderingHandler(INK_PROJECTILE, InkProjectileRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(INK_SQUID, InkSquidRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(SQUID_BUMPER, SquidBumperRenderer::new);
    }

    public static void setEntityAttributes() {
        GlobalEntityTypeAttributes.put(INK_SQUID, (AttributeModifierMap)InkSquidEntity.setCustomAttributes().func_233813_a_());
        GlobalEntityTypeAttributes.put(SQUID_BUMPER, (AttributeModifierMap)SquidBumperEntity.setCustomAttributes().func_233813_a_());
        GlobalEntityTypeAttributes.put((EntityType)EntityType.field_200729_aH, (AttributeModifierMap)SplatcraftEntities.getAttributeMutableMap((EntityType<? extends LivingEntity>)EntityType.field_200729_aH).func_233815_a_(SplatcraftItems.INK_SWIM_SPEED, 0.075).func_233813_a_());
    }

    protected static AttributeModifierMap.MutableAttribute getAttributeMutableMap(EntityType<? extends LivingEntity> entityType) {
        AttributeModifierMap.MutableAttribute result = new AttributeModifierMap.MutableAttribute();
        Object obj = ObfuscationReflectionHelper.getPrivateValue(AttributeModifierMap.class, (Object)GlobalEntityTypeAttributes.func_233835_a_(entityType), (String)"field_233802_a_");
        if (obj instanceof Map) {
            Map map = (Map)obj;
            for (Map.Entry entry : map.entrySet()) {
                result.func_233815_a_((Attribute)entry.getKey(), ((ModifiableAttributeInstance)entry.getValue()).func_111126_e());
            }
        }
        return result;
    }
}

