/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.registries;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.TreeMap;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class SplatcraftGameRules {
    public static final TreeMap<Integer, Boolean> booleanRules = new TreeMap();
    public static final ArrayList<GameRules.RuleKey> ruleList = new ArrayList();
    public static GameRules.RuleKey<GameRules.BooleanValue> INK_DECAY;
    public static GameRules.RuleKey<GameRules.BooleanValue> COLORED_PLAYER_NAMES;
    public static GameRules.RuleKey<GameRules.BooleanValue> KEEP_MATCH_ITEMS;
    public static GameRules.RuleKey<GameRules.BooleanValue> UNIVERSAL_INK;
    public static GameRules.RuleKey<GameRules.BooleanValue> DROP_CRATE_LOOT;
    public static GameRules.RuleKey<GameRules.BooleanValue> WATER_DAMAGE;
    public static GameRules.RuleKey<GameRules.BooleanValue> REQUIRE_INK_TANK;
    public static GameRules.RuleKey<GameRules.BooleanValue> INK_MOB_DAMAGE;
    public static GameRules.RuleKey<GameRules.BooleanValue> INK_FRIENDLY_FIRE;

    public static void registerGamerules() {
        INK_DECAY = SplatcraftGameRules.createBooleanRule("inkDecay", GameRules.Category.UPDATES, true);
        COLORED_PLAYER_NAMES = SplatcraftGameRules.createBooleanRule("coloredPlayerNames", GameRules.Category.PLAYER, false);
        KEEP_MATCH_ITEMS = SplatcraftGameRules.createBooleanRule("keepMatchItems", GameRules.Category.PLAYER, false);
        UNIVERSAL_INK = SplatcraftGameRules.createBooleanRule("universalInk", GameRules.Category.PLAYER, false);
        DROP_CRATE_LOOT = SplatcraftGameRules.createBooleanRule("dropCrateLoot", GameRules.Category.DROPS, false);
        WATER_DAMAGE = SplatcraftGameRules.createBooleanRule("waterDamage", GameRules.Category.PLAYER, false);
        REQUIRE_INK_TANK = SplatcraftGameRules.createBooleanRule("requireInkTank", GameRules.Category.PLAYER, true);
        INK_MOB_DAMAGE = SplatcraftGameRules.createBooleanRule("inkMobDamage", GameRules.Category.MOBS, false);
        INK_FRIENDLY_FIRE = SplatcraftGameRules.createBooleanRule("inkFriendlyFire", GameRules.Category.PLAYER, false);
    }

    public static GameRules.RuleKey<GameRules.BooleanValue> createBooleanRule(String name, GameRules.Category category, boolean defaultValue) {
        Method booleanValueCreate = ObfuscationReflectionHelper.findMethod(GameRules.BooleanValue.class, (String)"func_223568_b", (Class[])new Class[]{Boolean.TYPE});
        booleanValueCreate.setAccessible(true);
        try {
            Object booleanValue = booleanValueCreate.invoke(GameRules.BooleanValue.class, defaultValue);
            GameRules.RuleKey ruleKey = GameRules.func_234903_a_((String)("splatcraft." + name), (GameRules.Category)category, (GameRules.RuleType)((GameRules.RuleType)booleanValue));
            ruleList.add(ruleKey);
            booleanRules.put(SplatcraftGameRules.getRuleIndex(ruleKey), defaultValue);
            return ruleKey;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static int getRuleIndex(GameRules.RuleKey rule) {
        return ruleList.indexOf(rule);
    }

    public static GameRules.RuleKey getRuleFromIndex(int index) {
        return ruleList.get(index);
    }

    public static boolean getBooleanRuleValue(World world, GameRules.RuleKey<GameRules.BooleanValue> rule) {
        return world.field_72995_K ? SplatcraftGameRules.getClientsideValue(rule) : world.func_82736_K().func_223586_b(rule);
    }

    public static boolean getClientsideValue(GameRules.RuleKey<GameRules.BooleanValue> rule) {
        return booleanRules.get(SplatcraftGameRules.getRuleIndex(rule));
    }
}

