/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.registries;

import com.cibernet.splatcraft.client.model.ArmoredInkTankModel;
import com.cibernet.splatcraft.client.model.ClassicInkTankModel;
import com.cibernet.splatcraft.client.model.InkTankJrModel;
import com.cibernet.splatcraft.client.model.InkTankModel;
import com.cibernet.splatcraft.dispenser.PlaceBlockDispenseBehavior;
import com.cibernet.splatcraft.items.ColoredArmorItem;
import com.cibernet.splatcraft.items.ColoredBlockItem;
import com.cibernet.splatcraft.items.FilterItem;
import com.cibernet.splatcraft.items.InkTankItem;
import com.cibernet.splatcraft.items.PowerEggCanItem;
import com.cibernet.splatcraft.items.SquidBumperItem;
import com.cibernet.splatcraft.items.remotes.ColorChangerItem;
import com.cibernet.splatcraft.items.remotes.InkDisruptorItem;
import com.cibernet.splatcraft.items.remotes.RemoteItem;
import com.cibernet.splatcraft.items.remotes.TurfScannerItem;
import com.cibernet.splatcraft.items.weapons.BlasterItem;
import com.cibernet.splatcraft.items.weapons.DualieItem;
import com.cibernet.splatcraft.items.weapons.ShooterItem;
import com.cibernet.splatcraft.items.weapons.SlosherItem;
import com.cibernet.splatcraft.registries.SplatcraftBlocks;
import com.cibernet.splatcraft.registries.SplatcraftItemGroups;
import com.cibernet.splatcraft.util.SplatcraftArmorMaterial;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Blocks;
import net.minecraft.block.DispenserBlock;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemModelsProperties;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class SplatcraftItems {
    public static final List<Item> weapons = new ArrayList<Item>();
    public static final ArrayList<Item> inkColoredItems = new ArrayList();
    public static final Attribute INK_SWIM_SPEED = SplatcraftItems.createAttribute("ink_swim_speed", new RangedAttribute("attribute.splatcraft.ink_swim_speed", (double)0.7f, 0.0, 1024.0).func_233753_a_(true));
    public static final IArmorMaterial INK_CLOTH = new SplatcraftArmorMaterial("ink_cloth", SoundEvents.field_187728_s, 0, 0.0f, 0.0f);
    public static final IArmorMaterial ARMORED_INK_TANK = new SplatcraftArmorMaterial("armored_ink_tank", SoundEvents.field_187725_r, 3, 0.0f, 0.05f);
    public static final ShooterItem splattershot = new ShooterItem("splattershot", 1.05f, 0.75f, 12.0f, 4, 8.0f, 0.9f);
    public static final ShooterItem tentatekSplattershot = new ShooterItem("tentatek_splattershot", splattershot);
    public static final ShooterItem wasabiSplattershot = new ShooterItem("wasabi_splattershot", splattershot);
    public static final ShooterItem splattershotJr = new ShooterItem("splattershot_jr", 1.0f, 0.55f, 13.5f, 4, 6.5f, 0.5f);
    public static final ShooterItem aerosprayMG = new ShooterItem("aerospray_mg", 1.3f, 0.45f, 26.0f, 2, 4.8f, 0.5f);
    public static final ShooterItem getAerosprayRG = new ShooterItem("aerospray_rg", aerosprayMG);
    public static final ShooterItem gal52 = new ShooterItem("52_gal", 1.2f, 0.78f, 16.0f, 9, 10.4f, 1.3f);
    public static final ShooterItem gal52Deco = new ShooterItem("52_gal_deco", gal52);
    public static final ShooterItem gal96 = new ShooterItem("96_gal", 1.3f, 0.85f, 12.5f, 11, 12.4f, 2.5f);
    public static final ShooterItem gal96Deco = new ShooterItem("96_gal_deco", gal96);
    public static final BlasterItem blaster = new BlasterItem("blaster", 2.3f, 1.0f, 5.0f, 4, 20, 25.0f, 10.0f, 10.0f, 6);
    public static final BlasterItem grimBlaster = new BlasterItem("grim_blaster", blaster);
    public static final BlasterItem clashBlaster = new BlasterItem("clash_blaster", 1.8f, 1.2f, 5.0f, 1, 10, 12.0f, 6.0f, 4.0f, 4);
    public static final BlasterItem clashBlasterNeo = new BlasterItem("clash_blaster_neo", clashBlaster);
    public static final DualieItem splatDualie = new DualieItem("splat_dualies", 1.0f, 0.65f, 10.0f, 8, 6.0f, 0.75f, 1, 0.7f, 9.0f, 8, 30);
    public static final DualieItem enperrySplatDualie = new DualieItem("enperry_splat_dualies", splatDualie);
    public static final DualieItem dualieSquelcher = new DualieItem("dualie_squelchers", 0.9f, 0.74f, 11.5f, 12, 4.4f, 1.2f, 1, 0.7f, 5.0f, 6, 14);
    public static final SlosherItem slosher = new SlosherItem("slosher", 1.6f, 0.48f, 2, 8.0f, 14.0f, 3, 7.0f);
    public static final SlosherItem classicSlosher = new SlosherItem("classic_slosher", slosher);
    public static final SlosherItem sodaSlosher = new SlosherItem("soda_slosher", slosher);
    public static final SlosherItem triSlosher = new SlosherItem("tri_slosher", 1.65f, 0.444f, 3, 20.0f, 12.4f, 4, 6.0f);
    public static final InkTankItem inkTank = new InkTankItem("ink_tank", 100.0f);
    public static final InkTankItem classicInkTank = new InkTankItem("classic_ink_tank", inkTank);
    public static final InkTankItem inkTankJr = new InkTankItem("ink_tank_jr", 110.0f);
    public static final InkTankItem armoredInkTank = new InkTankItem("armored_ink_tank", 85.0f, ARMORED_INK_TANK);
    public static final Item inkClothHelmet = new ColoredArmorItem("ink_cloth_helmet", INK_CLOTH, EquipmentSlotType.HEAD);
    public static final Item inkClothChestplate = new ColoredArmorItem("ink_cloth_chestplate", INK_CLOTH, EquipmentSlotType.CHEST);
    public static final Item inkClothLeggings = new ColoredArmorItem("ink_cloth_leggings", INK_CLOTH, EquipmentSlotType.LEGS);
    public static final Item inkClothBoots = new ColoredArmorItem("ink_cloth_boots", INK_CLOTH, EquipmentSlotType.FEET);
    public static final Item splatfestBand = (Item)new Item(new Item.Properties().func_200917_a(1)).setRegistryName("splatfest_band");
    public static final Item sardinium = (Item)new Item(new Item.Properties().func_200916_a(SplatcraftItemGroups.GROUP_GENERAL)).setRegistryName("sardinium");
    public static final Item sardiniumBlock = (Item)new com.cibernet.splatcraft.items.BlockItem(SplatcraftBlocks.sardiniumBlock).setRegistryName("sardinium_block");
    public static final Item sardiniumOre = (Item)new com.cibernet.splatcraft.items.BlockItem(SplatcraftBlocks.sardiniumOre).setRegistryName("sardinium_ore");
    public static final Item powerEgg = (Item)new Item(new Item.Properties().func_200916_a(SplatcraftItemGroups.GROUP_GENERAL)).setRegistryName("power_egg");
    public static final Item powerEggCan = new PowerEggCanItem("power_egg_can");
    public static final Item powerEggBlock = (Item)new com.cibernet.splatcraft.items.BlockItem(SplatcraftBlocks.powerEggBlock).setRegistryName("power_egg_block");
    public static final Item emptyInkwell = (Item)new com.cibernet.splatcraft.items.BlockItem(SplatcraftBlocks.emptyInkwell).setRegistryName("empty_inkwell");
    public static final RemoteItem turfScanner = new TurfScannerItem("turf_scanner");
    public static final RemoteItem inkDisruptor = new InkDisruptorItem("ink_disruptor");
    public static final RemoteItem colorChanger = new ColorChangerItem("color_changer");
    public static final FilterItem emptyFilter = new FilterItem("filter");
    public static final FilterItem pastelFilter = new FilterItem("pastel_filter");
    public static final FilterItem organicFilter = new FilterItem("organic_filter");
    public static final FilterItem neonFilter = new FilterItem("neon_filter");
    public static final FilterItem enchantedFilter = new FilterItem("enchanted_filter", true, false);
    public static final FilterItem creativeFilter = new FilterItem("creative_filter", true, true);
    public static final Item inkVat = (Item)new com.cibernet.splatcraft.items.BlockItem(SplatcraftBlocks.inkVat).setRegistryName("ink_vat");
    public static final Item weaponWorkbench = (Item)new com.cibernet.splatcraft.items.BlockItem(SplatcraftBlocks.weaponWorkbench).setRegistryName("weapon_workbench");
    public static final Item inkwell = new ColoredBlockItem(SplatcraftBlocks.inkwell, "inkwell", 16, emptyInkwell);
    public static final Item grate = (Item)new com.cibernet.splatcraft.items.BlockItem(SplatcraftBlocks.grate).setRegistryName("grate");
    public static final Item grateRamp = (Item)new com.cibernet.splatcraft.items.BlockItem(SplatcraftBlocks.grateRamp).setRegistryName("grate_ramp");
    public static final Item barrierBar = (Item)new com.cibernet.splatcraft.items.BlockItem(SplatcraftBlocks.barrierBar).setRegistryName("barrier_bar");
    public static final Item inkedWool = new ColoredBlockItem(SplatcraftBlocks.inkedWool, "inked_wool", new Item.Properties(), Items.field_221603_aE);
    public static final Item canvas = (Item)new com.cibernet.splatcraft.items.BlockItem(SplatcraftBlocks.canvas).setRegistryName("canvas");
    public static final Item squidBumper = new SquidBumperItem("squid_bumper");
    public static final Item sunkenCrate = (Item)new com.cibernet.splatcraft.items.BlockItem(SplatcraftBlocks.sunkenCrate).setRegistryName("sunken_crate");
    public static final Item crate = (Item)new com.cibernet.splatcraft.items.BlockItem(SplatcraftBlocks.crate).setRegistryName("crate");
    public static final Item stageBarrier = (Item)new com.cibernet.splatcraft.items.BlockItem(SplatcraftBlocks.stageBarrier).setRegistryName("stage_barrier");
    public static final Item stageVoid = (Item)new com.cibernet.splatcraft.items.BlockItem(SplatcraftBlocks.stageVoid).setRegistryName("stage_void");

    @SubscribeEvent
    public static void itemInit(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        for (Item item : weapons) {
            registry.register((IForgeRegistryEntry)item);
        }
        registry.register((IForgeRegistryEntry)inkClothHelmet);
        registry.register((IForgeRegistryEntry)inkClothChestplate);
        registry.register((IForgeRegistryEntry)inkClothLeggings);
        registry.register((IForgeRegistryEntry)inkClothBoots);
        registry.register((IForgeRegistryEntry)splatfestBand);
        registry.register((IForgeRegistryEntry)sardinium);
        registry.register((IForgeRegistryEntry)sardiniumBlock);
        registry.register((IForgeRegistryEntry)sardiniumOre);
        registry.register((IForgeRegistryEntry)powerEgg);
        registry.register((IForgeRegistryEntry)powerEggCan);
        registry.register((IForgeRegistryEntry)powerEggBlock);
        registry.register((IForgeRegistryEntry)turfScanner);
        registry.register((IForgeRegistryEntry)inkDisruptor);
        registry.register((IForgeRegistryEntry)colorChanger);
        for (Item item : FilterItem.filters) {
            registry.register((IForgeRegistryEntry)item);
        }
        registry.register((IForgeRegistryEntry)inkVat);
        registry.register((IForgeRegistryEntry)weaponWorkbench);
        registry.register((IForgeRegistryEntry)emptyInkwell);
        registry.register((IForgeRegistryEntry)inkwell);
        registry.register((IForgeRegistryEntry)grate);
        registry.register((IForgeRegistryEntry)grateRamp);
        registry.register((IForgeRegistryEntry)barrierBar);
        registry.register((IForgeRegistryEntry)inkedWool);
        registry.register((IForgeRegistryEntry)canvas);
        registry.register((IForgeRegistryEntry)squidBumper);
        registry.register((IForgeRegistryEntry)sunkenCrate);
        registry.register((IForgeRegistryEntry)crate);
        registry.register((IForgeRegistryEntry)stageBarrier);
        registry.register((IForgeRegistryEntry)stageVoid);
        registry.register(new BlockItem(Blocks.field_150411_aY, new Item.Properties().func_200916_a(ItemGroup.field_78031_c)).setRegistryName("minecraft", "iron_bars"));
        DispenserBlock.func_199774_a((IItemProvider)inkwell, (IDispenseItemBehavior)new PlaceBlockDispenseBehavior());
        DispenserBlock.func_199774_a((IItemProvider)emptyInkwell, (IDispenseItemBehavior)new PlaceBlockDispenseBehavior());
    }

    public static void registerModelProperties() {
        ResourceLocation activeProperty = new ResourceLocation("splatcraft", "active");
        ResourceLocation modeProperty = new ResourceLocation("splatcraft", "mode");
        ResourceLocation inkProperty = new ResourceLocation("splatcraft", "ink");
        ResourceLocation isLeftProperty = new ResourceLocation("splatcraft", "is_left");
        for (RemoteItem remote : RemoteItem.remotes) {
            ItemModelsProperties.func_239418_a_((Item)remote, (ResourceLocation)activeProperty, (IItemPropertyGetter)remote.getActiveProperty());
            ItemModelsProperties.func_239418_a_((Item)remote, (ResourceLocation)modeProperty, (IItemPropertyGetter)remote.getModeProperty());
        }
        for (InkTankItem tank : InkTankItem.inkTanks) {
            ItemModelsProperties.func_239418_a_((Item)tank, (ResourceLocation)inkProperty, (stack, world, entity) -> InkTankItem.getInkAmount(stack) / tank.capacity);
        }
        for (DualieItem dualie : DualieItem.dualies) {
            ItemModelsProperties.func_239418_a_((Item)dualie, (ResourceLocation)isLeftProperty, (IItemPropertyGetter)dualie.getIsLeft());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerArmorModels() {
        inkTank.setArmorModel(new InkTankModel());
        classicInkTank.setArmorModel(new ClassicInkTankModel());
        inkTankJr.setArmorModel(new InkTankJrModel());
        armoredInkTank.setArmorModel(new ArmoredInkTankModel());
    }

    @SubscribeEvent
    public static void registerAttributes(RegistryEvent.Register<Attribute> event) {
        IForgeRegistry registry = event.getRegistry();
        registry.register((IForgeRegistryEntry)INK_SWIM_SPEED);
    }

    private static Attribute createAttribute(String id, Attribute attribute) {
        attribute.setRegistryName(id);
        return attribute;
    }
}

