/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.registries;

import com.cibernet.splatcraft.client.renderer.StageBarrierTileEntityRenderer;
import com.cibernet.splatcraft.registries.SplatcraftBlocks;
import com.cibernet.splatcraft.tileentities.CrateTileEntity;
import com.cibernet.splatcraft.tileentities.InkColorTileEntity;
import com.cibernet.splatcraft.tileentities.InkVatTileEntity;
import com.cibernet.splatcraft.tileentities.InkedBlockTileEntity;
import com.cibernet.splatcraft.tileentities.InkwellTileEntity;
import com.cibernet.splatcraft.tileentities.StageBarrierTileEntity;
import com.cibernet.splatcraft.tileentities.container.InkVatContainer;
import com.cibernet.splatcraft.tileentities.container.WeaponWorkbenchContainer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.IContainerFactory;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class SplatcraftTileEntitites {
    private static final List<TileEntityType> te_registry = new ArrayList<TileEntityType>();
    private static final List<ContainerType> c_registry = new ArrayList<ContainerType>();
    public static final TileEntityType<InkColorTileEntity> colorTileEntity = SplatcraftTileEntitites.registerTileEntity("color", InkColorTileEntity::new, SplatcraftBlocks.inkedWool, SplatcraftBlocks.canvas);
    public static final TileEntityType<InkwellTileEntity> inkwellTileEntity = SplatcraftTileEntitites.registerTileEntity("inkwell", InkwellTileEntity::new, SplatcraftBlocks.inkwell);
    public static final TileEntityType<InkedBlockTileEntity> inkedTileEntity = SplatcraftTileEntitites.registerTileEntity("inked_block", InkedBlockTileEntity::new, SplatcraftBlocks.inkedBlock);
    public static final TileEntityType<CrateTileEntity> crateTileEntity = SplatcraftTileEntitites.registerTileEntity("crate", CrateTileEntity::new, SplatcraftBlocks.crate, SplatcraftBlocks.sunkenCrate);
    public static final TileEntityType<StageBarrierTileEntity> stageBarrierTileEntity = SplatcraftTileEntitites.registerTileEntity("stage_barrier", StageBarrierTileEntity::new, SplatcraftBlocks.stageBarrier, SplatcraftBlocks.stageVoid);
    public static final TileEntityType<InkVatTileEntity> inkVatTileEntity = SplatcraftTileEntitites.registerTileEntity("ink_vat", InkVatTileEntity::new, SplatcraftBlocks.inkVat);
    public static final ContainerType<InkVatContainer> inkVatContainer = SplatcraftTileEntitites.registerContainer("ink_vat", InkVatContainer::new);
    public static final ContainerType<WeaponWorkbenchContainer> weaponWorkbenchContainer = SplatcraftTileEntitites.registerContainer("weapon_workbench", WeaponWorkbenchContainer::new);

    private static <T extends TileEntity> TileEntityType<T> registerTileEntity(String name, Supplier<T> factoryIn, Block ... allowedBlocks) {
        TileEntityType te = TileEntityType.Builder.func_223042_a(factoryIn, (Block[])allowedBlocks).func_206865_a(null);
        te.setRegistryName(name);
        te_registry.add(te);
        return te;
    }

    private static <T extends Container> ContainerType<T> registerContainer(String name, IContainerFactory<T> factoryIn) {
        ContainerType container = IForgeContainerType.create(factoryIn);
        container.setRegistryName(name);
        c_registry.add(container);
        return container;
    }

    @SubscribeEvent
    public static void tileEntityInit(RegistryEvent.Register<TileEntityType<?>> event) {
        IForgeRegistry registry = event.getRegistry();
        te_registry.forEach(te -> registry.register((IForgeRegistryEntry)te));
    }

    @SubscribeEvent
    public static void containerInit(RegistryEvent.Register<ContainerType<?>> event) {
        IForgeRegistry registry = event.getRegistry();
        c_registry.forEach(c -> registry.register((IForgeRegistryEntry)c));
    }

    public static void bindTESR() {
        ClientRegistry.bindTileEntityRenderer(stageBarrierTileEntity, StageBarrierTileEntityRenderer::new);
    }
}

