/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.tileentities;

import com.cibernet.splatcraft.blocks.CrateBlock;
import com.cibernet.splatcraft.registries.SplatcraftTileEntitites;
import com.cibernet.splatcraft.tileentities.InkColorTileEntity;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;

public class CrateTileEntity
extends InkColorTileEntity
implements IInventory {
    private float health;
    private float maxHealth;
    private boolean hasLoot;
    private NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a);

    public CrateTileEntity() {
        super(SplatcraftTileEntitites.crateTileEntity);
    }

    public void ink(int color, float damage) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.setColor(color);
        this.health -= damage;
        if (this.health <= 0.0f) {
            this.field_145850_b.func_175655_b(this.func_174877_v(), false);
            this.dropInventory();
        } else {
            this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a((Property)CrateBlock.STATE, (Comparable)Integer.valueOf(this.getState())), 2);
        }
    }

    public void onLoad() {
        super.onLoad();
    }

    public void dropInventory() {
        if (this.field_145850_b.func_82736_K().func_223586_b(GameRules.field_223603_f)) {
            this.getDrops().forEach(stack -> Block.func_180635_a((World)this.field_145850_b, (BlockPos)this.field_174879_c, (ItemStack)stack));
        }
    }

    public List<ItemStack> getDrops() {
        return this.hasLoot ? CrateBlock.generateLoot(this.field_145850_b, this.func_174877_v(), this.func_195044_w(), 0.0f) : this.getInventory();
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.health = nbt.func_74760_g("Health");
        this.maxHealth = nbt.func_74760_g("MaxHealth");
        ItemStackHelper.func_191283_b((CompoundNBT)nbt, this.inventory);
        if (state.func_177230_c() instanceof CrateBlock) {
            this.hasLoot = ((CrateBlock)state.func_177230_c()).hasLoot;
        }
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        nbt.func_74776_a("Health", this.health);
        nbt.func_74776_a("MaxHealth", this.maxHealth);
        ItemStackHelper.func_191282_a((CompoundNBT)nbt, this.inventory);
        return super.func_189515_b(nbt);
    }

    public int func_70302_i_() {
        return this.func_195044_w().func_177230_c() instanceof CrateBlock && ((CrateBlock)this.func_195044_w().func_177230_c()).hasLoot ? 0 : 1;
    }

    public boolean func_191420_l() {
        return this.inventory.isEmpty();
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.inventory.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        if (this.func_195044_w().func_177230_c() instanceof CrateBlock && ((CrateBlock)this.func_195044_w().func_177230_c()).hasLoot) {
            return ItemStack.field_190927_a;
        }
        ItemStack itemstack = ItemStackHelper.func_188382_a(this.inventory, (int)index, (int)count);
        if (!itemstack.func_190926_b()) {
            this.func_70296_d();
        }
        return itemstack;
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.inventory, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inventory.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        this.func_70296_d();
    }

    public boolean func_70300_a(PlayerEntity player) {
        return false;
    }

    public void func_174888_l() {
        this.inventory.clear();
    }

    public float getHealth() {
        return this.health;
    }

    public void setHealth(float value) {
        this.health = value;
    }

    public void resetHealth() {
        this.setHealth(this.maxHealth);
        this.setColor(-1);
    }

    public float getMaxHealth() {
        return this.maxHealth;
    }

    public void setMaxHealth(float value) {
        this.maxHealth = value;
    }

    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    public int getState() {
        if (this.health == this.maxHealth) {
            this.setColor(-1);
        }
        return 4 - Math.round(this.health * 4.0f / this.maxHealth);
    }

    public void setHasLoot(boolean hasLoot) {
        this.hasLoot = hasLoot;
    }
}

