/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.tileentities;

import com.cibernet.splatcraft.blocks.InkVatBlock;
import com.cibernet.splatcraft.data.tags.SplatcraftTags;
import com.cibernet.splatcraft.items.FilterItem;
import com.cibernet.splatcraft.registries.SplatcraftItems;
import com.cibernet.splatcraft.registries.SplatcraftTileEntitites;
import com.cibernet.splatcraft.tileentities.container.InkVatContainer;
import com.cibernet.splatcraft.util.ColorUtils;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.LockableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class InkVatTileEntity
extends LockableTileEntity
implements ISidedInventory,
ITickableTileEntity {
    private NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)5, (Object)ItemStack.field_190927_a);
    private int color = -1;
    public int pointer = -1;
    private int recipeEntries = 0;
    private static final int[] INPUT_SLOTS = new int[]{0, 1, 2, 3};
    private static final int[] OUTPUT_SLOTS = new int[]{4};
    LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((ISidedInventory)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});

    public InkVatTileEntity() {
        super(SplatcraftTileEntitites.inkVatTileEntity);
    }

    public void func_70296_d() {
        super.func_70296_d();
    }

    public int[] func_180463_a(Direction side) {
        return side == Direction.UP ? INPUT_SLOTS : OUTPUT_SLOTS;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, @Nullable Direction direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return index == 4;
    }

    public int func_70302_i_() {
        return this.inventory.size();
    }

    public boolean func_191420_l() {
        return this.inventory.stream().allMatch(ItemStack::func_190926_b);
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.inventory.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        if (index == 4 && !this.consumeIngredients(count)) {
            return ItemStack.field_190927_a;
        }
        ItemStack itemstack = ItemStackHelper.func_188382_a(this.inventory, (int)index, (int)count);
        if (!itemstack.func_190926_b()) {
            this.func_70296_d();
        }
        return itemstack;
    }

    public boolean consumeIngredients(int count) {
        if (((ItemStack)this.inventory.get(0)).func_190916_E() >= count && ((ItemStack)this.inventory.get(1)).func_190916_E() >= count && ((ItemStack)this.inventory.get(2)).func_190916_E() >= count) {
            this.func_70298_a(0, count);
            this.func_70298_a(1, count);
            this.func_70298_a(2, count);
            return true;
        }
        return false;
    }

    public void updateRecipeOutput() {
        if (this.hasRcipe()) {
            this.func_70299_a(4, ColorUtils.setInkColor(new ItemStack((IItemProvider)SplatcraftItems.inkwell, Math.min(SplatcraftItems.inkwell.func_77639_j(), Math.min(Math.min(((ItemStack)this.inventory.get(0)).func_190916_E(), ((ItemStack)this.inventory.get(1)).func_190916_E()), ((ItemStack)this.inventory.get(2)).func_190916_E()))), this.getColor()));
        } else {
            this.func_70299_a(4, ItemStack.field_190927_a);
        }
    }

    public boolean hasRcipe() {
        return !((ItemStack)this.inventory.get(0)).func_190926_b() && !((ItemStack)this.inventory.get(1)).func_190926_b() && !((ItemStack)this.inventory.get(2)).func_190926_b() && this.getColor() != -1;
    }

    public boolean hasOmniFilter() {
        Item filter = ((ItemStack)this.inventory.get(3)).func_77973_b();
        if (filter instanceof FilterItem) {
            return ((FilterItem)filter).isOmni();
        }
        return false;
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.inventory, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inventory.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        this.func_70296_d();
    }

    public boolean func_70300_a(PlayerEntity player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return !(player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) > 64.0);
    }

    public void func_174888_l() {
        this.inventory.clear();
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        switch (index) {
            case 0: {
                return ItemStack.func_179545_c((ItemStack)stack, (ItemStack)new ItemStack((IItemProvider)Items.field_196136_br));
            }
            case 1: {
                return ItemStack.func_179545_c((ItemStack)stack, (ItemStack)new ItemStack((IItemProvider)SplatcraftItems.powerEgg));
            }
            case 2: {
                return ItemStack.func_179545_c((ItemStack)stack, (ItemStack)new ItemStack((IItemProvider)SplatcraftItems.emptyInkwell));
            }
            case 3: {
                return SplatcraftTags.Items.FILTERS.func_230235_a_((Object)stack.func_77973_b());
            }
        }
        return false;
    }

    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        nbt.func_74768_a("Color", this.color);
        nbt.func_74768_a("Pointer", this.pointer);
        nbt.func_74768_a("RecipeEntries", this.recipeEntries);
        ItemStackHelper.func_191282_a((CompoundNBT)nbt, this.inventory);
        return super.func_189515_b(nbt);
    }

    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent("container.ink_vat");
    }

    protected Container func_213906_a(int id, PlayerInventory player) {
        return new InkVatContainer(id, player, this, false);
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.color = nbt.func_74762_e("Color");
        this.pointer = nbt.func_74762_e("Pointer");
        this.recipeEntries = nbt.func_74762_e("RecipeEntries");
        this.func_174888_l();
        ItemStackHelper.func_191283_b((CompoundNBT)nbt, this.inventory);
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        this.func_230337_a_(state, tag);
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), 2, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        if (this.field_145850_b != null) {
            BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 2);
            this.handleUpdateTag(state, pkt.func_148857_g());
        }
    }

    public void onRedstonePulse() {
        if (this.hasRcipe()) {
            this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 2);
            if (this.pointer != -1 && this.recipeEntries > 0) {
                this.pointer = (this.pointer + 1) % this.recipeEntries;
                this.setColor(InkVatContainer.sortRecipeList(InkVatContainer.getAvailableRecipes(this)).get(this.pointer));
            }
        }
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public void func_73660_a() {
        this.updateRecipeOutput();
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a((Property)InkVatBlock.ACTIVE, (Comparable)Boolean.valueOf(this.hasRcipe())));
        }
    }

    public int getRecipeEntries() {
        return this.recipeEntries;
    }

    public void setRecipeEntries(int v) {
        this.recipeEntries = v;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (!this.field_145846_f && facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == Direction.UP) {
                return this.handlers[0].cast();
            }
            if (facing == Direction.DOWN) {
                return this.handlers[1].cast();
            }
            return this.handlers[2].cast();
        }
        return super.getCapability(capability, facing);
    }

    public void func_145843_s() {
        super.func_145843_s();
        for (int x = 0; x < this.handlers.length; ++x) {
            this.handlers[x].invalidate();
        }
    }

    public boolean setColorAndUpdate(int color) {
        boolean changeState = Math.min(color, 0) != Math.min(this.getColor(), 0);
        this.setColor(color);
        if (changeState) {
            this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a((Property)InkVatBlock.ACTIVE, (Comparable)Boolean.valueOf(this.hasRcipe())), 2);
        } else {
            this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 2);
        }
        return true;
    }
}

