/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.tileentities.container;

import com.cibernet.splatcraft.blocks.InkVatBlock;
import com.cibernet.splatcraft.crafting.InkVatColorRecipe;
import com.cibernet.splatcraft.crafting.SplatcraftRecipeTypes;
import com.cibernet.splatcraft.data.tags.SplatcraftTags;
import com.cibernet.splatcraft.network.SplatcraftPacketHandler;
import com.cibernet.splatcraft.network.UpdateBlockColorPacket;
import com.cibernet.splatcraft.registries.SplatcraftBlocks;
import com.cibernet.splatcraft.registries.SplatcraftInkColors;
import com.cibernet.splatcraft.registries.SplatcraftItems;
import com.cibernet.splatcraft.registries.SplatcraftStats;
import com.cibernet.splatcraft.registries.SplatcraftTileEntitites;
import com.cibernet.splatcraft.tileentities.InkVatTileEntity;
import com.cibernet.splatcraft.util.InkColor;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class InkVatContainer
extends Container {
    public final InkVatTileEntity te;
    private final IWorldPosCallable callableInteract;
    private List<Integer> recipes = Lists.newArrayList();

    public InkVatContainer(int windowId, PlayerInventory playerInv, InkVatTileEntity te, boolean updateSelectedRecipe) {
        super(SplatcraftTileEntitites.inkVatContainer, windowId);
        int xx;
        this.te = te;
        this.callableInteract = IWorldPosCallable.func_221488_a((World)te.func_145831_w(), (BlockPos)te.func_174877_v());
        this.func_75146_a(new SlotInput(new ItemStack((IItemProvider)Items.field_196136_br, 1), (IInventory)te, 0, 26, 70));
        this.func_75146_a(new SlotInput(new ItemStack((IItemProvider)SplatcraftItems.powerEgg), (IInventory)te, 1, 46, 70));
        this.func_75146_a(new SlotInput(new ItemStack((IItemProvider)SplatcraftBlocks.emptyInkwell), (IInventory)te, 2, 92, 82));
        this.func_75146_a(new SlotFilter((IInventory)te, 3, 36, 89));
        this.func_75146_a(new SlotOutput(playerInv.field_70458_d, (IInventory)te, 4, 112, 82));
        for (xx = 0; xx < 9; ++xx) {
            for (int yy = 0; yy < 3; ++yy) {
                this.func_75146_a(new Slot((IInventory)playerInv, xx + yy * 9 + 9, 8 + xx * 18, 126 + yy * 18));
            }
        }
        for (xx = 0; xx < 9; ++xx) {
            this.func_75146_a(new Slot((IInventory)playerInv, xx, 8 + xx * 18, 184));
        }
        if (updateSelectedRecipe) {
            this.updateSelectedRecipe();
        }
    }

    public InkVatContainer(int windowId, PlayerInventory inv, PacketBuffer buffer) {
        this(windowId, inv, InkVatContainer.getTileEntity(inv, buffer), true);
    }

    private static InkVatTileEntity getTileEntity(PlayerInventory inventory, PacketBuffer buffer) {
        Objects.requireNonNull(inventory);
        Objects.requireNonNull(buffer);
        TileEntity te = inventory.field_70458_d.field_70170_p.func_175625_s(buffer.func_179259_c());
        if (te instanceof InkVatTileEntity) {
            return (InkVatTileEntity)te;
        }
        throw new IllegalStateException("TileEntity is not correct " + te);
    }

    public boolean func_75140_a(PlayerEntity playerIn, int id) {
        if (this.isIndexInBounds(id)) {
            this.te.pointer = id;
            this.updateRecipeResult();
        }
        return true;
    }

    public void updateSelectedRecipe() {
        boolean i = false;
        int teColor = this.te.getColor();
        this.updateInkVatColor(this.te.pointer, this.te.pointer == -1 ? -1 : teColor);
    }

    public void updateInkVatColor(int pointer, int color) {
        this.te.pointer = pointer;
        if (this.te.func_145831_w().field_72995_K) {
            SplatcraftPacketHandler.sendToServer(new UpdateBlockColorPacket(this.te.func_174877_v(), color, pointer));
        } else if (this.te.func_195044_w().func_177230_c() instanceof InkVatBlock) {
            ((InkVatBlock)this.te.func_195044_w().func_177230_c()).setColor(this.te.func_145831_w(), this.te.func_174877_v(), color);
        }
    }

    public int getSelectedRecipe() {
        return this.te.pointer;
    }

    public static List<Integer> getRecipeList(InkVatTileEntity te) {
        return InkVatContainer.hasIngredients(te) ? InkVatContainer.getAvailableRecipes(te) : Collections.EMPTY_LIST;
    }

    public List<Integer> getRecipeList() {
        return InkVatContainer.hasIngredients(this.te) ? this.recipes : Collections.EMPTY_LIST;
    }

    public static boolean hasIngredients(InkVatTileEntity te) {
        return !te.func_70301_a(0).func_190926_b() && !te.func_70301_a(1).func_190926_b() && !te.func_70301_a(2).func_190926_b();
    }

    public int getRecipeListSize() {
        return this.recipes.size();
    }

    public List<Integer> sortRecipeList() {
        return InkVatContainer.sortRecipeList(this.getRecipeList());
    }

    public static List<Integer> sortRecipeList(List<Integer> list) {
        list.sort((o1, o2) -> {
            if (InkColor.getByHex(o1) != null) {
                if (InkColor.getByHex(o2) != null) {
                    return InkColor.getByHex(o1).compareTo(InkColor.getByHex(o2));
                }
                return -1;
            }
            if (InkColor.getByHex(o2) != null) {
                return 1;
            }
            return o1 - o2;
        });
        return list;
    }

    private void updateAvailableRecipes() {
        this.te.pointer = -1;
        this.te.setColorAndUpdate(-1);
        this.recipes = InkVatContainer.getAvailableRecipes(this.te);
        this.te.setRecipeEntries(this.recipes.size());
    }

    public static List<Integer> getAvailableRecipes(InkVatTileEntity te) {
        List<Object> recipes = Lists.newArrayList();
        if (te.hasOmniFilter()) {
            recipes = InkVatContainer.getOmniList();
        } else {
            for (InkVatColorRecipe recipe : te.func_145831_w().func_199532_z().func_215370_b(SplatcraftRecipeTypes.INK_VAT_COLOR_CRAFTING_TYPE, (IInventory)te, te.func_145831_w())) {
                if (!recipe.func_77569_a((IInventory)te, te.func_145831_w())) continue;
                recipes.add(recipe.getOutputColor());
            }
        }
        return recipes;
    }

    public static List<Integer> getOmniList() {
        ArrayList list = Lists.newArrayList();
        list.addAll(InkVatColorRecipe.getOmniList());
        for (InkColor color : SplatcraftInkColors.REGISTRY) {
            int c = color.getColor();
            if (list.contains(c)) continue;
            list.add(c);
        }
        return list;
    }

    private void updateRecipeResult() {
        if (!this.recipes.isEmpty() && this.isIndexInBounds(this.te.pointer)) {
            this.te.setColorAndUpdate(this.recipes.get(this.te.pointer));
        } else {
            this.te.setColorAndUpdate(-1);
        }
        this.func_75142_b();
    }

    private boolean isIndexInBounds(int i) {
        return i >= 0 && i < this.recipes.size();
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return InkVatContainer.func_216963_a((IWorldPosCallable)this.callableInteract, (PlayerEntity)playerIn, (Block)SplatcraftBlocks.inkVat);
    }

    public void func_75137_b(int id, int data) {
        super.func_75137_b(id, data);
    }

    public void func_75130_a(IInventory inventoryIn) {
        super.func_75130_a(inventoryIn);
    }

    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (index == 4) {
                NonNullList inv = this.func_75138_a();
                int countA = ((ItemStack)inv.get(0)).func_190916_E();
                int countB = ((ItemStack)inv.get(1)).func_190916_E();
                int countC = ((ItemStack)inv.get(2)).func_190916_E();
                int itemCount = Math.min(Math.max(0, Math.min(countA, Math.min(countB, countC))), Item.func_150898_a((Block)SplatcraftBlocks.inkwell).func_77639_j());
                itemstack1.func_190920_e(itemCount);
                if (this.func_75135_a(itemstack1, 5, this.field_75151_b.size(), true) && itemCount > 0) {
                    this.te.func_70298_a(0, itemCount);
                    this.te.func_70298_a(1, itemCount);
                    this.te.func_70298_a(2, itemCount);
                    playerIn.func_195067_a(SplatcraftStats.INKWELLS_CRAFTED, itemCount);
                }
                return ItemStack.field_190927_a;
            }
            if (index < 4 ? !this.func_75135_a(itemstack1, 5, this.field_75151_b.size(), true) : !this.func_75135_a(itemstack1, 0, 5, false)) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
        }
        return itemstack;
    }

    class SlotOutput
    extends Slot {
        PlayerEntity player;

        public SlotOutput(PlayerEntity player, IInventory inventoryIn, int index, int xPosition, int yPosition) {
            super(inventoryIn, index, xPosition, yPosition);
            this.player = player;
        }

        public boolean func_75214_a(ItemStack stack) {
            return false;
        }

        public ItemStack func_75209_a(int amount) {
            this.player.func_195067_a(SplatcraftStats.INKWELLS_CRAFTED, amount);
            return super.func_75209_a(amount);
        }
    }

    class SlotFilter
    extends Slot {
        public SlotFilter(IInventory inventoryIn, int index, int xPosition, int yPosition) {
            super(inventoryIn, index, xPosition, yPosition);
        }

        public boolean func_75214_a(ItemStack stack) {
            return SplatcraftTags.Items.FILTERS.func_230235_a_((Object)stack.func_77973_b());
        }

        public void func_75218_e() {
            super.func_75218_e();
            InkVatContainer.this.updateAvailableRecipes();
        }
    }

    class SlotInput
    extends Slot {
        final ItemStack validItem;

        public SlotInput(ItemStack validItem, IInventory inventoryIn, int index, int xPosition, int yPosition) {
            super(inventoryIn, index, xPosition, yPosition);
            this.validItem = validItem;
        }

        public boolean func_75214_a(ItemStack stack) {
            return stack.func_77969_a(this.validItem);
        }
    }
}

