/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.util;

import com.cibernet.splatcraft.items.InkTankItem;
import com.cibernet.splatcraft.items.weapons.WeaponBaseItem;
import com.cibernet.splatcraft.registries.SplatcraftGameRules;
import com.cibernet.splatcraft.util.ClientPlayerSound;
import com.cibernet.splatcraft.util.PlayerCooldown;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.MovementInput;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;

public class ClientUtils {
    public static PlayerEntity getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    public static boolean showDurabilityBar(ItemStack stack) {
        return ClientUtils.getClientPlayer().func_184586_b(Hand.MAIN_HAND).equals(stack) && ClientUtils.getDurabilityForDisplay(stack) > 0.0;
    }

    public static double getDurabilityForDisplay(ItemStack stack) {
        PlayerEntity player = ClientUtils.getClientPlayer();
        if (!SplatcraftGameRules.getBooleanRuleValue(player.field_70170_p, SplatcraftGameRules.REQUIRE_INK_TANK)) {
            return 0.0;
        }
        ItemStack chestpiece = player.func_184582_a(EquipmentSlotType.CHEST);
        if (chestpiece.func_77973_b() instanceof InkTankItem) {
            return 1.0f - WeaponBaseItem.getInkAmount((LivingEntity)player, stack) / ((InkTankItem)chestpiece.func_77973_b()).capacity;
        }
        return 1.0;
    }

    public static void playClientSound(BlockPos pos, SoundEvent soundIn, SoundCategory category, float volume, float pitch) {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new ClientPlayerSound(soundIn, category, volume, pitch));
    }

    public static boolean canPerformRoll(PlayerEntity entity) {
        MovementInput input = ((ClientPlayerEntity)entity).field_71158_b;
        return !PlayerCooldown.hasPlayerCooldown(entity) && input.field_78901_c && (input.field_78902_a != 0.0f || input.field_192832_b != 0.0f);
    }

    public static Vector3d getDodgeRollVector(PlayerEntity entity) {
        MovementInput input = ((ClientPlayerEntity)entity).field_71158_b;
        return new Vector3d((double)input.field_78902_a, (double)-0.4f, (double)input.field_192832_b);
    }
}

