/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.util;

import com.cibernet.splatcraft.blocks.IColoredBlock;
import com.cibernet.splatcraft.capabilities.playerinfo.PlayerInfoCapability;
import com.cibernet.splatcraft.data.tags.SplatcraftTags;
import com.cibernet.splatcraft.entities.IColoredEntity;
import com.cibernet.splatcraft.handlers.ScoreboardHandler;
import com.cibernet.splatcraft.network.PlayerColorPacket;
import com.cibernet.splatcraft.network.SplatcraftPacketHandler;
import com.cibernet.splatcraft.registries.SplatcraftGameRules;
import com.cibernet.splatcraft.registries.SplatcraftInkColors;
import com.cibernet.splatcraft.tileentities.InkColorTileEntity;
import com.cibernet.splatcraft.util.InkColor;
import java.util.Random;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class ColorUtils {
    public static final int ORANGE = 14640154;
    public static final int BLUE = 2499231;
    public static final int GREEN = 13122937;
    public static final int PINK = 4234555;
    public static final int DEFAULT = 2039597;
    public static final int[] STARTER_COLORS = new int[]{14640154, 2499231, 13122937, 4234555};

    public static int getEntityColor(LivingEntity entity) {
        if (entity instanceof PlayerEntity) {
            return ColorUtils.getPlayerColor((PlayerEntity)entity);
        }
        if (entity instanceof IColoredEntity) {
            return ((IColoredEntity)entity).getColor();
        }
        return -1;
    }

    public static int getPlayerColor(PlayerEntity player) {
        try {
            return PlayerInfoCapability.get((LivingEntity)player).getColor();
        }
        catch (NullPointerException e) {
            return 0;
        }
    }

    public static void setPlayerColor(PlayerEntity player, int color, boolean updateClient) {
        PlayerInfoCapability.get((LivingEntity)player).setColor(color);
        ScoreboardHandler.updatePlayerColorScore(player, color);
        World world = player.field_70170_p;
        if (!world.field_72995_K && updateClient) {
            SplatcraftPacketHandler.sendToDim(new PlayerColorPacket(player, color), world);
        }
    }

    public static void setPlayerColor(PlayerEntity player, int color) {
        ColorUtils.setPlayerColor(player, color, true);
    }

    public static int getInkColor(ItemStack stack) {
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt == null || !nbt.func_74764_b("Color")) {
            return -1;
        }
        return nbt.func_74762_e("Color");
    }

    public static ItemStack setInkColor(ItemStack stack, int color) {
        stack.func_196082_o().func_74768_a("Color", color);
        return stack;
    }

    public static int getInkColor(TileEntity te) {
        if (te == null) {
            return -1;
        }
        if (te instanceof InkColorTileEntity) {
            return ((InkColorTileEntity)te).getColor();
        }
        if (te.func_195044_w() != null && te.func_195044_w().func_177230_c() instanceof IColoredBlock) {
            return ((IColoredBlock)te.func_195044_w().func_177230_c()).getColor(te.func_145831_w(), te.func_174877_v());
        }
        return -1;
    }

    public static boolean setInkColor(TileEntity te, int color) {
        if (te instanceof InkColorTileEntity) {
            ((InkColorTileEntity)te).setColor(color);
            return true;
        }
        if (te.func_195044_w() != null && te.func_195044_w().func_177230_c() instanceof IColoredBlock) {
            return ((IColoredBlock)te.func_195044_w().func_177230_c()).setColor(te.func_145831_w(), te.func_174877_v(), color);
        }
        return false;
    }

    public static String getColorName(int color) {
        InkColor colorObj = InkColor.getByHex(color);
        String colorFormatting = "";
        if (colorObj != null) {
            return colorObj.getLocalizedName();
        }
        String fallbackUnloc = "ink_color." + String.format("%06X", color).toLowerCase();
        String fallbackName = I18n.func_135052_a((String)fallbackUnloc, (Object[])new Object[0]);
        if (!fallbackName.equals(fallbackUnloc)) {
            return fallbackUnloc;
        }
        return "#" + String.format("%06X", color).toUpperCase();
    }

    public static ITextComponent getFormatedColorName(int color, boolean colorless) {
        if (color == 2039597) {
            return new StringTextComponent((colorless ? TextFormatting.GRAY : "") + ColorUtils.getColorName(color));
        }
        return new StringTextComponent(ColorUtils.getColorName(color)).func_230530_a_(Style.field_240709_b_.func_240718_a_(Color.func_240743_a_((int)color)));
    }

    public static boolean colorEquals(LivingEntity entity, TileEntity te) {
        int a = ColorUtils.getEntityColor(entity);
        int b = ColorUtils.getInkColor(te);
        if (a == -1 || b == -1) {
            return false;
        }
        return SplatcraftGameRules.getBooleanRuleValue(entity.field_70170_p, SplatcraftGameRules.UNIVERSAL_INK) ? true : a == b;
    }

    public static boolean colorEquals(LivingEntity entity, ItemStack te) {
        int a = ColorUtils.getEntityColor(entity);
        int b = ColorUtils.getInkColor(te);
        if (a == -1 || b == -1) {
            return false;
        }
        return SplatcraftGameRules.getBooleanRuleValue(entity.field_70170_p, SplatcraftGameRules.UNIVERSAL_INK) ? true : a == b;
    }

    public static ItemStack setColorLocked(ItemStack stack, boolean isLocked) {
        stack.func_196082_o().func_74757_a("ColorLocked", isLocked);
        return stack;
    }

    public static boolean isColorLocked(ItemStack stack) {
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt == null || !nbt.func_74764_b("ColorLocked")) {
            return false;
        }
        return nbt.func_74767_n("ColorLocked");
    }

    public static float[] hexToRGB(int color) {
        float r = (float)((color & 0xFF0000) >> 16) / 255.0f;
        float g = (float)((color & 0xFF00) >> 8) / 255.0f;
        float b = (float)((color & 0xFF) >> 0) / 255.0f;
        return new float[]{r, g, b};
    }

    public static int getRandomStarterColor() {
        return SplatcraftTags.InkColors.STARTER_COLORS.func_230236_b_().isEmpty() ? SplatcraftInkColors.undyed.getColor() : ((InkColor)SplatcraftTags.InkColors.STARTER_COLORS.func_205596_a(new Random())).getColor();
    }
}

