/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.util;

import com.cibernet.splatcraft.blocks.AbstractSquidPassthroughBlock;
import com.cibernet.splatcraft.blocks.IColoredBlock;
import com.cibernet.splatcraft.blocks.InkedBlock;
import com.cibernet.splatcraft.data.tags.SplatcraftTags;
import com.cibernet.splatcraft.registries.SplatcraftBlocks;
import com.cibernet.splatcraft.registries.SplatcraftItems;
import com.cibernet.splatcraft.registries.SplatcraftStats;
import com.cibernet.splatcraft.tileentities.InkColorTileEntity;
import com.cibernet.splatcraft.tileentities.InkedBlockTileEntity;
import com.cibernet.splatcraft.util.ColorUtils;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.block.BarrierBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class InkBlockUtils {
    public static TreeMap<InkType, InkBlocks> inkTypeMap = new TreeMap<InkType, InkBlocks>(){
        {
            this.put(InkType.NORMAL, new InkBlocks(SplatcraftBlocks.inkedBlock).put(StairsBlock.class, SplatcraftBlocks.inkedStairs).put(SlabBlock.class, SplatcraftBlocks.inkedSlab));
            this.put(InkType.GLOWING, new InkBlocks(SplatcraftBlocks.glowingInkedBlock).put(StairsBlock.class, SplatcraftBlocks.glowingInkedStairs).put(SlabBlock.class, SplatcraftBlocks.glowingInkedSlab));
        }
    };

    public static boolean playerInkBlock(PlayerEntity player, World world, BlockPos pos, int color, float damage, InkType inkType) {
        boolean inked = InkBlockUtils.inkBlock(world, pos, color, damage, inkType);
        if (inked) {
            player.func_195066_a(SplatcraftStats.BLOCKS_INKED);
        }
        return inked;
    }

    public static boolean inkBlock(World world, BlockPos pos, int color, float damage, InkType inkType) {
        BlockState state = world.func_180495_p(pos);
        TileEntity te = world.func_175625_s(pos);
        if (InkedBlock.isTouchingLiquid((IBlockReader)world, pos)) {
            return false;
        }
        if (state.func_177230_c() instanceof IColoredBlock) {
            return ((IColoredBlock)state.func_177230_c()).inkBlock(world, pos, color, damage, inkType);
        }
        if (!InkBlockUtils.canInk(world, pos)) {
            return false;
        }
        world.func_180501_a(pos, InkBlockUtils.getInkState(inkType, state), 3);
        world.func_175690_a(pos, SplatcraftBlocks.inkedBlock.createTileEntity(SplatcraftBlocks.inkedBlock.func_176223_P(), (IBlockReader)world));
        InkedBlockTileEntity inkte = (InkedBlockTileEntity)world.func_175625_s(pos);
        if (inkte == null) {
            return false;
        }
        inkte.setColor(color);
        inkte.setSavedState(state);
        return true;
    }

    public static BlockState getInkState(InkType type, BlockState baseState) {
        BlockState inkState = InkBlockUtils.getInkBlock(type, baseState.func_177230_c()).func_176223_P();
        for (Property property : baseState.func_235904_r_()) {
            if (!inkState.func_235901_b_(property)) continue;
            inkState = InkBlockUtils.mergeProperty(inkState, baseState, property);
        }
        return inkState;
    }

    private static <T extends Comparable<T>> BlockState mergeProperty(BlockState state, BlockState baseState, Property<T> property) {
        Comparable value = baseState.func_177229_b(property);
        return (BlockState)state.func_206870_a(property, value);
    }

    public static boolean canInk(World world, BlockPos pos) {
        if (InkedBlock.isTouchingLiquid((IBlockReader)world, pos)) {
            return false;
        }
        Block block = world.func_180495_p(pos).func_177230_c();
        if (SplatcraftTags.Blocks.UNINKABLE_BLOCKS.func_230235_a_((Object)block)) {
            return false;
        }
        if (block instanceof StairsBlock || block instanceof SlabBlock || block instanceof BarrierBlock) {
            return true;
        }
        if (!(world.func_175625_s(pos) instanceof InkColorTileEntity) && world.func_175625_s(pos) != null) {
            return false;
        }
        if (SplatcraftTags.Blocks.INKABLE_BLOCKS.func_230235_a_((Object)block)) {
            return true;
        }
        if (InkBlockUtils.canInkPassthrough(world, pos)) {
            return false;
        }
        if (!world.func_180495_p(pos).func_200015_d((IBlockReader)world, pos)) {
            return false;
        }
        return !block.func_220074_n(world.func_180495_p(pos));
    }

    public static boolean canInkPassthrough(World world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() instanceof AbstractSquidPassthroughBlock) {
            return true;
        }
        return state.func_196952_d((IBlockReader)world, pos).func_197766_b();
    }

    public static boolean canSquidHide(LivingEntity entity) {
        return entity.func_233570_aj_() && InkBlockUtils.canSquidSwim(entity) || InkBlockUtils.canSquidClimb(entity);
    }

    public static boolean canSquidSwim(LivingEntity entity) {
        boolean canSwim = false;
        if (entity.field_70170_p.func_180495_p(entity.func_233580_cy_().func_177977_b()).func_177230_c() instanceof IColoredBlock) {
            canSwim = ((IColoredBlock)entity.field_70170_p.func_180495_p(entity.func_233580_cy_().func_177977_b()).func_177230_c()).canSwim();
        }
        if (canSwim) {
            return ColorUtils.colorEquals(entity, entity.field_70170_p.func_175625_s(entity.func_233580_cy_().func_177977_b()));
        }
        return false;
    }

    public static boolean onEnemyInk(LivingEntity entity) {
        boolean canDamage = false;
        if (entity.field_70170_p.func_180495_p(entity.func_233580_cy_().func_177977_b()).func_177230_c() instanceof IColoredBlock) {
            canDamage = ((IColoredBlock)entity.field_70170_p.func_180495_p(entity.func_233580_cy_().func_177977_b()).func_177230_c()).canDamage();
        }
        return canDamage && ColorUtils.getInkColor(entity.field_70170_p.func_175625_s(entity.func_233580_cy_().func_177977_b())) != -1 && !InkBlockUtils.canSquidSwim(entity);
    }

    public static boolean canSquidClimb(LivingEntity entity) {
        if (InkBlockUtils.onEnemyInk(entity)) {
            return false;
        }
        for (int i = 0; i < 4; ++i) {
            float xOff = (i < 2 ? 0.32f : 0.0f) * (float)(i % 2 == 0 ? 1 : -1);
            float zOff = (i < 2 ? 0.0f : 0.32f) * (float)(i % 2 == 0 ? 1 : -1);
            BlockPos pos = new BlockPos(entity.func_226277_ct_() - (double)xOff, entity.func_226278_cu_(), entity.func_226281_cx_() - (double)zOff);
            Block block = entity.field_70170_p.func_180495_p(pos).func_177230_c();
            if (block instanceof IColoredBlock && (!(block instanceof IColoredBlock) || !((IColoredBlock)block).canClimb()) || !(entity.field_70170_p.func_175625_s(pos) instanceof InkColorTileEntity) || ((InkColorTileEntity)entity.field_70170_p.func_175625_s(pos)).getColor() != ColorUtils.getEntityColor(entity) || entity.func_184218_aH()) continue;
            return true;
        }
        return false;
    }

    public static InkType getInkType(LivingEntity entity) {
        if (entity instanceof PlayerEntity && ((PlayerEntity)entity).field_71071_by.func_70431_c(new ItemStack((IItemProvider)SplatcraftItems.splatfestBand))) {
            return InkType.GLOWING;
        }
        return InkType.NORMAL;
    }

    public static Block getInkBlock(InkType inkType, Block baseBlock) {
        return inkTypeMap.get(inkType).get(baseBlock);
    }

    public static class InkBlocks {
        Block defaultBlock;
        final List<Map.Entry<Class<? extends Block>, Block>> blockMap = new ArrayList<Map.Entry<Class<? extends Block>, Block>>();

        public InkBlocks(Block defaultBlock) {
            this.defaultBlock = defaultBlock;
        }

        public Block get(Block block) {
            if (this.blockMap.isEmpty()) {
                return this.defaultBlock;
            }
            for (Map.Entry<Class<? extends Block>, Block> entry : this.blockMap) {
                if (!entry.getKey().isInstance(block)) continue;
                return entry.getValue();
            }
            return this.defaultBlock;
        }

        public InkBlocks put(Class<? extends Block> blockClass, Block block) {
            this.blockMap.add(new AbstractMap.SimpleEntry<Class<? extends Block>, Block>(blockClass, block));
            return this;
        }
    }

    public static class InkType
    implements Comparable<InkType> {
        public static final ArrayList<InkType> values = new ArrayList();
        public static final InkType NORMAL = new InkType();
        public static final InkType GLOWING = new InkType();

        public InkType() {
            values.add(this);
        }

        @Override
        public int compareTo(InkType o) {
            return values.indexOf(this) - values.indexOf(o);
        }

        public int getIndex() {
            return values.indexOf(this);
        }
    }
}

