/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.util;

import java.util.TreeMap;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.DyeColor;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class InkColor
extends ForgeRegistryEntry<InkColor>
implements Comparable<InkColor> {
    private final int hexCode;
    private final String name;
    private final DyeColor dyeColor;
    private final int ID;
    private static int idIndex = 0;
    private static final TreeMap<Integer, InkColor> colorMap = new TreeMap();

    public InkColor(String name, int color, @Nullable DyeColor dyeColor) {
        this.hexCode = color;
        this.name = name;
        this.dyeColor = dyeColor;
        this.ID = idIndex++;
        colorMap.put(color, this);
        this.setRegistryName(name);
    }

    public static InkColor getByHex(int hexCode) {
        return colorMap.get(hexCode);
    }

    public InkColor(String name, int color) {
        this(name, color, null);
    }

    public String getLocalizedName() {
        return I18n.func_135052_a((String)this.getUnlocalizedName(), (Object[])new Object[0]);
    }

    public String getUnlocalizedName() {
        return "ink_color." + this.getRegistryName().func_110624_b() + "." + this.getRegistryName().func_110623_a();
    }

    public String getHexCode() {
        return String.format("%06X", this.hexCode);
    }

    public int getColor() {
        return this.hexCode;
    }

    @Nullable
    public DyeColor getDyeColor() {
        return this.dyeColor;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name + ": #" + this.getHexCode().toUpperCase();
    }

    @Override
    public int compareTo(InkColor other) {
        return this.ID - other.ID;
    }

    public static class DummyType
    extends InkColor {
        public DummyType() {
            super("dummy", 2039597);
        }
    }
}

