/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.util;

import com.cibernet.splatcraft.entities.IColoredEntity;
import com.cibernet.splatcraft.registries.SplatcraftGameRules;
import com.cibernet.splatcraft.util.ColorUtils;
import com.cibernet.splatcraft.util.InkBlockUtils;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class InkDamageUtils {
    public static final DamageSource VOID_DAMAGE = new DamageSource("outOfWorld").func_76348_h();
    public static final DamageSource ENEMY_INK = new DamageSource("enemyInk");
    public static final DamageSource WATER = new DamageSource("water");

    public static boolean doSplatDamage(World world, LivingEntity target, float damage, int color, Entity source, ItemStack sourceItem, boolean damageMobs, InkBlockUtils.InkType inkType) {
        return InkDamageUtils.doDamage(world, target, damage, color, source, sourceItem, damageMobs, inkType, "splat");
    }

    public static boolean doRollDamage(World world, LivingEntity target, float damage, int color, Entity source, ItemStack sourceItem, boolean damageMobs, InkBlockUtils.InkType inkType) {
        return InkDamageUtils.doDamage(world, target, damage, color, source, sourceItem, damageMobs, inkType, "roll");
    }

    public static boolean doDamage(World world, LivingEntity target, float damage, int color, Entity source, ItemStack sourceItem, boolean damageMobs, InkBlockUtils.InkType inkType, String name) {
        if (damage == 0.0f) {
            return false;
        }
        boolean doDamage = damageMobs || SplatcraftGameRules.getBooleanRuleValue(world, SplatcraftGameRules.INK_MOB_DAMAGE);
        int targetColor = ColorUtils.getEntityColor(target);
        if (targetColor > -1) {
            doDamage = targetColor != color || SplatcraftGameRules.getBooleanRuleValue(world, SplatcraftGameRules.INK_FRIENDLY_FIRE);
        }
        InkDamageSource damageSource = new InkDamageSource(name, source, source, sourceItem);
        if (target instanceof IColoredEntity) {
            doDamage = ((IColoredEntity)target).onEntityInked(damageSource, damage);
        }
        if (doDamage) {
            target.func_70097_a((DamageSource)damageSource, damage);
        }
        return doDamage;
    }

    public static class InkDamageSource
    extends IndirectEntityDamageSource {
        private final ItemStack weapon;

        public InkDamageSource(String damageTypeIn, Entity source, @Nullable Entity indirectEntityIn, ItemStack weapon) {
            super(damageTypeIn, source, indirectEntityIn);
            this.weapon = weapon;
        }

        public ITextComponent func_151519_b(LivingEntity entityLivingBaseIn) {
            ITextComponent itextcomponent = this.func_76346_g() == null ? this.field_76386_o.func_145748_c_() : this.func_76346_g().func_145748_c_();
            String s = "death.attack." + this.field_76373_n;
            String s1 = s + ".item";
            return !this.weapon.func_190926_b() ? new TranslationTextComponent(s1, new Object[]{entityLivingBaseIn.func_145748_c_(), itextcomponent, this.weapon.func_151000_E()}) : new TranslationTextComponent(s, new Object[]{entityLivingBaseIn.func_145748_c_(), itextcomponent});
        }
    }
}

