/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.util;

import com.cibernet.splatcraft.util.ColorUtils;
import com.cibernet.splatcraft.util.InkBlockUtils;
import com.cibernet.splatcraft.util.InkColor;
import com.cibernet.splatcraft.util.InkDamageUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.item.TNTEntity;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class InkExplosion {
    private final Random random = new Random();
    private final World world;
    private final double x;
    private final double y;
    private final double z;
    @Nullable
    private final Entity exploder;
    private final float size;
    private final DamageSource damageSource;
    private final List<BlockPos> affectedBlockPositions = Lists.newArrayList();
    private final Map<PlayerEntity, Vector3d> playerKnockbackMap = Maps.newHashMap();
    private final Vector3d position;
    private final int color;
    private final InkBlockUtils.InkType inkType;
    private final boolean damageMobs;
    private final float damage;
    private final float blockDamage;
    private final ItemStack weapon;

    public static void createInkExplosion(World world, Entity source, DamageSource damageSource, BlockPos pos, float size, float blockDamage, float damage, boolean damageMobs, int color, InkBlockUtils.InkType type, ItemStack weapon) {
        if (world.field_72995_K) {
            return;
        }
        InkExplosion inksplosion = new InkExplosion(world, source, damageSource, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), blockDamage, damage, damageMobs, size, color, type, weapon);
        inksplosion.doExplosionA();
        inksplosion.doExplosionB(false);
    }

    @OnlyIn(value=Dist.CLIENT)
    public InkExplosion(World worldIn, @Nullable Entity exploderIn, double xIn, double yIn, double zIn, float blockDamage, float damage, boolean damageMobs, float sizeIn, int color, InkBlockUtils.InkType inkType, ItemStack weapon) {
        this(worldIn, exploderIn, null, xIn, yIn, zIn, blockDamage, damage, damageMobs, sizeIn, color, inkType, weapon);
    }

    public InkExplosion(World world, @Nullable Entity source, @Nullable DamageSource damageSource, double x, double y, double z, float blockDamage, float damage, boolean damageMobs, float size, int color, InkBlockUtils.InkType inkType, ItemStack weapon) {
        this.world = world;
        this.exploder = source;
        this.size = size;
        this.x = x;
        this.y = y;
        this.z = z;
        this.damageSource = damageSource;
        this.position = new Vector3d(this.x, this.y, this.z);
        this.color = color;
        this.inkType = inkType;
        this.damageMobs = damageMobs;
        this.damage = damage;
        this.blockDamage = blockDamage;
        this.weapon = weapon;
    }

    public static float getBlockDensity(Vector3d p_222259_0_, Entity p_222259_1_) {
        AxisAlignedBB axisalignedbb = p_222259_1_.func_174813_aQ();
        double d0 = 1.0 / ((axisalignedbb.field_72336_d - axisalignedbb.field_72340_a) * 2.0 + 1.0);
        double d1 = 1.0 / ((axisalignedbb.field_72337_e - axisalignedbb.field_72338_b) * 2.0 + 1.0);
        double d2 = 1.0 / ((axisalignedbb.field_72334_f - axisalignedbb.field_72339_c) * 2.0 + 1.0);
        double d3 = (1.0 - Math.floor(1.0 / d0) * d0) / 2.0;
        double d4 = (1.0 - Math.floor(1.0 / d2) * d2) / 2.0;
        if (!(d0 < 0.0 || d1 < 0.0 || d2 < 0.0)) {
            int i = 0;
            int j = 0;
            float f = 0.0f;
            while (f <= 1.0f) {
                float f1 = 0.0f;
                while (f1 <= 1.0f) {
                    float f2 = 0.0f;
                    while (f2 <= 1.0f) {
                        double d7;
                        double d6;
                        double d5 = MathHelper.func_219803_d((double)f, (double)axisalignedbb.field_72340_a, (double)axisalignedbb.field_72336_d);
                        Vector3d vector3d = new Vector3d(d5 + d3, d6 = MathHelper.func_219803_d((double)f1, (double)axisalignedbb.field_72338_b, (double)axisalignedbb.field_72337_e), (d7 = MathHelper.func_219803_d((double)f2, (double)axisalignedbb.field_72339_c, (double)axisalignedbb.field_72334_f)) + d4);
                        if (p_222259_1_.field_70170_p.func_217299_a(new RayTraceContext(vector3d, p_222259_0_, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, p_222259_1_)).func_216346_c() == RayTraceResult.Type.MISS) {
                            ++i;
                        }
                        ++j;
                        f2 = (float)((double)f2 + d2);
                    }
                    f1 = (float)((double)f1 + d1);
                }
                f = (float)((double)f + d0);
            }
            return (float)i / (float)j;
        }
        return 0.0f;
    }

    public void doExplosionA() {
        HashSet set = Sets.newHashSet();
        int i = 16;
        for (int j = 0; j < 16; ++j) {
            for (int k = 0; k < 16; ++k) {
                for (int l = 0; l < 16; ++l) {
                    if (j != 0 && j != 15 && k != 0 && k != 15 && l != 0 && l != 15) continue;
                    double d0 = (float)j / 15.0f * 2.0f - 1.0f;
                    double d1 = (float)k / 15.0f * 2.0f - 1.0f;
                    double d2 = (float)l / 15.0f * 2.0f - 1.0f;
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    d0 /= d3;
                    d1 /= d3;
                    d2 /= d3;
                    double d4 = this.x;
                    double d6 = this.y;
                    double d8 = this.z;
                    float f1 = 0.3f;
                    for (float f = this.size * (0.7f + this.world.field_73012_v.nextFloat() * 0.6f); f > 0.0f; f -= 0.22500001f) {
                        BlockRayTraceResult raytrace = this.world.func_217299_a(new RayTraceContext(new Vector3d(this.x + 0.5, this.y + 0.5, this.z + 0.5), new Vector3d(d4 + 0.5, d6 + 0.5, d8 + 0.5), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, null));
                        BlockPos blockpos = new BlockPos(d4, d6, d8);
                        f -= 0.09f;
                        if (raytrace != null) {
                            blockpos = raytrace.func_216350_a();
                        }
                        if (!set.contains(blockpos)) {
                            set.add(blockpos);
                        }
                        d4 += d0 * (double)0.3f;
                        d6 += d1 * (double)0.3f;
                        d8 += d2 * (double)0.3f;
                    }
                }
            }
        }
        this.affectedBlockPositions.addAll(set);
        float f2 = this.size * 2.0f;
        int k1 = MathHelper.func_76128_c((double)(this.x - (double)f2 - 1.0));
        int l1 = MathHelper.func_76128_c((double)(this.x + (double)f2 + 1.0));
        int i2 = MathHelper.func_76128_c((double)(this.y - (double)f2 - 1.0));
        int i1 = MathHelper.func_76128_c((double)(this.y + (double)f2 + 1.0));
        int j2 = MathHelper.func_76128_c((double)(this.z - (double)f2 - 1.0));
        int j1 = MathHelper.func_76128_c((double)(this.z + (double)f2 + 1.0));
        List list = this.world.func_72839_b(this.exploder, new AxisAlignedBB((double)k1, (double)i2, (double)j2, (double)l1, (double)i1, (double)j1));
        Vector3d vector3d = new Vector3d(this.x, this.y, this.z);
        for (int k2 = 0; k2 < list.size(); ++k2) {
            Entity entity = (Entity)list.get(k2);
            int targetColor = -2;
            if (entity instanceof LivingEntity) {
                targetColor = ColorUtils.getEntityColor((LivingEntity)entity);
            }
            if (targetColor == -1 && this.damageMobs || this.color != targetColor && targetColor > -1) {
                InkDamageUtils.doSplatDamage(this.world, (LivingEntity)entity, this.damage, this.color, this.exploder, this.weapon, this.damageMobs, this.inkType);
            }
            DyeColor dyeColor = null;
            if (InkColor.getByHex(this.color) != null) {
                dyeColor = InkColor.getByHex(this.color).getDyeColor();
            }
            if (dyeColor == null || !(entity instanceof SheepEntity)) continue;
            ((SheepEntity)entity).func_175512_b(dyeColor);
        }
    }

    public void doExplosionB(boolean spawnParticles) {
        if (spawnParticles) {
            if (!(this.size < 2.0f)) {
                this.world.func_195594_a((IParticleData)ParticleTypes.field_197626_s, this.x, this.y, this.z, 1.0, 0.0, 0.0);
            } else {
                this.world.func_195594_a((IParticleData)ParticleTypes.field_197627_t, this.x, this.y, this.z, 1.0, 0.0, 0.0);
            }
        }
        ObjectArrayList objectarraylist = new ObjectArrayList();
        Collections.shuffle(this.affectedBlockPositions, this.world.field_73012_v);
        for (BlockPos blockpos : this.affectedBlockPositions) {
            BlockState blockstate = this.world.func_180495_p(blockpos);
            Block block = blockstate.func_177230_c();
            if (blockstate.isAir((IBlockReader)this.world, blockpos)) continue;
            if (this.exploder instanceof PlayerEntity) {
                InkBlockUtils.playerInkBlock((PlayerEntity)this.exploder, this.world, blockpos, this.color, this.blockDamage, this.inkType);
                continue;
            }
            InkBlockUtils.inkBlock(this.world, blockpos, this.color, this.blockDamage, this.inkType);
        }
        for (Pair pair : objectarraylist) {
            Block.func_180635_a((World)this.world, (BlockPos)((BlockPos)pair.getSecond()), (ItemStack)((ItemStack)pair.getFirst()));
        }
    }

    private static void func_229976_a_(ObjectArrayList<Pair<ItemStack, BlockPos>> p_229976_0_, ItemStack p_229976_1_, BlockPos p_229976_2_) {
        int i = p_229976_0_.size();
        for (int j = 0; j < i; ++j) {
            Pair pair = (Pair)p_229976_0_.get(j);
            ItemStack itemstack = (ItemStack)pair.getFirst();
            if (!ItemEntity.func_226532_a_((ItemStack)itemstack, (ItemStack)p_229976_1_)) continue;
            ItemStack itemstack1 = ItemEntity.func_226533_a_((ItemStack)itemstack, (ItemStack)p_229976_1_, (int)16);
            p_229976_0_.set(j, (Object)Pair.of((Object)itemstack1, (Object)pair.getSecond()));
            if (!p_229976_1_.func_190926_b()) continue;
            return;
        }
        p_229976_0_.add((Object)Pair.of((Object)p_229976_1_, (Object)p_229976_2_));
    }

    public DamageSource getDamageSource() {
        return this.damageSource;
    }

    public Map<PlayerEntity, Vector3d> getPlayerKnockbackMap() {
        return this.playerKnockbackMap;
    }

    @Nullable
    public LivingEntity getExplosivePlacedBy() {
        Entity entity;
        if (this.exploder == null) {
            return null;
        }
        if (this.exploder instanceof TNTEntity) {
            return ((TNTEntity)this.exploder).func_94083_c();
        }
        if (this.exploder instanceof LivingEntity) {
            return (LivingEntity)this.exploder;
        }
        if (this.exploder instanceof ProjectileEntity && (entity = ((ProjectileEntity)this.exploder).func_234616_v_()) instanceof LivingEntity) {
            return (LivingEntity)entity;
        }
        return null;
    }

    public void clearAffectedBlockPositions() {
        this.affectedBlockPositions.clear();
    }

    public List<BlockPos> getAffectedBlockPositions() {
        return this.affectedBlockPositions;
    }

    public Vector3d getPosition() {
        return this.position;
    }

    @Nullable
    public Entity getExploder() {
        return this.exploder;
    }
}

