/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.util;

import com.cibernet.splatcraft.capabilities.playerinfo.IPlayerInfo;
import com.cibernet.splatcraft.capabilities.playerinfo.PlayerInfoCapability;
import com.cibernet.splatcraft.items.weapons.IChargeableWeapon;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class PlayerCharge {
    public ItemStack chargedWeapon;
    public float charge;
    public boolean canDischarge = false;

    public PlayerCharge(ItemStack stack, float charge) {
        this.chargedWeapon = stack;
        this.charge = charge;
    }

    public static PlayerCharge getCharge(PlayerEntity player) {
        return PlayerInfoCapability.get((LivingEntity)player).getPlayerCharge();
    }

    public static void setCharge(PlayerEntity player, PlayerCharge charge) {
        PlayerInfoCapability.get((LivingEntity)player).setPlayerCharge(charge);
    }

    public static boolean hasCharge(PlayerEntity player) {
        if (player == null) {
            return false;
        }
        IPlayerInfo capability = PlayerInfoCapability.get((LivingEntity)player);
        return capability != null && capability.getPlayerCharge() != null && capability.getPlayerCharge().charge > 0.0f;
    }

    public static boolean shouldCreateCharge(PlayerEntity player) {
        if (player == null) {
            return false;
        }
        IPlayerInfo capability = PlayerInfoCapability.get((LivingEntity)player);
        return capability != null && capability.getPlayerCharge() == null;
    }

    public static boolean chargeMatches(PlayerEntity player, ItemStack stack) {
        return PlayerCharge.hasCharge(player) && PlayerCharge.getCharge((PlayerEntity)player).chargedWeapon.func_77969_a(stack);
    }

    public static void addChargeValue(PlayerEntity player, ItemStack stack, float value) {
        if (PlayerCharge.shouldCreateCharge(player)) {
            PlayerCharge.setCharge(player, new PlayerCharge(stack, 0.0f));
        }
        PlayerCharge charge = PlayerCharge.getCharge(player);
        if (PlayerCharge.chargeMatches(player, stack)) {
            charge.charge = Math.max(0.0f, Math.min(charge.charge + value, 1.0f));
        } else {
            PlayerCharge.setCharge(player, new PlayerCharge(stack, 0.0f));
        }
    }

    public static float getChargeValue(PlayerEntity player, ItemStack stack) {
        return PlayerCharge.chargeMatches(player, stack) ? PlayerCharge.getCharge((PlayerEntity)player).charge : 0.0f;
    }

    public static boolean canDischarge(PlayerEntity playerEntity) {
        return PlayerCharge.hasCharge(playerEntity) && PlayerInfoCapability.get((LivingEntity)playerEntity).getPlayerCharge().canDischarge;
    }

    public static void setCanDischarge(PlayerEntity player, boolean canDischarge) {
        if (PlayerCharge.hasCharge(player)) {
            PlayerCharge.getCharge((PlayerEntity)player).canDischarge = canDischarge;
        }
    }

    public static void reset(PlayerEntity entity) {
        if (PlayerCharge.shouldCreateCharge(entity)) {
            PlayerCharge.setCharge(entity, new PlayerCharge(ItemStack.field_190927_a, 0.0f));
        }
    }

    public static void dischargeWeapon(PlayerEntity player) {
        if (!player.field_70170_p.field_72995_K || !PlayerCharge.hasCharge(player)) {
            return;
        }
        PlayerCharge charge = PlayerCharge.getCharge(player);
        Item dischargeItem = charge.chargedWeapon.func_77973_b();
        charge.charge = dischargeItem instanceof IChargeableWeapon ? Math.max(0.0f, charge.charge - ((IChargeableWeapon)dischargeItem).getDischargeSpeed()) : 0.0f;
    }
}

