/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.util;

import com.cibernet.splatcraft.capabilities.playerinfo.IPlayerInfo;
import com.cibernet.splatcraft.capabilities.playerinfo.PlayerInfoCapability;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;

public class PlayerCooldown {
    int time;
    final int maxTime;
    final int slotIndex;
    final boolean canMove;
    final boolean forceCrouch;
    final boolean preventWeaponUse;

    public PlayerCooldown(int time, int maxTime, int slotIndex, boolean canMove, boolean forceCrouch, boolean preventWeaponUse) {
        this.time = ++time;
        this.maxTime = maxTime;
        this.slotIndex = slotIndex;
        this.canMove = canMove;
        this.forceCrouch = forceCrouch;
        this.preventWeaponUse = preventWeaponUse;
    }

    public PlayerCooldown(int time, int slotIndex, boolean canMove, boolean forceCrouch, boolean preventWeaponUse) {
        this(time, time, slotIndex, canMove, forceCrouch, preventWeaponUse);
    }

    public boolean canMove() {
        return this.canMove;
    }

    public boolean forceCrouch() {
        return this.forceCrouch;
    }

    public boolean preventWeaponUse() {
        return this.preventWeaponUse;
    }

    public int getTime() {
        return this.time;
    }

    public int getMaxTime() {
        return this.maxTime;
    }

    public int getSlotIndex() {
        return this.slotIndex;
    }

    public PlayerCooldown setTime(int v) {
        this.time = v;
        return this;
    }

    public PlayerCooldown shrinkTime(int v) {
        this.time -= v;
        return this;
    }

    public static PlayerCooldown readNBT(CompoundNBT nbt) {
        return new PlayerCooldown(nbt.func_74762_e("Time"), nbt.func_74762_e("MaxTime"), nbt.func_74762_e("SlotIndex"), nbt.func_74767_n("CanMove"), nbt.func_74767_n("ForceCrouch"), nbt.func_74767_n("PreventWeaponUse"));
    }

    public CompoundNBT writeNBT(CompoundNBT nbt) {
        nbt.func_74768_a("Time", this.time);
        nbt.func_74768_a("MaxTime", this.maxTime);
        nbt.func_74768_a("SlotIndex", this.slotIndex);
        nbt.func_74757_a("CanMove", this.canMove);
        nbt.func_74757_a("ForceCrouch", this.forceCrouch);
        nbt.func_74757_a("PreventWeaponUse", this.preventWeaponUse);
        return nbt;
    }

    public static PlayerCooldown getPlayerCooldown(PlayerEntity player) {
        return PlayerInfoCapability.get((LivingEntity)player).getPlayerCooldown();
    }

    public static void setPlayerCooldown(PlayerEntity player, PlayerCooldown playerCooldown) {
        PlayerInfoCapability.get((LivingEntity)player).setPlayerCooldown(playerCooldown);
    }

    public static PlayerCooldown setCooldownTime(PlayerEntity player, int time) {
        IPlayerInfo capability = PlayerInfoCapability.get((LivingEntity)player);
        if (capability.getPlayerCooldown() == null) {
            return null;
        }
        capability.getPlayerCooldown().setTime(time);
        return capability.getPlayerCooldown();
    }

    public static PlayerCooldown shrinkCooldownTime(PlayerEntity player, int time) {
        return PlayerCooldown.hasPlayerCooldown(player) ? PlayerCooldown.setCooldownTime(player, PlayerInfoCapability.get((LivingEntity)player).getPlayerCooldown().getTime() - time) : null;
    }

    public static boolean hasPlayerCooldown(PlayerEntity player) {
        if (PlayerInfoCapability.get((LivingEntity)player) == null) {
            return false;
        }
        PlayerCooldown cooldown = PlayerInfoCapability.get((LivingEntity)player).getPlayerCooldown();
        return cooldown != null && cooldown.getTime() > 0;
    }
}

