/*
 * Decompiled with CFR 0.152.
 */
package com.flashfyre.stables;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;

public class SpawnEntityFeature
extends Feature<EntityConfig> {
    public SpawnEntityFeature(Codec<EntityConfig> codec) {
        super(codec);
    }

    public boolean generate(ISeedReader reader, ChunkGenerator generator, Random rand, BlockPos pos, EntityConfig config) {
        Entity entity = config.entityType.func_200721_a((World)reader.func_201672_e());
        if (entity != null) {
            entity.func_70012_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, MathHelper.func_76142_g((float)(rand.nextFloat() * 360.0f)), 0.0f);
            config.getNBT().ifPresent(nbt -> {
                CompoundNBT entityNbt = entity.func_189511_e(new CompoundNBT());
                UUID uuid = entity.func_110124_au();
                entityNbt.func_197643_a(nbt);
                entity.func_184221_a(uuid);
                entity.func_70020_e(entityNbt);
            });
            if (entity instanceof MobEntity) {
                MobEntity mob = (MobEntity)entity;
                mob.func_110163_bv();
                mob.func_213386_a((IServerWorld)reader, reader.func_175649_E(pos), SpawnReason.STRUCTURE, (ILivingEntityData)null, entity.serializeNBT());
            }
            reader.func_242417_l(entity);
            return true;
        }
        return false;
    }

    public static class EntityConfig
    implements IFeatureConfig {
        public static final Codec<EntityConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Registry.field_212629_r.fieldOf("entity").forGetter(EntityConfig::getEntityType), (App)CompoundNBT.field_240597_a_.optionalFieldOf("nbt").forGetter(EntityConfig::getNBT)).apply((Applicative)instance, EntityConfig::new));
        private final EntityType<?> entityType;
        @Nullable
        private final Optional<CompoundNBT> nbt;

        public EntityConfig(EntityType<?> entityType, Optional<CompoundNBT> nbt) {
            this.entityType = entityType;
            this.nbt = nbt;
        }

        public EntityType<?> getEntityType() {
            return this.entityType;
        }

        public Optional<CompoundNBT> getNBT() {
            return this.nbt;
        }
    }
}

