/*
 * Decompiled with CFR 0.152.
 */
package com.flashfyre.stables;

import com.flashfyre.stables.ClientEvents;
import com.flashfyre.stables.SpawnEntityFeature;
import com.flashfyre.stables.StablesConfiguredStructures;
import com.flashfyre.stables.StablesStructures;
import com.flashfyre.stables.entity.StableMasterEntity;
import java.util.HashMap;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.GlobalEntityTypeAttributes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.gen.FlatChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="stables")
public class Stables {
    public static final String MOD_ID = "stables";
    public static Stables instance;
    public static final Logger LOGGER;
    public final EntityType<StableMasterEntity> stable_master = EntityType.Builder.func_220322_a(StableMasterEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.6f, 1.95f).func_233606_a_(10).func_206830_a(new ResourceLocation("stables", "stable_master").toString());
    private static final DeferredRegister<Item> ITEMS;
    private static final DeferredRegister<Feature<?>> FEATURES;

    public Stables() {
        instance = this;
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        ITEMS.register(modBus);
        StablesStructures.STRUCTURES.register(modBus);
        FEATURES.register(modBus);
        modBus.addListener(this::setup);
        modBus.addGenericListener(EntityType.class, this::onRegisterEntityTypes);
        forgeBus.addListener(EventPriority.NORMAL, this::addDimensionalSpacing);
        forgeBus.addListener(EventPriority.HIGH, this::biomeModification);
        FEATURES.register("spawn_entity", () -> new SpawnEntityFeature(SpawnEntityFeature.EntityConfig.CODEC));
        ITEMS.register("stable_master_spawn_egg", () -> new SpawnEggItem(this.stable_master, 602139, 12422002, new Item.Properties().func_200916_a(ItemGroup.field_78026_f)));
        if (FMLEnvironment.dist == Dist.CLIENT) {
            ClientEvents.subscribeClientEvents(modBus, forgeBus);
        }
    }

    public void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            StablesStructures.setupStructures();
            StablesConfiguredStructures.registerConfiguredStructures();
            GlobalEntityTypeAttributes.put(this.stable_master, (AttributeModifierMap)StableMasterEntity.createAttributes().func_233813_a_());
        });
    }

    public void biomeModification(BiomeLoadingEvent event) {
        RegistryKey key = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)event.getName());
        Set types = BiomeDictionary.getTypes((RegistryKey)key);
        if (types.contains(BiomeDictionary.Type.PLAINS) && !types.contains(BiomeDictionary.Type.HOT) && !types.contains(BiomeDictionary.Type.SNOWY)) {
            event.getGeneration().getStructures().add(() -> StablesConfiguredStructures.CONFIGURED_LARGE_BARN);
        }
    }

    public void addDimensionalSpacing(WorldEvent.Load event) {
        ServerWorld serverWorld;
        if (event.getWorld() instanceof ServerWorld && (serverWorld = (ServerWorld)event.getWorld()).func_234923_W_().equals(World.field_234918_g_)) {
            if (serverWorld.func_72863_F().func_201711_g() instanceof FlatChunkGenerator) {
                return;
            }
            HashMap<IForgeRegistryEntry, Object> tempMap = new HashMap<IForgeRegistryEntry, Object>(serverWorld.func_72863_F().field_186029_c.func_235957_b_().func_236195_a_());
            tempMap.put(StablesStructures.LARGE_BARN.get(), DimensionStructuresSettings.field_236191_b_.get((Object)StablesStructures.LARGE_BARN.get()));
            serverWorld.func_72863_F().field_186029_c.func_235957_b_().field_236193_d_ = tempMap;
        }
    }

    public void onRegisterEntityTypes(RegistryEvent.Register<EntityType<?>> event) {
        BiConsumer<String, String> registrator = Stables.getRegistrator(event.getRegistry());
        registrator.accept("stable_master", (String)this.stable_master);
    }

    public static <T extends IForgeRegistryEntry<T>> BiConsumer<String, T> getRegistrator(IForgeRegistry<T> registry) {
        return (name, thing) -> Stables.register(name, thing, registry);
    }

    public static <T extends IForgeRegistryEntry<T>> void register(String name, T thing, IForgeRegistry<T> registry) {
        thing.setRegistryName(new ResourceLocation(MOD_ID, name));
        registry.register(thing);
    }

    static {
        LOGGER = LogManager.getLogger();
        ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)MOD_ID);
        FEATURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)MOD_ID);
    }
}

