/*
 * Decompiled with CFR 0.152.
 */
package com.flashfyre.stables;

import com.flashfyre.stables.structures.LargeBarnStructure;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class StablesStructures {
    public static final DeferredRegister<Structure<?>> STRUCTURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.STRUCTURE_FEATURES, (String)"stables");
    public static final RegistryObject<Structure<NoFeatureConfig>> LARGE_BARN = StablesStructures.setupStructure("large_barn", () -> new LargeBarnStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));

    private static <T extends Structure<?>> RegistryObject<T> setupStructure(String name, Supplier<T> structure) {
        return STRUCTURES.register(name, structure);
    }

    public static void setupStructures() {
        StablesStructures.setupStructure((Structure)LARGE_BARN.get(), new StructureSeparationSettings(20, 10, 671023157), true);
    }

    public static <F extends Structure<?>> void setupStructure(F structure, StructureSeparationSettings structureSeparationSettings, boolean transformSurroundingLand) {
        Structure.field_236365_a_.put((Object)structure.getRegistryName().toString(), structure);
        if (transformSurroundingLand) {
            Structure.field_236384_t_ = ImmutableList.builder().addAll((Iterable)Structure.field_236384_t_).add(structure).build();
        }
        DimensionStructuresSettings.field_236191_b_ = ImmutableMap.builder().putAll((Map)DimensionStructuresSettings.field_236191_b_).put(structure, (Object)structureSeparationSettings).build();
    }
}

