/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.age.stone.blocks;

import com.google.common.collect.Maps;
import com.yanny.age.stone.blocks.AqueductTileEntity;
import com.yanny.age.stone.compatibility.top.TopBlockInfoProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.BucketItem;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class AqueductBlock
extends Block
implements TopBlockInfoProvider {
    private static final Map<Integer, VoxelShape> SHAPES = new HashMap<Integer, VoxelShape>();
    private static final BooleanProperty NORTH;
    private static final BooleanProperty EAST;
    private static final BooleanProperty SOUTH;
    private static final BooleanProperty WEST;
    private static final Map<Direction, BooleanProperty> FACING_TO_PROPERTY_MAP;

    public AqueductBlock() {
        super(Block.Properties.func_200945_a((Material)Material.field_151576_e).func_200943_b(2.0f));
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((IProperty)NORTH, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)EAST, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)WEST, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(false)));
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new AqueductTileEntity();
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return this.makeConnections(context.func_195991_k(), context.func_195995_a());
    }

    public void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{NORTH, EAST, SOUTH, WEST});
        builder.func_206894_a(new IProperty[]{BlockStateProperties.field_208198_y});
    }

    @Nonnull
    public BlockState func_196271_a(@Nonnull BlockState stateIn, @Nonnull Direction facing, @Nonnull BlockState facingState, @Nonnull IWorld worldIn, @Nonnull BlockPos currentPos, @Nonnull BlockPos facingPos) {
        if (facing != Direction.DOWN && facing != Direction.UP) {
            return (BlockState)stateIn.func_206870_a((IProperty)FACING_TO_PROPERTY_MAP.get(facing), (Comparable)Boolean.valueOf(this.checkSideConnection(worldIn.func_201672_e(), currentPos, facingPos, facing)));
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    @Nonnull
    public IFluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_208198_y) != false ? Fluids.field_204546_a.func_207207_a(1, false) : super.func_204507_t(state);
    }

    @Nonnull
    public ActionResultType func_225533_a_(@Nonnull BlockState state, World worldIn, @Nonnull BlockPos pos, @Nonnull PlayerEntity player, @Nonnull Hand handIn, @Nonnull BlockRayTraceResult hit) {
        AqueductTileEntity tile = (AqueductTileEntity)worldIn.func_175625_s(pos);
        if (tile != null) {
            ItemStack heldItem = player.func_184586_b(handIn);
            if (heldItem.func_77973_b() instanceof BucketItem) {
                LazyOptional fluidHandler = tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
                fluidHandler.ifPresent(fluid -> FluidUtil.interactWithFluidHandler((PlayerEntity)player, (Hand)handIn, (IFluidHandler)fluid));
                return ActionResultType.SUCCESS;
            }
            if (heldItem.func_190926_b()) {
                tile.changedState();
                return ActionResultType.SUCCESS;
            }
            return super.func_225533_a_(state, worldIn, pos, player, handIn, hit);
        }
        throw new IllegalStateException("Named container provider is missing");
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(@Nonnull BlockState stateIn, @Nonnull World worldIn, @Nonnull BlockPos pos, Random rand) {
        AqueductTileEntity tileEntity;
        BlockPos blockpos;
        if (rand.nextInt(2) == 0 && ((Boolean)stateIn.func_177229_b((IProperty)BlockStateProperties.field_208198_y)).booleanValue() && worldIn.func_175623_d(blockpos = pos.func_177984_a()) && (tileEntity = (AqueductTileEntity)worldIn.func_175625_s(pos)) != null && (double)tileEntity.getCapacity() > 0.01) {
            double d0 = (double)((float)pos.func_177958_n() + rand.nextFloat() / 2.0f) + 0.25;
            double d1 = (double)((float)pos.func_177956_o() + 0.25f) + 0.05;
            double d2 = (double)((float)pos.func_177952_p() + rand.nextFloat() / 2.0f) + 0.25;
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197612_e, d0, d1, d2, 0.0, (double)rand.nextFloat(), 0.0);
        }
    }

    @Nonnull
    public VoxelShape func_220053_a(BlockState state, @Nonnull IBlockReader worldIn, @Nonnull BlockPos pos, @Nonnull ISelectionContext context) {
        int flag = 0;
        flag |= (Boolean)state.func_177229_b((IProperty)NORTH) == false ? 1 : 0;
        flag |= (Boolean)state.func_177229_b((IProperty)EAST) == false ? 2 : 0;
        flag |= (Boolean)state.func_177229_b((IProperty)SOUTH) == false ? 4 : 0;
        return SHAPES.get(flag |= (Boolean)state.func_177229_b((IProperty)WEST) == false ? 8 : 0);
    }

    @Override
    public void addProbeInfo(@Nonnull ProbeMode probeMode, @Nonnull IProbeInfo iProbeInfo, @Nonnull PlayerEntity playerEntity, @Nonnull World world, @Nonnull BlockState blockState, @Nonnull IProbeHitData iProbeHitData) {
        TileEntity te = world.func_175625_s(iProbeHitData.getPos());
        if (te instanceof AqueductTileEntity) {
            AqueductTileEntity aqueductTileEntity = (AqueductTileEntity)te;
            iProbeInfo.horizontal().progress(aqueductTileEntity.getFilled(), aqueductTileEntity.getFullCapacity(), iProbeInfo.defaultProgressStyle().suffix("mB"));
        }
    }

    static boolean isWater(@Nonnull Block block) {
        return block.equals(Blocks.field_150355_j);
    }

    private BlockState makeConnections(@Nonnull World world, @Nonnull BlockPos pos) {
        return (BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)NORTH, (Comparable)Boolean.valueOf(this.checkSideConnection(world, pos, pos.func_177978_c(), Direction.NORTH)))).func_206870_a((IProperty)EAST, (Comparable)Boolean.valueOf(this.checkSideConnection(world, pos, pos.func_177974_f(), Direction.EAST)))).func_206870_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(this.checkSideConnection(world, pos, pos.func_177968_d(), Direction.SOUTH)))).func_206870_a((IProperty)WEST, (Comparable)Boolean.valueOf(this.checkSideConnection(world, pos, pos.func_177976_e(), Direction.WEST)));
    }

    private boolean checkSideConnection(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull BlockPos sidePos, @Nonnull Direction direction) {
        AqueductTileEntity aqueductTileEntity = (AqueductTileEntity)world.func_175625_s(pos);
        BlockState facingBlockState = world.func_180495_p(sidePos);
        Block block = facingBlockState.func_177230_c();
        boolean isWater = AqueductBlock.isWater(block);
        if (aqueductTileEntity != null) {
            aqueductTileEntity.setSource(direction, isWater);
        }
        return block == this || isWater;
    }

    @Nonnull
    private static VoxelShape getBaseShape() {
        VoxelShape base = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0);
        VoxelShape b1 = Block.func_208617_a((double)0.0, (double)4.0, (double)0.0, (double)4.0, (double)16.0, (double)4.0);
        VoxelShape b2 = Block.func_208617_a((double)12.0, (double)4.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0);
        VoxelShape b3 = Block.func_208617_a((double)0.0, (double)4.0, (double)12.0, (double)4.0, (double)16.0, (double)16.0);
        VoxelShape b4 = Block.func_208617_a((double)12.0, (double)4.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0);
        return VoxelShapes.func_216384_a((VoxelShape)base, (VoxelShape[])new VoxelShape[]{b1, b2, b3, b4});
    }

    @Nonnull
    private static VoxelShape getNorthShape() {
        return Block.func_208617_a((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)16.0, (double)4.0);
    }

    @Nonnull
    private static VoxelShape getEastShape() {
        return Block.func_208617_a((double)12.0, (double)4.0, (double)4.0, (double)16.0, (double)16.0, (double)12.0);
    }

    @Nonnull
    private static VoxelShape getSouthShape() {
        return Block.func_208617_a((double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)16.0, (double)16.0);
    }

    @Nonnull
    private static VoxelShape getWestShape() {
        return Block.func_208617_a((double)0.0, (double)4.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0);
    }

    static {
        SHAPES.put(0, AqueductBlock.getBaseShape());
        SHAPES.put(1, VoxelShapes.func_197872_a((VoxelShape)AqueductBlock.getBaseShape(), (VoxelShape)AqueductBlock.getNorthShape()));
        SHAPES.put(2, VoxelShapes.func_197872_a((VoxelShape)AqueductBlock.getBaseShape(), (VoxelShape)AqueductBlock.getEastShape()));
        SHAPES.put(3, VoxelShapes.func_216384_a((VoxelShape)AqueductBlock.getBaseShape(), (VoxelShape[])new VoxelShape[]{AqueductBlock.getNorthShape(), AqueductBlock.getEastShape()}));
        SHAPES.put(4, VoxelShapes.func_197872_a((VoxelShape)AqueductBlock.getBaseShape(), (VoxelShape)AqueductBlock.getSouthShape()));
        SHAPES.put(5, VoxelShapes.func_216384_a((VoxelShape)AqueductBlock.getBaseShape(), (VoxelShape[])new VoxelShape[]{AqueductBlock.getNorthShape(), AqueductBlock.getSouthShape()}));
        SHAPES.put(6, VoxelShapes.func_216384_a((VoxelShape)AqueductBlock.getBaseShape(), (VoxelShape[])new VoxelShape[]{AqueductBlock.getEastShape(), AqueductBlock.getSouthShape()}));
        SHAPES.put(7, VoxelShapes.func_216384_a((VoxelShape)AqueductBlock.getBaseShape(), (VoxelShape[])new VoxelShape[]{AqueductBlock.getNorthShape(), AqueductBlock.getEastShape(), AqueductBlock.getSouthShape()}));
        SHAPES.put(8, VoxelShapes.func_197872_a((VoxelShape)AqueductBlock.getBaseShape(), (VoxelShape)AqueductBlock.getWestShape()));
        SHAPES.put(9, VoxelShapes.func_216384_a((VoxelShape)AqueductBlock.getBaseShape(), (VoxelShape[])new VoxelShape[]{AqueductBlock.getNorthShape(), AqueductBlock.getWestShape()}));
        SHAPES.put(10, VoxelShapes.func_216384_a((VoxelShape)AqueductBlock.getBaseShape(), (VoxelShape[])new VoxelShape[]{AqueductBlock.getEastShape(), AqueductBlock.getWestShape()}));
        SHAPES.put(11, VoxelShapes.func_216384_a((VoxelShape)AqueductBlock.getBaseShape(), (VoxelShape[])new VoxelShape[]{AqueductBlock.getNorthShape(), AqueductBlock.getEastShape(), AqueductBlock.getWestShape()}));
        SHAPES.put(12, VoxelShapes.func_216384_a((VoxelShape)AqueductBlock.getBaseShape(), (VoxelShape[])new VoxelShape[]{AqueductBlock.getSouthShape(), AqueductBlock.getWestShape()}));
        SHAPES.put(13, VoxelShapes.func_216384_a((VoxelShape)AqueductBlock.getBaseShape(), (VoxelShape[])new VoxelShape[]{AqueductBlock.getNorthShape(), AqueductBlock.getSouthShape(), AqueductBlock.getWestShape()}));
        SHAPES.put(14, VoxelShapes.func_216384_a((VoxelShape)AqueductBlock.getBaseShape(), (VoxelShape[])new VoxelShape[]{AqueductBlock.getEastShape(), AqueductBlock.getSouthShape(), AqueductBlock.getWestShape()}));
        SHAPES.put(15, VoxelShapes.func_216384_a((VoxelShape)AqueductBlock.getBaseShape(), (VoxelShape[])new VoxelShape[]{AqueductBlock.getNorthShape(), AqueductBlock.getEastShape(), AqueductBlock.getSouthShape(), AqueductBlock.getWestShape()}));
        NORTH = BooleanProperty.func_177716_a((String)"north");
        EAST = BooleanProperty.func_177716_a((String)"east");
        SOUTH = BooleanProperty.func_177716_a((String)"south");
        WEST = BooleanProperty.func_177716_a((String)"west");
        FACING_TO_PROPERTY_MAP = (Map)Util.func_200696_a((Object)Maps.newEnumMap(Direction.class), map -> {
            map.put(Direction.NORTH, NORTH);
            map.put(Direction.EAST, EAST);
            map.put(Direction.SOUTH, SOUTH);
            map.put(Direction.WEST, WEST);
        });
    }
}

