/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.age.stone.blocks;

import com.yanny.age.stone.ExampleMod;
import com.yanny.age.stone.blocks.FishingNetTileEntity;
import com.yanny.age.stone.subscribers.BlockSubscriber;
import com.yanny.age.stone.subscribers.ContainerSubscriber;
import com.yanny.age.stone.utils.ContainerUtils;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class FishingNetContainer
extends Container {
    private final FishingNetTileEntity tile;
    private final PlayerEntity player;

    public FishingNetContainer(int windowId, @Nonnull PlayerInventory inv, @Nonnull PacketBuffer extraData) {
        this(windowId, extraData.func_179259_c(), Objects.requireNonNull(ExampleMod.proxy.getClientWorld()), inv, Objects.requireNonNull(ExampleMod.proxy.getClientPlayer()));
    }

    FishingNetContainer(int id, @Nonnull BlockPos pos, @Nonnull World world, @Nonnull PlayerInventory inventory, @Nonnull PlayerEntity player) {
        super(ContainerSubscriber.fishing_net, id);
        this.tile = (FishingNetTileEntity)world.func_175625_s(pos);
        this.player = player;
        if (this.tile == null) {
            throw new IllegalStateException("TileEntity does not exists!");
        }
        this.tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(h -> {
            this.func_75146_a((Slot)new SlotItemHandler(h, 0, 26, 35));
            for (int y = 0; y < 3; ++y) {
                for (int x = 0; x < 5; ++x) {
                    this.func_75146_a((Slot)new SlotItemHandler(h, 1 + x + y * 5, 62 + x * 18, 17 + y * 18));
                }
            }
        });
        ContainerUtils.layoutPlayerInventorySlots((slot, x, y) -> this.func_75146_a(new Slot((IInventory)inventory, slot.intValue(), x.intValue(), y.intValue())), 8, 84);
    }

    public boolean func_75145_c(@Nonnull PlayerEntity playerIn) {
        if (this.tile == null || this.tile.func_145831_w() == null) {
            throw new IllegalStateException("Null pointer");
        }
        return FishingNetContainer.func_216963_a((IWorldPosCallable)IWorldPosCallable.func_221488_a((World)this.tile.func_145831_w(), (BlockPos)this.tile.func_174877_v()), (PlayerEntity)this.player, (Block)BlockSubscriber.fishing_net);
    }

    @Nonnull
    public ItemStack func_82846_b(@Nonnull PlayerEntity playerIn, int index) {
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack stack = slot.func_75211_c();
            ItemStack itemstack = stack.func_77946_l();
            if (index < 16) {
                if (!this.func_75135_a(stack, 17, 52, true)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(stack, itemstack);
            } else if (!this.func_75135_a(stack, 0, 1, false)) {
                return ItemStack.field_190927_a;
            }
            this.tile.updateState();
            if (stack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (stack.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(playerIn, stack);
        }
        return ItemStack.field_190927_a;
    }
}

