/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.age.stone.blocks;

import com.yanny.age.stone.blocks.FishingNetContainer;
import com.yanny.age.stone.blocks.IInventoryInterface;
import com.yanny.age.stone.config.Config;
import com.yanny.age.stone.subscribers.TileEntitySubscriber;
import com.yanny.ages.api.utils.ItemStackUtils;
import com.yanny.ages.api.utils.Tags;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameterSets;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTables;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class FishingNetTileEntity
extends TileEntity
implements IInventoryInterface,
ITickableTileEntity,
INamedContainerProvider {
    static final int INVENTORY_WIDTH = 5;
    static final int INVENTORY_HEIGHT = 3;
    static final int ITEMS = 16;
    private final NonNullList<ItemStack> stacks = NonNullList.func_191197_a((int)16, (Object)ItemStack.field_190927_a);
    private final IItemHandlerModifiable nonSidedItemHandler = this.createInventoryHandler(this.stacks);
    private final LazyOptional<IItemHandlerModifiable> sidedInventoryHandler = LazyOptional.of(() -> this.createInventoryHandler(this.stacks));
    private final LazyOptional<IItemHandlerModifiable> nonSidedInventoryHandler = LazyOptional.of(() -> this.nonSidedItemHandler);
    private final RecipeWrapper inventoryWrapper = new RecipeWrapper(this.nonSidedItemHandler);

    public FishingNetTileEntity() {
        super(TileEntitySubscriber.fishing_net);
    }

    public void func_73660_a() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K && !((ItemStack)this.stacks.get(0)).func_190926_b() && this.field_145850_b.field_73012_v.nextInt(Config.fishingNetChance) == 0 && this.hasWaterAround()) {
            if (((ItemStack)this.stacks.get(0)).func_96631_a(1, this.field_145850_b.field_73012_v, null)) {
                this.stacks.set(0, (Object)ItemStack.field_190927_a);
                this.field_145850_b.func_175656_a(this.func_174877_v(), (BlockState)this.func_195044_w().func_206870_a((IProperty)BlockStateProperties.field_208174_a, (Comparable)Boolean.valueOf(false)));
            }
            this.generateLoot();
            this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 3);
        }
    }

    @Nullable
    public Container createMenu(int id, @Nonnull PlayerInventory inventory, @Nonnull PlayerEntity entity) {
        assert (this.field_145850_b != null);
        return new FishingNetContainer(id, this.field_174879_c, this.field_145850_b, inventory, entity);
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        assert (this.func_200662_C().getRegistryName() != null);
        return new StringTextComponent(this.func_200662_C().getRegistryName().func_110623_a());
    }

    @Override
    @Nonnull
    public IInventory getInventory() {
        return this.inventoryWrapper;
    }

    public void func_145839_a(CompoundNBT tag) {
        CompoundNBT invTag = tag.func_74775_l("inv");
        ItemStackUtils.deserializeStacks((CompoundNBT)invTag, this.stacks);
        super.func_145839_a(tag);
    }

    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag.func_218657_a("inv", (INBT)ItemStackUtils.serializeStacks(this.stacks));
        return super.func_189515_b(tag);
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), this.func_200662_C().hashCode(), this.func_189517_E_());
    }

    @Nonnull
    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        super.onDataPacket(net, pkt);
        this.func_145839_a(pkt.func_148857_g());
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (side != null) {
                if (side == Direction.DOWN || side == Direction.UP) {
                    return this.sidedInventoryHandler.cast();
                }
            } else {
                return this.nonSidedInventoryHandler.cast();
            }
        }
        return super.getCapability(cap, side);
    }

    public void func_145843_s() {
        this.sidedInventoryHandler.invalidate();
        this.nonSidedInventoryHandler.invalidate();
        super.func_145843_s();
    }

    public void updateState() {
        assert (this.field_145850_b != null);
        this.field_145850_b.func_175656_a(this.func_174877_v(), (BlockState)this.func_195044_w().func_206870_a((IProperty)BlockStateProperties.field_208174_a, (Comparable)Boolean.valueOf(!((ItemStack)this.stacks.get(0)).func_190926_b())));
    }

    private void generateLoot() {
        assert (this.field_145850_b != null);
        LootTable lootTable = ((ServerWorld)this.field_145850_b).func_73046_m().func_200249_aQ().func_186521_a(LootTables.field_186387_al);
        LootContext lootContext = new LootContext.Builder((ServerWorld)this.field_145850_b).func_216015_a(LootParameters.field_216286_f, (Object)this.func_174877_v()).func_216015_a(LootParameters.field_216289_i, this.stacks.get(0)).func_216022_a(LootParameterSets.field_216262_c);
        List loot = lootTable.func_216113_a(lootContext);
        ItemStackUtils.insertItems((List)loot, this.stacks, (int)1, (int)16);
    }

    @Nonnull
    private IItemHandlerModifiable createInventoryHandler(@Nonnull NonNullList<ItemStack> stacks) {
        return new ItemStackHandler(stacks){

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (slot == 0) {
                    assert (FishingNetTileEntity.this.field_145850_b != null);
                    FishingNetTileEntity.this.field_145850_b.func_175656_a(FishingNetTileEntity.this.func_174877_v(), (BlockState)FishingNetTileEntity.this.func_195044_w().func_206870_a((IProperty)BlockStateProperties.field_208174_a, (Comparable)Boolean.valueOf(true)));
                }
                return super.insertItem(slot, stack, simulate);
            }

            @Nonnull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                if (slot == 0) {
                    assert (FishingNetTileEntity.this.field_145850_b != null);
                    FishingNetTileEntity.this.field_145850_b.func_175656_a(FishingNetTileEntity.this.func_174877_v(), (BlockState)FishingNetTileEntity.this.func_195044_w().func_206870_a((IProperty)BlockStateProperties.field_208174_a, (Comparable)Boolean.valueOf(false)));
                }
                return super.extractItem(slot, amount, simulate);
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return slot == 0 && Tags.Items.FISHING_NET_MESHES.func_199685_a_(stack.func_77973_b());
            }

            protected void onContentsChanged(int slot) {
                assert (FishingNetTileEntity.this.field_145850_b != null);
                FishingNetTileEntity.this.func_70296_d();
                FishingNetTileEntity.this.field_145850_b.func_184138_a(FishingNetTileEntity.this.func_174877_v(), FishingNetTileEntity.this.func_195044_w(), FishingNetTileEntity.this.func_195044_w(), 3);
            }
        };
    }

    private boolean hasWaterAround() {
        assert (this.field_145850_b != null);
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            IFluidState fluidState = this.field_145850_b.func_204610_c(this.field_174879_c.func_177972_a(direction));
            if (fluidState.func_206889_d() && fluidState.func_206886_c() == Fluids.field_204546_a) continue;
            return false;
        }
        return true;
    }
}

