/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.age.stone.blocks;

import com.google.common.collect.Lists;
import com.yanny.age.stone.blocks.IInventoryInterface;
import com.yanny.age.stone.recipes.FlintWorkbenchRecipe;
import com.yanny.age.stone.subscribers.TileEntitySubscriber;
import com.yanny.ages.api.utils.ItemStackUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FlintWorkbenchTileEntity
extends TileEntity
implements IInventoryInterface {
    private static final Logger LOGGER = LogManager.getLogger(FlintWorkbenchTileEntity.class);
    private final NonNullList<ItemStack> stacks = NonNullList.func_191197_a((int)9, (Object)ItemStack.field_190927_a);
    private final IItemHandlerModifiable nonSidedItemHandler = this.createNonSidedInventoryHandler(this.stacks);
    private final LazyOptional<IItemHandlerModifiable> nonSidedInventoryHandler = LazyOptional.of(() -> this.nonSidedItemHandler);
    private final RecipeWrapper inventoryWrapper = new RecipeWrapper(this.nonSidedItemHandler);
    private ItemStack recipeOutput = ItemStack.field_190927_a;

    public FlintWorkbenchTileEntity() {
        super(TileEntitySubscriber.flint_workbench);
    }

    public void func_145839_a(CompoundNBT tag) {
        CompoundNBT invTag = tag.func_74775_l("inv");
        CompoundNBT outTag = tag.func_74775_l("output");
        ItemStackUtils.deserializeStacks((CompoundNBT)invTag, this.stacks);
        this.recipeOutput = ItemStack.func_199557_a((CompoundNBT)outTag);
        super.func_145839_a(tag);
    }

    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag.func_218657_a("inv", (INBT)ItemStackUtils.serializeStacks(this.stacks));
        CompoundNBT outTag = new CompoundNBT();
        this.recipeOutput.func_77955_b(outTag);
        tag.func_218657_a("output", (INBT)outTag);
        return super.func_189515_b(tag);
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), this.func_200662_C().hashCode(), this.func_189517_E_());
    }

    @Nonnull
    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        super.onDataPacket(net, pkt);
        this.func_145839_a(pkt.func_148857_g());
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && side == null) {
            return this.nonSidedInventoryHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void func_145843_s() {
        this.nonSidedInventoryHandler.invalidate();
        super.func_145843_s();
    }

    @Override
    @Nonnull
    public IInventory getInventory() {
        return this.inventoryWrapper;
    }

    @Nonnull
    public NonNullList<ItemStack> getStacks() {
        return this.stacks;
    }

    @Nonnull
    public ItemStack getRecipeOutput() {
        return this.recipeOutput;
    }

    @Nonnull
    ActionResultType blockActivated(@Nonnull PlayerEntity player, @Nonnull BlockRayTraceResult hit) {
        assert (this.field_145850_b != null);
        ItemStack heldItemMainhand = player.func_184614_ca();
        List<FlintWorkbenchRecipe> recipes = this.findMatchingRecipes(heldItemMainhand);
        if (!recipes.isEmpty()) {
            if (recipes.size() > 1) {
                LOGGER.warn("Too many valid recipes! Selecting first valid recipe");
            }
            FlintWorkbenchRecipe flintWorkbenchRecipe = recipes.get(0);
            ItemStack result = flintWorkbenchRecipe.func_77572_b(this.getInventory());
            NonNullList itemStacks = NonNullList.func_191196_a();
            itemStacks.add((Object)result);
            InventoryHelper.func_219961_a((World)this.field_145850_b, (BlockPos)this.func_174877_v(), (NonNullList)itemStacks);
            for (int i = 0; i < this.stacks.size(); ++i) {
                this.stacks.set(i, (Object)ItemStack.field_190927_a);
            }
            this.recipeOutput = ItemStack.field_190927_a;
            heldItemMainhand.func_222118_a(1, (LivingEntity)player, playerEntity -> playerEntity.func_213361_c(EquipmentSlotType.MAINHAND));
            this.field_145850_b.func_184133_a(null, this.func_174877_v(), SoundEvents.field_187574_as, SoundCategory.BLOCKS, 1.0f, 1.0f);
            return ActionResultType.SUCCESS;
        }
        if (hit.func_216354_b() == Direction.UP) {
            Direction dir = (Direction)this.func_195044_w().func_177229_b((IProperty)HorizontalBlock.field_185512_D);
            int x = 0;
            int y = 0;
            switch (dir) {
                case NORTH: {
                    x = (int)Math.floor(3.0 - (hit.func_216347_e().field_72450_a - (double)hit.func_216350_a().func_177958_n()) * 3.0);
                    y = (int)Math.floor(3.0 - (hit.func_216347_e().field_72449_c - (double)hit.func_216350_a().func_177952_p()) * 3.0);
                    break;
                }
                case SOUTH: {
                    x = (int)Math.floor((hit.func_216347_e().field_72450_a - (double)hit.func_216350_a().func_177958_n()) * 3.0);
                    y = (int)Math.floor((hit.func_216347_e().field_72449_c - (double)hit.func_216350_a().func_177952_p()) * 3.0);
                    break;
                }
                case EAST: {
                    x = (int)Math.floor(3.0 - (hit.func_216347_e().field_72449_c - (double)hit.func_216350_a().func_177952_p()) * 3.0);
                    y = (int)Math.floor((hit.func_216347_e().field_72450_a - (double)hit.func_216350_a().func_177958_n()) * 3.0);
                    break;
                }
                case WEST: {
                    x = (int)Math.floor((hit.func_216347_e().field_72449_c - (double)hit.func_216350_a().func_177952_p()) * 3.0);
                    y = (int)Math.floor(3.0 - (hit.func_216347_e().field_72450_a - (double)hit.func_216350_a().func_177958_n()) * 3.0);
                }
            }
            ItemStack stack = (ItemStack)this.stacks.get(y * 3 + x);
            if (!heldItemMainhand.func_190926_b() && stack.func_190926_b()) {
                this.stacks.set(y * 3 + x, (Object)heldItemMainhand.func_77979_a(1));
                List<FlintWorkbenchRecipe> recipe = this.findMatchingRecipes();
                if (!recipe.isEmpty()) {
                    if (recipes.size() > 1) {
                        LOGGER.warn("Too many valid recipes! Selecting first valid recipe");
                    }
                    this.recipeOutput = recipe.get(0).func_77571_b().func_77946_l();
                } else {
                    this.recipeOutput = ItemStack.field_190927_a;
                }
                return ActionResultType.SUCCESS;
            }
            if (heldItemMainhand.func_190926_b() && !((ItemStack)this.stacks.get(y * 3 + x)).func_190926_b()) {
                NonNullList itemStacks = NonNullList.func_191196_a();
                itemStacks.add((Object)stack);
                InventoryHelper.func_219961_a((World)this.field_145850_b, (BlockPos)this.func_174877_v(), (NonNullList)itemStacks);
                this.stacks.set(y * 3 + x, (Object)ItemStack.field_190927_a);
                this.field_145850_b.func_184133_a(null, this.func_174877_v(), SoundEvents.field_187638_cR, SoundCategory.BLOCKS, 1.0f, 1.0f);
                List<FlintWorkbenchRecipe> recipe = this.findMatchingRecipes();
                if (!recipe.isEmpty()) {
                    if (recipes.size() > 1) {
                        LOGGER.warn("Too many valid recipes! Selecting first valid recipe");
                    }
                    this.recipeOutput = recipe.get(0).func_77571_b().func_77946_l();
                } else {
                    this.recipeOutput = ItemStack.field_190927_a;
                }
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.PASS;
    }

    @Nonnull
    private IItemHandlerModifiable createNonSidedInventoryHandler(@Nonnull NonNullList<ItemStack> stacks) {
        return new ItemStackHandler(stacks){

            protected void onContentsChanged(int slot) {
                assert (FlintWorkbenchTileEntity.this.field_145850_b != null);
                FlintWorkbenchTileEntity.this.func_70296_d();
                FlintWorkbenchTileEntity.this.field_145850_b.func_184138_a(FlintWorkbenchTileEntity.this.func_174877_v(), FlintWorkbenchTileEntity.this.func_195044_w(), FlintWorkbenchTileEntity.this.func_195044_w(), 3);
            }
        };
    }

    @Nonnull
    private List<FlintWorkbenchRecipe> findMatchingRecipes(@Nonnull ItemStack heldItemMainhand) {
        assert (this.field_145850_b != null);
        ArrayList recipes = this.stacks.stream().allMatch(ItemStack::func_190926_b) ? Lists.newArrayList() : this.field_145850_b.func_199532_z().func_215370_b(FlintWorkbenchRecipe.flint_workbench, (IInventory)this.inventoryWrapper, this.field_145850_b);
        return recipes.stream().filter(flintWorkbenchRecipe -> flintWorkbenchRecipe.testTool(heldItemMainhand)).collect(Collectors.toList());
    }

    @Nonnull
    private List<FlintWorkbenchRecipe> findMatchingRecipes() {
        assert (this.field_145850_b != null);
        return this.stacks.stream().allMatch(ItemStack::func_190926_b) ? Lists.newArrayList() : this.field_145850_b.func_199532_z().func_215370_b(FlintWorkbenchRecipe.flint_workbench, (IInventory)this.inventoryWrapper, this.field_145850_b);
    }
}

