/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.age.stone.client.renderer;

import com.yanny.age.stone.client.models.TerrorBirdModel;
import com.yanny.age.stone.entities.TerrorBirdEntity;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.registry.IRenderFactory;

@OnlyIn(value=Dist.CLIENT)
public class TerrorBirdRenderer
extends MobRenderer<TerrorBirdEntity, TerrorBirdModel> {
    private static final ResourceLocation TERROR_BIRD_TEXTURE = new ResourceLocation("stone_age", "textures/entity/terror_bird.png");

    private TerrorBirdRenderer(@Nonnull EntityRendererManager rendererManager) {
        super(rendererManager, (EntityModel)new TerrorBirdModel(), 0.3f);
    }

    @Nonnull
    public ResourceLocation getEntityTexture(@Nonnull TerrorBirdEntity entity) {
        return TERROR_BIRD_TEXTURE;
    }

    protected float handleRotationFloat(TerrorBirdEntity livingBase, float partialTicks) {
        float f = MathHelper.func_219799_g((float)partialTicks, (float)livingBase.oFlap, (float)livingBase.wingRotation);
        float f1 = MathHelper.func_219799_g((float)partialTicks, (float)livingBase.oFlapSpeed, (float)livingBase.destPos);
        return (MathHelper.func_76126_a((float)f) + 1.0f) * f1;
    }

    protected boolean canRenderName(TerrorBirdEntity entity) {
        return entity.func_145818_k_();
    }

    public static class RenderFactory
    implements IRenderFactory<TerrorBirdEntity> {
        public EntityRenderer<? super TerrorBirdEntity> createRenderFor(EntityRendererManager manager) {
            return new TerrorBirdRenderer(manager);
        }
    }
}

