/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.age.stone.compatibility.jei;

import com.google.common.collect.ImmutableList;
import com.yanny.age.stone.recipes.MillstoneRecipe;
import com.yanny.age.stone.subscribers.BlockSubscriber;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class MillstoneRecipeCategory
implements IRecipeCategory<MillstoneRecipe> {
    static final ResourceLocation UID = new ResourceLocation("stone_age", "millstone_recipe_category");
    private final String localizedName;
    private final IDrawableStatic background;
    private final IDrawable icon;

    MillstoneRecipeCategory(@Nonnull IGuiHelper guiHelper) {
        ResourceLocation location = new ResourceLocation("stone_age", "textures/gui/jei/gui_layouts.png");
        this.background = guiHelper.createDrawable(location, 0, 122, 120, 60);
        this.localizedName = I18n.func_135052_a((String)"block.stone_age.millstone", (Object[])new Object[0]);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)BlockSubscriber.millstone));
    }

    @Nonnull
    public ResourceLocation getUid() {
        return UID;
    }

    @Nonnull
    public Class<? extends MillstoneRecipe> getRecipeClass() {
        return MillstoneRecipe.class;
    }

    @Nonnull
    public String getTitle() {
        return this.localizedName;
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(@Nonnull MillstoneRecipe millstoneRecipe, @Nonnull IIngredients ingredients) {
        ImmutableList.Builder inputBuilder = ImmutableList.builder();
        ImmutableList.Builder outputBuilder = ImmutableList.builder();
        inputBuilder.add(Arrays.asList(((Ingredient)millstoneRecipe.func_192400_c().get(0)).func_193365_a()));
        outputBuilder.add(Collections.singletonList(millstoneRecipe.func_77571_b()));
        if (!millstoneRecipe.getRecipeSecondOutput().func_190926_b()) {
            outputBuilder.add(Collections.singletonList(millstoneRecipe.getRecipeSecondOutput()));
        }
        ingredients.setInputLists(VanillaTypes.ITEM, (List)inputBuilder.build());
        ingredients.setOutputLists(VanillaTypes.ITEM, (List)outputBuilder.build());
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull MillstoneRecipe millstoneRecipe, @Nonnull IIngredients ingredients) {
        recipeLayout.getItemStacks().init(0, true, 25, 21);
        recipeLayout.getItemStacks().set(0, (List)ingredients.getInputs(VanillaTypes.ITEM).get(0));
        recipeLayout.getItemStacks().init(1, false, 77, 10);
        recipeLayout.getItemStacks().set(1, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
        if (!millstoneRecipe.getRecipeSecondOutput().func_190926_b()) {
            recipeLayout.getItemStacks().init(2, false, 77, 32);
            recipeLayout.getItemStacks().set(2, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(1));
        }
    }

    public void draw(MillstoneRecipe recipe, double mouseX, double mouseY) {
        if (!recipe.getRecipeSecondOutput().func_190926_b()) {
            Minecraft.func_71410_x().field_71466_p.func_211126_b(String.format(Locale.ENGLISH, "%.0f%%", recipe.getSecondChance() * 100.0), 96.0f, 38.0f, -1);
        }
    }
}

