/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.age.stone.datagen;

import com.yanny.age.stone.datagen.DryingRackRecipeBuilder;
import com.yanny.age.stone.datagen.FlintWorkbenchRecipeBuilder;
import com.yanny.age.stone.datagen.MillstoneRecipeBuilder;
import com.yanny.age.stone.datagen.TanningRackRecipeBuilder;
import com.yanny.age.stone.datagen.TreeStumpRecipeBuilder;
import com.yanny.age.stone.subscribers.BlockSubscriber;
import com.yanny.age.stone.subscribers.FoodSubscriber;
import com.yanny.age.stone.subscribers.ItemSubscriber;
import com.yanny.age.stone.subscribers.ToolSubscriber;
import com.yanny.ages.api.utils.Tags;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.data.CookingRecipeBuilder;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.RecipeProvider;
import net.minecraft.data.ShapedRecipeBuilder;
import net.minecraft.data.ShapelessRecipeBuilder;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.CookingRecipeSerializer;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.Tags;
import org.lwjgl.system.NonnullDefault;

@NonnullDefault
public class RecipeGenerator
extends RecipeProvider {
    private static final Set<WoodItemHolder> WOOD_ITEMS = new HashSet<WoodItemHolder>();
    private static final Set<SlabHolder> SLABS = new HashSet<SlabHolder>();
    private static final Set<TerracottaHolder> TERRACOTTA = new HashSet<TerracottaHolder>();
    private static final Set<FoodHolder> FOODS = new HashSet<FoodHolder>();
    private static final Set<ToolHolder> TOOLS = new HashSet<ToolHolder>();
    private static final Set<OneItemHolder> ONE_ITEMS = new HashSet<OneItemHolder>();

    public RecipeGenerator(DataGenerator generatorIn) {
        super(generatorIn);
    }

    protected void func_200404_a(Consumer<IFinishedRecipe> consumer) {
        ShapedRecipeBuilder.func_200470_a((IItemProvider)ToolSubscriber.flint_knife).func_200472_a("F").func_200472_a("#").func_200462_a(Character.valueOf('F'), (IItemProvider)Items.field_151145_ak).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).func_200465_a("has_recipe", (ICriterionInstance)this.func_200403_a((IItemProvider)Items.field_151055_y)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)BlockSubscriber.flint_workbench).func_200472_a("FG").func_200472_a("##").func_200462_a(Character.valueOf('F'), (IItemProvider)Items.field_151145_ak).func_200469_a(Character.valueOf('G'), Tags.Items.GRAVEL).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).func_200465_a("has_recipe", (ICriterionInstance)this.func_200403_a((IItemProvider)Items.field_151055_y)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)ItemSubscriber.unlit_torch).func_200472_a("F").func_200472_a("#").func_200462_a(Character.valueOf('F'), (IItemProvider)FoodSubscriber.fat).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).func_200465_a("has_recipe", (ICriterionInstance)this.func_200403_a((IItemProvider)Items.field_151055_y)).func_200467_a(consumer, new ResourceLocation("stone_age", ItemSubscriber.unlit_torch.getRegistryName().func_110623_a() + "_shaped"));
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)ItemSubscriber.raw_bread).func_200491_b((IItemProvider)ItemSubscriber.flour, 3).func_200487_b((IItemProvider)Items.field_151102_aT).func_200483_a("has_recipe", (ICriterionInstance)this.func_200403_a((IItemProvider)ItemSubscriber.flour)).func_200485_a(consumer, new ResourceLocation("stone_age", ItemSubscriber.raw_bread.getRegistryName().func_110623_a() + "_shapeless"));
        FlintWorkbenchRecipeBuilder.shapedRecipe((IItemProvider)Items.field_151032_g).patternLine("A").patternLine("#").patternLine("F").key(Character.valueOf('A'), (IItemProvider)ItemSubscriber.bone_arrow_head).key(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).key(Character.valueOf('F'), (IItemProvider)Items.field_151008_G).tool((Tag<Item>)Tags.Items.KNIVES).addCriterion("has_recipe", (ICriterionInstance)this.func_200403_a((IItemProvider)Items.field_151055_y)).build(consumer);
        FlintWorkbenchRecipeBuilder.shapedRecipe((IItemProvider)ItemSubscriber.backpack).patternLine("GBG").patternLine("SLS").patternLine("GMG").key(Character.valueOf('G'), (IItemProvider)Items.field_151116_aA).key(Character.valueOf('L'), (IItemProvider)Items.field_151058_ca).key(Character.valueOf('B'), (IItemProvider)ItemSubscriber.fish_bone).key(Character.valueOf('S'), (IItemProvider)ItemSubscriber.saber_teeth).key(Character.valueOf('M'), (IItemProvider)ItemSubscriber.mammoth_tusk).tool((Tag<Item>)Tags.Items.KNIVES).addCriterion("has_recipe", (ICriterionInstance)this.func_200403_a((IItemProvider)Items.field_151116_aA)).build(consumer);
        FlintWorkbenchRecipeBuilder.shapedRecipe((IItemProvider)Items.field_151031_f).patternLine(" #S").patternLine("# S").patternLine(" #S").key(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).key(Character.valueOf('S'), (IItemProvider)ItemSubscriber.leather_strip).tool((Tag<Item>)Tags.Items.KNIVES).addCriterion("has_recipe", (ICriterionInstance)this.func_200403_a((IItemProvider)Items.field_151055_y)).build(consumer);
        FlintWorkbenchRecipeBuilder.shapedRecipe((IItemProvider)Items.field_222113_pS).patternLine(" S ").patternLine("SCS").patternLine("L#L").key(Character.valueOf('#'), (IItemProvider)Items.field_221657_bQ).key(Character.valueOf('L'), (Tag<Item>)ItemTags.field_200038_h).key(Character.valueOf('S'), (IItemProvider)Items.field_151055_y).key(Character.valueOf('C'), (Tag<Item>)ItemTags.field_219775_L).tool((Tag<Item>)Tags.Items.KNIVES).addCriterion("has_recipe", (ICriterionInstance)this.func_200409_a(ItemTags.field_219775_L)).build(consumer);
        FlintWorkbenchRecipeBuilder.shapedRecipe((IItemProvider)Items.field_221738_ce).patternLine("###").patternLine("#C#").patternLine("###").key(Character.valueOf('#'), (IItemProvider)Items.field_221585_m).key(Character.valueOf('C'), (IItemProvider)Items.field_222113_pS).tool((Tag<Item>)Tags.Items.KNIVES).addCriterion("has_recipe", (ICriterionInstance)this.func_200403_a((IItemProvider)Items.field_221585_m)).build(consumer);
        FlintWorkbenchRecipeBuilder.shapedRecipe((IItemProvider)Items.field_221734_cc).patternLine("HWA").patternLine("MBC").patternLine("PPP").key(Character.valueOf('H'), (IItemProvider)ToolSubscriber.stone_pickaxe).key(Character.valueOf('A'), (IItemProvider)ToolSubscriber.stone_axe).key(Character.valueOf('W'), (Tag<Item>)ItemTags.field_199904_a).key(Character.valueOf('B'), (IItemProvider)Items.field_151025_P).key(Character.valueOf('M'), (IItemProvider)BlockSubscriber.millstone).key(Character.valueOf('C'), (IItemProvider)BlockSubscriber.stone_chest).key(Character.valueOf('P'), (Tag<Item>)ItemTags.field_202899_i).tool((Tag<Item>)Tags.Items.KNIVES).addCriterion("has_recipe", (ICriterionInstance)this.func_200403_a((IItemProvider)BlockSubscriber.stone_chest)).build(consumer);
        FlintWorkbenchRecipeBuilder.shapedRecipe((IItemProvider)BlockSubscriber.dried_grass_bed).patternLine("###").patternLine("###").patternLine("CCC").key(Character.valueOf('#'), (IItemProvider)ItemSubscriber.dried_grass).key(Character.valueOf('C'), (Tag<Item>)ItemTags.field_202899_i).tool((Tag<Item>)Tags.Items.KNIVES).addCriterion("has_recipe", (ICriterionInstance)this.func_200403_a((IItemProvider)ItemSubscriber.dried_grass)).build(consumer);
        FlintWorkbenchRecipeBuilder.shapedRecipe((IItemProvider)BlockSubscriber.feeder).patternLine("WSW").patternLine("LSL").patternLine("WSW").key(Character.valueOf('L'), (Tag<Item>)ItemTags.field_200038_h).key(Character.valueOf('S'), (Tag<Item>)ItemTags.field_202899_i).key(Character.valueOf('W'), (IItemProvider)Items.field_151015_O).tool((Tag<Item>)Tags.Items.KNIVES).addCriterion("has_recipe", (ICriterionInstance)this.func_200409_a(ItemTags.field_200038_h)).build(consumer);
        FlintWorkbenchRecipeBuilder.shapedRecipe((IItemProvider)BlockSubscriber.fishing_net).patternLine("SLS").patternLine("L#L").patternLine("SLS").key(Character.valueOf('L'), (IItemProvider)ItemSubscriber.leather_strip).key(Character.valueOf('S'), (IItemProvider)Items.field_151055_y).key(Character.valueOf('#'), (Tag<Item>)ItemTags.field_202899_i).tool((Tag<Item>)Tags.Items.KNIVES).addCriterion("has_recipe", (ICriterionInstance)this.func_200403_a((IItemProvider)ItemSubscriber.leather_strip)).build(consumer);
        FlintWorkbenchRecipeBuilder.shapedRecipe((IItemProvider)ToolSubscriber.flint_spear).patternLine(" SF").patternLine(" # ").patternLine("#  ").key(Character.valueOf('F'), (IItemProvider)Items.field_151145_ak).key(Character.valueOf('S'), (IItemProvider)ItemSubscriber.leather_strip).key(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).tool((Tag<Item>)Tags.Items.KNIVES).addCriterion("has_recipe", (ICriterionInstance)this.func_200403_a((IItemProvider)ItemSubscriber.leather_strip)).build(consumer);
        FlintWorkbenchRecipeBuilder.shapedRecipe((IItemProvider)Items.field_151021_T).patternLine("XSX").patternLine("XBX").key(Character.valueOf('B'), (IItemProvider)ItemSubscriber.fish_bone).key(Character.valueOf('S'), (IItemProvider)ItemSubscriber.leather_strip).key(Character.valueOf('X'), (IItemProvider)Items.field_151116_aA).tool((Tag<Item>)Tags.Items.KNIVES).addCriterion("has_recipe", (ICriterionInstance)this.func_200403_a((IItemProvider)ItemSubscriber.leather_strip)).build(consumer);
        FlintWorkbenchRecipeBuilder.shapedRecipe((IItemProvider)Items.field_151027_R).patternLine("XBX").patternLine("XSX").patternLine("XXX").key(Character.valueOf('B'), (IItemProvider)ItemSubscriber.fish_bone).key(Character.valueOf('S'), (IItemProvider)ItemSubscriber.leather_strip).key(Character.valueOf('X'), (IItemProvider)Items.field_151116_aA).tool((Tag<Item>)Tags.Items.KNIVES).addCriterion("has_recipe", (ICriterionInstance)this.func_200403_a((IItemProvider)ItemSubscriber.leather_strip)).build(consumer);
        FlintWorkbenchRecipeBuilder.shapedRecipe((IItemProvider)Items.field_151024_Q).patternLine("XXX").patternLine("X X").patternLine("S B").key(Character.valueOf('B'), (IItemProvider)ItemSubscriber.fish_bone).key(Character.valueOf('S'), (IItemProvider)ItemSubscriber.leather_strip).key(Character.valueOf('X'), (IItemProvider)Items.field_151116_aA).tool((Tag<Item>)Tags.Items.KNIVES).addCriterion("has_recipe", (ICriterionInstance)this.func_200403_a((IItemProvider)ItemSubscriber.leather_strip)).build(consumer);
        FlintWorkbenchRecipeBuilder.shapedRecipe((IItemProvider)Items.field_151026_S).patternLine("XXX").patternLine("XSX").patternLine("XBX").key(Character.valueOf('B'), (IItemProvider)ItemSubscriber.fish_bone).key(Character.valueOf('S'), (IItemProvider)ItemSubscriber.leather_strip).key(Character.valueOf('X'), (IItemProvider)Items.field_151116_aA).tool((Tag<Item>)Tags.Items.KNIVES).addCriterion("has_recipe", (ICriterionInstance)this.func_200403_a((IItemProvider)ItemSubscriber.leather_strip)).build(consumer);
        FlintWorkbenchRecipeBuilder.shapedRecipe((IItemProvider)ItemSubscriber.raw_bread).patternLine("FFF").patternLine("X  ").key(Character.valueOf('F'), (IItemProvider)ItemSubscriber.flour).key(Character.valueOf('X'), (IItemProvider)Items.field_151102_aT).tool((Tag<Item>)Tags.Items.KNIVES).addCriterion("has_recipe", (ICriterionInstance)this.func_200403_a((IItemProvider)ItemSubscriber.flour)).build(consumer);
        FlintWorkbenchRecipeBuilder.shapedRecipe((IItemProvider)ItemSubscriber.unlit_torch).patternLine("F").patternLine("X").key(Character.valueOf('F'), (IItemProvider)FoodSubscriber.fat).key(Character.valueOf('X'), (IItemProvider)Items.field_151055_y).tool((Tag<Item>)Tags.Items.KNIVES).addCriterion("has_recipe", (ICriterionInstance)this.func_200403_a((IItemProvider)ItemSubscriber.unlit_torch)).build(consumer);
        FlintWorkbenchRecipeBuilder.shapedRecipe((IItemProvider)BlockSubscriber.millstone).patternLine("#A#").patternLine("#G#").patternLine("SSS").key(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).key(Character.valueOf('A'), (IItemProvider)Items.field_221579_g).key(Character.valueOf('G'), (IItemProvider)Items.field_221575_c).key(Character.valueOf('S'), (IItemProvider)Items.field_221714_bs).tool((Tag<Item>)Tags.Items.KNIVES).addCriterion("has_recipe", (ICriterionInstance)this.func_200403_a((IItemProvider)Items.field_221579_g)).build(consumer);
        FlintWorkbenchRecipeBuilder.shapedRecipe((IItemProvider)BlockSubscriber.stone_chest).patternLine("###").patternLine("SCS").patternLine("SSS").key(Character.valueOf('#'), (IItemProvider)Items.field_221714_bs).key(Character.valueOf('C'), (IItemProvider)Items.field_151119_aD).key(Character.valueOf('S'), (IItemProvider)Items.field_221574_b).tool((Tag<Item>)Tags.Items.KNIVES).addCriterion("has_recipe", (ICriterionInstance)this.func_200403_a((IItemProvider)Items.field_221574_b)).build(consumer);
        FlintWorkbenchRecipeBuilder.shapedRecipe((IItemProvider)ToolSubscriber.stone_hammer).patternLine(" XS").patternLine(" #X").patternLine("#  ").key(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).key(Character.valueOf('X'), (IItemProvider)Items.field_221574_b).key(Character.valueOf('S'), (IItemProvider)ItemSubscriber.leather_strip).tool((Tag<Item>)Tags.Items.KNIVES).addCriterion("has_recipe", (ICriterionInstance)this.func_200403_a((IItemProvider)ItemSubscriber.leather_strip)).build(consumer);
        FlintWorkbenchRecipeBuilder.shapedRecipe((IItemProvider)BlockSubscriber.tree_stump).patternLine(" # ").patternLine("FFF").key(Character.valueOf('#'), (Tag<Item>)ItemTags.field_200038_h).key(Character.valueOf('F'), (IItemProvider)Items.field_221574_b).tool((Tag<Item>)Tags.Items.KNIVES).addCriterion("has_recipe", (ICriterionInstance)this.func_200403_a((IItemProvider)Items.field_221574_b)).build(consumer);
        FlintWorkbenchRecipeBuilder.shapedRecipe((IItemProvider)Items.field_221657_bQ).patternLine("F").patternLine("#").key(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).key(Character.valueOf('F'), (IItemProvider)FoodSubscriber.fat).tool((Tag<Item>)Tags.Items.KNIVES).addCriterion("has_recipe", (ICriterionInstance)this.func_200403_a((IItemProvider)Items.field_151055_y)).build(consumer);
        TreeStumpRecipeBuilder.recipe((IItemProvider)BlockSubscriber.thatch_slab, (IItemProvider)BlockSubscriber.thatch_block, 2).chopTimes(2).tool((Tag<Item>)Tags.Items.AXES).addCriterion("has_recipe", (ICriterionInstance)this.func_200403_a((IItemProvider)BlockSubscriber.thatch_block)).build(consumer);
        TreeStumpRecipeBuilder.recipe((IItemProvider)Items.field_196106_bc, (IItemProvider)ItemSubscriber.mammoth_tusk, 8).chopTimes(3).tool((Tag<Item>)Tags.Items.HAMMERS).addCriterion("has_recipe", (ICriterionInstance)this.func_200403_a((IItemProvider)ItemSubscriber.mammoth_tusk)).build(consumer, new ResourceLocation("stone_age", Items.field_196106_bc.getRegistryName().func_110623_a() + "_from_mammoth_tusk"));
        TreeStumpRecipeBuilder.recipe((IItemProvider)Items.field_196106_bc, (IItemProvider)ItemSubscriber.rhino_tusk, 4).chopTimes(1).tool((Tag<Item>)Tags.Items.HAMMERS).addCriterion("has_recipe", (ICriterionInstance)this.func_200403_a((IItemProvider)ItemSubscriber.rhino_tusk)).build(consumer, new ResourceLocation("stone_age", Items.field_196106_bc.getRegistryName().func_110623_a() + "_from_rhino_tusk"));
        TreeStumpRecipeBuilder.recipe((IItemProvider)Items.field_196106_bc, (IItemProvider)ItemSubscriber.saber_teeth, 3).chopTimes(1).tool((Tag<Item>)Tags.Items.HAMMERS).addCriterion("has_recipe", (ICriterionInstance)this.func_200403_a((IItemProvider)ItemSubscriber.saber_teeth)).build(consumer, new ResourceLocation("stone_age", Items.field_196106_bc.getRegistryName().func_110623_a() + "_from_saber_teeth"));
        TreeStumpRecipeBuilder.recipe((IItemProvider)Items.field_196106_bc, (IItemProvider)Items.field_151103_aS, 1).chopTimes(1).tool((Tag<Item>)Tags.Items.HAMMERS).addCriterion("has_recipe", (ICriterionInstance)this.func_200403_a((IItemProvider)Items.field_151103_aS)).build(consumer, new ResourceLocation("stone_age", Items.field_196106_bc.getRegistryName().func_110623_a() + "_from_bone"));
        MillstoneRecipeBuilder.recipe((IItemProvider)ItemSubscriber.flour, (IItemProvider)Items.field_151015_O, 2).activateCount(2).secondResult((IItemProvider)ItemSubscriber.flour, 0.1f).addCriterion("has_recipe", (ICriterionInstance)this.func_200403_a((IItemProvider)Items.field_151015_O)).build(consumer);
        MillstoneRecipeBuilder.recipe((IItemProvider)Items.field_151102_aT, (IItemProvider)Items.field_222065_kN, 2).activateCount(2).secondResult((IItemProvider)Items.field_151102_aT, 0.1f).addCriterion("has_recipe", (ICriterionInstance)this.func_200403_a((IItemProvider)Items.field_222065_kN)).build(consumer);
        DryingRackRecipeBuilder.recipe((IItemProvider)ItemSubscriber.dried_grass, (IItemProvider)Items.field_221674_ay).dryingTime(1200).addCriterion("has_recipe", (ICriterionInstance)this.func_200403_a((IItemProvider)Items.field_221674_ay)).build(consumer);
        TanningRackRecipeBuilder.recipe((IItemProvider)Items.field_151116_aA, (IItemProvider)ItemSubscriber.raw_hide).tool((Tag<Item>)Tags.Items.KNIVES).addCriterion("has_recipe", (ICriterionInstance)this.func_200403_a((IItemProvider)ItemSubscriber.raw_hide)).build(consumer);
        WOOD_ITEMS.forEach(item -> this.registerVanillaWoodRecipes((WoodItemHolder)item, consumer));
        SLABS.forEach(item -> this.registerVanillaSlabRecipes((SlabHolder)item, consumer));
        TERRACOTTA.forEach(item -> this.registerVanillaTerracottaRecipes((TerracottaHolder)item, consumer));
        FOODS.forEach(item -> this.registerFoodRecipes((FoodHolder)item, consumer));
        TOOLS.forEach(item -> this.registerToolRecipes((ToolHolder)item, consumer));
        ONE_ITEMS.forEach(item -> this.registerOneItemFlintWorkbenchRecipes((OneItemHolder)item, consumer));
    }

    private void registerOneItemFlintWorkbenchRecipes(OneItemHolder oneItemHolder, Consumer<IFinishedRecipe> consumer) {
        FlintWorkbenchRecipeBuilder recipe = FlintWorkbenchRecipeBuilder.shapedRecipe(oneItemHolder.result, oneItemHolder.count);
        for (String patternLine : oneItemHolder.patternLines) {
            recipe.patternLine(patternLine);
        }
        recipe.key(Character.valueOf('#'), oneItemHolder.item).tool((Tag<Item>)Tags.Items.KNIVES).addCriterion("has_recipe", (ICriterionInstance)this.func_200405_a(new ItemPredicate[]{oneItemHolder.criterion})).build(consumer);
    }

    private void registerToolRecipes(ToolHolder toolHolder, Consumer<IFinishedRecipe> consumer) {
        FlintWorkbenchRecipeBuilder.shapedRecipe(toolHolder.output).patternLine("HL").patternLine("# ").key(Character.valueOf('H'), toolHolder.input).key(Character.valueOf('L'), toolHolder.lead).key(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).tool((Tag<Item>)Tags.Items.KNIVES).addCriterion("has_recipe", (ICriterionInstance)this.func_200403_a((IItemProvider)Items.field_151055_y)).build(consumer);
    }

    private void registerFoodRecipes(FoodHolder foodHolder, Consumer<IFinishedRecipe> consumer) {
        ResourceLocation location = foodHolder.output.func_199767_j().getRegistryName();
        if (location == null) {
            throw new IllegalStateException("Null resource location! " + foodHolder.output);
        }
        CookingRecipeBuilder.func_218631_a((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{foodHolder.input}), (IItemProvider)foodHolder.output, (float)0.35f, (int)200, (CookingRecipeSerializer)IRecipeSerializer.field_222171_o).func_218628_a("has_recipe", (ICriterionInstance)this.func_200403_a(foodHolder.input)).func_218635_a(consumer, new ResourceLocation(location.func_110624_b(), location.func_110623_a() + "_from_smelting"));
        CookingRecipeBuilder.func_218631_a((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{foodHolder.input}), (IItemProvider)foodHolder.output, (float)0.35f, (int)600, (CookingRecipeSerializer)IRecipeSerializer.field_222174_r).func_218628_a("has_recipe", (ICriterionInstance)this.func_200403_a(foodHolder.input)).func_218635_a(consumer, new ResourceLocation(location.func_110624_b(), location.func_110623_a() + "_from_campfire_cooking"));
        CookingRecipeBuilder.func_218631_a((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{foodHolder.input}), (IItemProvider)foodHolder.output, (float)0.35f, (int)100, (CookingRecipeSerializer)IRecipeSerializer.field_222173_q).func_218628_a("has_recipe", (ICriterionInstance)this.func_200403_a(foodHolder.input)).func_218635_a(consumer, new ResourceLocation(location.func_110624_b(), location.func_110623_a() + "_from_smoking"));
    }

    private void registerVanillaTerracottaRecipes(TerracottaHolder terracottaHolder, Consumer<IFinishedRecipe> consumer) {
        FlintWorkbenchRecipeBuilder.shapedRecipe(terracottaHolder.item, 8).patternLine("###").patternLine("#G#").patternLine("###").key(Character.valueOf('G'), terracottaHolder.color).key(Character.valueOf('#'), (IItemProvider)Items.field_221894_fe).tool((Tag<Item>)Tags.Items.KNIVES).addCriterion("has_recipe", (ICriterionInstance)this.func_200403_a((IItemProvider)Items.field_221894_fe)).build(consumer);
    }

    private void registerVanillaSlabRecipes(SlabHolder slabHolder, Consumer<IFinishedRecipe> consumer) {
        TreeStumpRecipeBuilder.recipe(slabHolder.slab, slabHolder.item, 2).chopTimes(2).tool((Tag<Item>)Tags.Items.HAMMERS).addCriterion("has_recipe", (ICriterionInstance)this.func_200403_a(slabHolder.item)).build(consumer);
    }

    private void registerVanillaWoodRecipes(WoodItemHolder woodItemHolder, Consumer<IFinishedRecipe> consumer) {
        FlintWorkbenchRecipeBuilder.shapedRecipe(woodItemHolder.boat).patternLine("# #").patternLine("###").key(Character.valueOf('#'), woodItemHolder.planks).tool((Tag<Item>)Tags.Items.KNIVES).addCriterion("has_recipe", (ICriterionInstance)this.func_200403_a(woodItemHolder.planks)).build(consumer);
        FlintWorkbenchRecipeBuilder.shapedRecipe(woodItemHolder.fence, 3).patternLine("#S#").patternLine("#S#").key(Character.valueOf('#'), woodItemHolder.planks).key(Character.valueOf('S'), (IItemProvider)Items.field_151055_y).tool((Tag<Item>)Tags.Items.KNIVES).addCriterion("has_recipe", (ICriterionInstance)this.func_200403_a(woodItemHolder.planks)).build(consumer);
        FlintWorkbenchRecipeBuilder.shapedRecipe(woodItemHolder.fenceGate).patternLine("S#S").patternLine("S#S").key(Character.valueOf('#'), woodItemHolder.planks).key(Character.valueOf('S'), (IItemProvider)Items.field_151055_y).tool((Tag<Item>)Tags.Items.KNIVES).addCriterion("has_recipe", (ICriterionInstance)this.func_200403_a(woodItemHolder.planks)).build(consumer);
        TreeStumpRecipeBuilder.recipe(woodItemHolder.planks, woodItemHolder.log, 2).chopTimes(2).tool((Tag<Item>)Tags.Items.AXES).addCriterion("has_recipe", (ICriterionInstance)this.func_200403_a(woodItemHolder.log)).build(consumer);
        TreeStumpRecipeBuilder.recipe(woodItemHolder.slab, woodItemHolder.planks, 2).chopTimes(2).tool((Tag<Item>)Tags.Items.AXES).addCriterion("has_recipe", (ICriterionInstance)this.func_200403_a(woodItemHolder.planks)).build(consumer);
    }

    static {
        WOOD_ITEMS.add(new WoodItemHolder((IItemProvider)Items.field_185153_aK, (IItemProvider)Items.field_221683_cD, (IItemProvider)Items.field_221806_dm, (IItemProvider)Items.field_221590_r, (IItemProvider)Items.field_221708_bp, (IItemProvider)Items.field_221558_K));
        WOOD_ITEMS.add(new WoodItemHolder((IItemProvider)Items.field_185151_aI, (IItemProvider)Items.field_221679_cB, (IItemProvider)Items.field_221802_dk, (IItemProvider)Items.field_221588_p, (IItemProvider)Items.field_221704_bn, (IItemProvider)Items.field_221556_I));
        WOOD_ITEMS.add(new WoodItemHolder((IItemProvider)Items.field_185154_aL, (IItemProvider)Items.field_221685_cE, (IItemProvider)Items.field_221808_dn, (IItemProvider)Items.field_221591_s, (IItemProvider)Items.field_221710_bq, (IItemProvider)Items.field_221559_L));
        WOOD_ITEMS.add(new WoodItemHolder((IItemProvider)Items.field_185152_aJ, (IItemProvider)Items.field_221681_cC, (IItemProvider)Items.field_221804_dl, (IItemProvider)Items.field_221589_q, (IItemProvider)Items.field_221706_bo, (IItemProvider)Items.field_221557_J));
        WOOD_ITEMS.add(new WoodItemHolder((IItemProvider)Items.field_151124_az, (IItemProvider)Items.field_221780_cz, (IItemProvider)Items.field_221798_di, (IItemProvider)Items.field_221586_n, (IItemProvider)Items.field_221700_bl, (IItemProvider)Items.field_221554_G));
        WOOD_ITEMS.add(new WoodItemHolder((IItemProvider)Items.field_185150_aH, (IItemProvider)Items.field_221677_cA, (IItemProvider)Items.field_221800_dj, (IItemProvider)Items.field_221587_o, (IItemProvider)Items.field_221702_bm, (IItemProvider)Items.field_221555_H));
        SLABS.add(new SlabHolder((IItemProvider)Items.field_221579_g, (IItemProvider)Items.field_222003_iH));
        SLABS.add(new SlabHolder((IItemProvider)Items.field_221647_bL, (IItemProvider)Items.field_221724_bx));
        SLABS.add(new SlabHolder((IItemProvider)Items.field_221585_m, (IItemProvider)Items.field_221722_bw));
        SLABS.add(new SlabHolder((IItemProvider)Items.field_221950_gg, (IItemProvider)Items.field_221629_bC));
        SLABS.add(new SlabHolder((IItemProvider)Items.field_221662_as, (IItemProvider)Items.field_221718_bu));
        SLABS.add(new SlabHolder((IItemProvider)Items.field_221577_e, (IItemProvider)Items.field_222009_iK));
        SLABS.add(new SlabHolder((IItemProvider)Items.field_221575_c, (IItemProvider)Items.field_222001_iG));
        SLABS.add(new SlabHolder((IItemProvider)Items.field_221653_bO, (IItemProvider)Items.field_221993_iC));
        SLABS.add(new SlabHolder((IItemProvider)Items.field_221725_cY, (IItemProvider)Items.field_221989_iA));
        SLABS.add(new SlabHolder((IItemProvider)Items.field_221580_h, (IItemProvider)Items.field_222007_iJ));
        SLABS.add(new SlabHolder((IItemProvider)Items.field_221578_f, (IItemProvider)Items.field_221991_iB));
        SLABS.add(new SlabHolder((IItemProvider)Items.field_221576_d, (IItemProvider)Items.field_222063_iy));
        SLABS.add(new SlabHolder((IItemProvider)Items.field_221946_ge, (IItemProvider)Items.field_221627_bB));
        SLABS.add(new SlabHolder((IItemProvider)Items.field_221658_aq, (IItemProvider)Items.field_221716_bt));
        SLABS.add(new SlabHolder((IItemProvider)Items.field_221641_bI, (IItemProvider)Items.field_222064_iz));
        SLABS.add(new SlabHolder((IItemProvider)Items.field_221643_bJ, (IItemProvider)Items.field_221997_iE));
        SLABS.add(new SlabHolder((IItemProvider)Items.field_221645_bK, (IItemProvider)Items.field_221714_bs));
        SLABS.add(new SlabHolder((IItemProvider)Items.field_221723_cX, (IItemProvider)Items.field_221726_by));
        SLABS.add(new SlabHolder((IItemProvider)Items.field_221574_b, (IItemProvider)Items.field_221712_br));
        TERRACOTTA.add(new TerracottaHolder((IItemProvider)Items.field_221801_eK, (Tag<Item>)Tags.Items.DYES_BLACK));
        TERRACOTTA.add(new TerracottaHolder((IItemProvider)Items.field_221793_eG, (Tag<Item>)Tags.Items.DYES_BLUE));
        TERRACOTTA.add(new TerracottaHolder((IItemProvider)Items.field_221795_eH, (Tag<Item>)Tags.Items.DYES_BROWN));
        TERRACOTTA.add(new TerracottaHolder((IItemProvider)Items.field_221789_eE, (Tag<Item>)Tags.Items.DYES_CYAN));
        TERRACOTTA.add(new TerracottaHolder((IItemProvider)Items.field_221785_eC, (Tag<Item>)Tags.Items.DYES_GRAY));
        TERRACOTTA.add(new TerracottaHolder((IItemProvider)Items.field_221797_eI, (Tag<Item>)Tags.Items.DYES_GREEN));
        TERRACOTTA.add(new TerracottaHolder((IItemProvider)Items.field_221882_ey, (Tag<Item>)Tags.Items.DYES_LIGHT_BLUE));
        TERRACOTTA.add(new TerracottaHolder((IItemProvider)Items.field_221787_eD, (Tag<Item>)Tags.Items.DYES_LIGHT_GRAY));
        TERRACOTTA.add(new TerracottaHolder((IItemProvider)Items.field_221781_eA, (Tag<Item>)Tags.Items.DYES_LIME));
        TERRACOTTA.add(new TerracottaHolder((IItemProvider)Items.field_221880_ex, (Tag<Item>)Tags.Items.DYES_MAGENTA));
        TERRACOTTA.add(new TerracottaHolder((IItemProvider)Items.field_221878_ew, (Tag<Item>)Tags.Items.DYES_ORANGE));
        TERRACOTTA.add(new TerracottaHolder((IItemProvider)Items.field_221783_eB, (Tag<Item>)Tags.Items.DYES_PINK));
        TERRACOTTA.add(new TerracottaHolder((IItemProvider)Items.field_221791_eF, (Tag<Item>)Tags.Items.DYES_PURPLE));
        TERRACOTTA.add(new TerracottaHolder((IItemProvider)Items.field_221799_eJ, (Tag<Item>)Tags.Items.DYES_RED));
        TERRACOTTA.add(new TerracottaHolder((IItemProvider)Items.field_221876_ev, (Tag<Item>)Tags.Items.DYES_WHITE));
        TERRACOTTA.add(new TerracottaHolder((IItemProvider)Items.field_221884_ez, (Tag<Item>)Tags.Items.DYES_YELLOW));
        FOODS.add(new FoodHolder((IItemProvider)FoodSubscriber.auroch_meat, (IItemProvider)FoodSubscriber.cooked_auroch_meat));
        FOODS.add(new FoodHolder((IItemProvider)FoodSubscriber.boar_meat, (IItemProvider)FoodSubscriber.cooked_boar_meat));
        FOODS.add(new FoodHolder((IItemProvider)FoodSubscriber.fat, (IItemProvider)FoodSubscriber.cooked_fat));
        FOODS.add(new FoodHolder((IItemProvider)FoodSubscriber.fowl_meat, (IItemProvider)FoodSubscriber.cooked_fowl_meat));
        FOODS.add(new FoodHolder((IItemProvider)FoodSubscriber.mammoth_meat, (IItemProvider)FoodSubscriber.cooked_mammoth_meat));
        FOODS.add(new FoodHolder((IItemProvider)FoodSubscriber.mouflon_meat, (IItemProvider)FoodSubscriber.cooked_mouflon_meat));
        FOODS.add(new FoodHolder((IItemProvider)FoodSubscriber.rhino_meat, (IItemProvider)FoodSubscriber.cooked_rhino_meat));
        FOODS.add(new FoodHolder((IItemProvider)FoodSubscriber.tiger_meat, (IItemProvider)FoodSubscriber.cooked_tiger_meat));
        FOODS.add(new FoodHolder((IItemProvider)FoodSubscriber.venison, (IItemProvider)FoodSubscriber.cooked_venison));
        FOODS.add(new FoodHolder((IItemProvider)ItemSubscriber.raw_bread, (IItemProvider)Items.field_151025_P));
        TOOLS.add(new ToolHolder((IItemProvider)ToolSubscriber.bone_axe, (IItemProvider)ToolSubscriber.bone_axe_head, (IItemProvider)ItemSubscriber.grass_lead));
        TOOLS.add(new ToolHolder((IItemProvider)ToolSubscriber.bone_hoe, (IItemProvider)ToolSubscriber.bone_hoe_head, (IItemProvider)ItemSubscriber.grass_lead));
        TOOLS.add(new ToolHolder((IItemProvider)ToolSubscriber.bone_pickaxe, (IItemProvider)ToolSubscriber.bone_pickaxe_head, (IItemProvider)ItemSubscriber.grass_lead));
        TOOLS.add(new ToolHolder((IItemProvider)ToolSubscriber.bone_shovel, (IItemProvider)ToolSubscriber.bone_shovel_head, (IItemProvider)ItemSubscriber.grass_lead));
        TOOLS.add(new ToolHolder((IItemProvider)ToolSubscriber.bone_sword, (IItemProvider)ToolSubscriber.bone_sword_head, (IItemProvider)ItemSubscriber.grass_lead));
        TOOLS.add(new ToolHolder((IItemProvider)ToolSubscriber.stone_axe, (IItemProvider)ToolSubscriber.stone_axe_head, (IItemProvider)ItemSubscriber.leather_strip));
        TOOLS.add(new ToolHolder((IItemProvider)ToolSubscriber.stone_hoe, (IItemProvider)ToolSubscriber.stone_hoe_head, (IItemProvider)ItemSubscriber.leather_strip));
        TOOLS.add(new ToolHolder((IItemProvider)ToolSubscriber.stone_pickaxe, (IItemProvider)ToolSubscriber.stone_pickaxe_head, (IItemProvider)ItemSubscriber.leather_strip));
        TOOLS.add(new ToolHolder((IItemProvider)ToolSubscriber.stone_shovel, (IItemProvider)ToolSubscriber.stone_shovel_head, (IItemProvider)ItemSubscriber.leather_strip));
        TOOLS.add(new ToolHolder((IItemProvider)ToolSubscriber.stone_sword, (IItemProvider)ToolSubscriber.stone_sword_head, (IItemProvider)ItemSubscriber.leather_strip));
        ONE_ITEMS.add(new OneItemHolder((IItemProvider)ItemSubscriber.bone_arrow_head, (Tag<Item>)Tags.Items.BONES, (Tag<Item>)Tags.Items.BONES, new String[]{"#"}));
        ONE_ITEMS.add(new OneItemHolder((IItemProvider)ToolSubscriber.bone_axe_head, (Tag<Item>)Tags.Items.BONES, (Tag<Item>)Tags.Items.BONES, new String[]{"##", "# "}));
        ONE_ITEMS.add(new OneItemHolder((IItemProvider)ToolSubscriber.bone_hoe_head, (Tag<Item>)Tags.Items.BONES, (Tag<Item>)Tags.Items.BONES, new String[]{"##"}));
        ONE_ITEMS.add(new OneItemHolder((IItemProvider)ToolSubscriber.bone_pickaxe_head, (Tag<Item>)Tags.Items.BONES, (Tag<Item>)Tags.Items.BONES, new String[]{"###"}));
        ONE_ITEMS.add(new OneItemHolder((IItemProvider)ToolSubscriber.bone_shears, (Tag<Item>)Tags.Items.BONES, (Tag<Item>)Tags.Items.BONES, new String[]{" #", "# "}));
        ONE_ITEMS.add(new OneItemHolder((IItemProvider)ToolSubscriber.bone_shovel_head, (Tag<Item>)Tags.Items.BONES, (Tag<Item>)Tags.Items.BONES, new String[]{"#", "#"}));
        ONE_ITEMS.add(new OneItemHolder((IItemProvider)ToolSubscriber.bone_sword_head, (Tag<Item>)Tags.Items.BONES, (Tag<Item>)Tags.Items.BONES, new String[]{"#", "#", "#"}));
        ONE_ITEMS.add(new OneItemHolder((IItemProvider)ItemSubscriber.cobweb_mesh, (IItemProvider)Items.field_151007_F, (IItemProvider)Items.field_151007_F, new String[]{"##", "##"}));
        ONE_ITEMS.add(new OneItemHolder((IItemProvider)BlockSubscriber.aqueduct, (IItemProvider)Items.field_151118_aC, (IItemProvider)Items.field_151118_aC, new String[]{"# #", "# #", "###"}));
        ONE_ITEMS.add(new OneItemHolder((IItemProvider)BlockSubscriber.drying_rack, (IItemProvider)Items.field_151055_y, (IItemProvider)Items.field_151055_y, new String[]{"# #", " # ", "# #"}));
        ONE_ITEMS.add(new OneItemHolder((IItemProvider)BlockSubscriber.tanning_rack, (IItemProvider)Items.field_151055_y, (IItemProvider)Items.field_151055_y, new String[]{"# #", " # ", "###"}));
        ONE_ITEMS.add(new OneItemHolder((IItemProvider)Items.field_222087_nH, (IItemProvider)Items.field_151118_aC, (IItemProvider)Items.field_151118_aC, new String[]{"# #", " # "}));
        ONE_ITEMS.add(new OneItemHolder((IItemProvider)ItemSubscriber.grass_lead, (IItemProvider)ItemSubscriber.dried_grass, (IItemProvider)ItemSubscriber.dried_grass, new String[]{"###"}));
        ONE_ITEMS.add(new OneItemHolder((IItemProvider)ItemSubscriber.grass_mesh, (IItemProvider)ItemSubscriber.dried_grass, (IItemProvider)ItemSubscriber.dried_grass, new String[]{"##", "##"}));
        ONE_ITEMS.add(new OneItemHolder((IItemProvider)Items.field_221807_eN, (IItemProvider)Items.field_151015_O, (IItemProvider)Items.field_151015_O, new String[]{"###", "###", "###"}));
        ONE_ITEMS.add(new OneItemHolder((IItemProvider)Items.field_151058_ca, (IItemProvider)ItemSubscriber.leather_strip, (IItemProvider)ItemSubscriber.leather_strip, new String[]{"## ", "# #", " ##"}));
        ONE_ITEMS.add(new OneItemHolder((IItemProvider)ToolSubscriber.stone_axe_head, (Tag<Item>)Tags.Items.STONE, (IItemProvider)Items.field_221574_b, new String[]{"##", "# "}));
        ONE_ITEMS.add(new OneItemHolder((IItemProvider)ToolSubscriber.stone_hoe_head, (Tag<Item>)Tags.Items.STONE, (IItemProvider)Items.field_221574_b, new String[]{"##"}));
        ONE_ITEMS.add(new OneItemHolder((IItemProvider)ToolSubscriber.stone_pickaxe_head, (Tag<Item>)Tags.Items.STONE, (IItemProvider)Items.field_221574_b, new String[]{"###"}));
        ONE_ITEMS.add(new OneItemHolder((IItemProvider)ToolSubscriber.stone_shovel_head, (Tag<Item>)Tags.Items.STONE, (IItemProvider)Items.field_221574_b, new String[]{"#", "#"}));
        ONE_ITEMS.add(new OneItemHolder((IItemProvider)ToolSubscriber.stone_sword_head, (Tag<Item>)Tags.Items.STONE, (IItemProvider)Items.field_221574_b, new String[]{"#", "#", "#"}));
        ONE_ITEMS.add(new OneItemHolder((IItemProvider)BlockSubscriber.thatch_block, (IItemProvider)ItemSubscriber.dried_grass, (IItemProvider)ItemSubscriber.dried_grass, new String[]{"###", "###", "###"}));
        ONE_ITEMS.add(new OneItemHolder((IItemProvider)BlockSubscriber.thatch_stairs, (IItemProvider)ItemSubscriber.dried_grass, (IItemProvider)ItemSubscriber.dried_grass, new String[]{"#  ", "## ", "###"}));
        ONE_ITEMS.add(new OneItemHolder((IItemProvider)ItemSubscriber.leather_strip, (IItemProvider)Items.field_151116_aA, (IItemProvider)Items.field_151116_aA, 4, new String[]{"#"}));
    }

    private static class OneItemHolder {
        final IItemProvider result;
        final Ingredient item;
        final String[] patternLines;
        final ItemPredicate criterion;
        final int count;

        OneItemHolder(IItemProvider result, Tag<Item> item, Tag<Item> criterion, String[] patternLines) {
            this.result = result;
            this.item = Ingredient.func_199805_a(item);
            this.criterion = ItemPredicate.Builder.func_200309_a().func_200307_a(criterion).func_200310_b();
            this.patternLines = patternLines;
            this.count = 1;
        }

        OneItemHolder(IItemProvider result, Tag<Item> item, IItemProvider criterion, String[] patternLines) {
            this.result = result;
            this.item = Ingredient.func_199805_a(item);
            this.criterion = ItemPredicate.Builder.func_200309_a().func_200308_a(criterion).func_200310_b();
            this.patternLines = patternLines;
            this.count = 1;
        }

        OneItemHolder(IItemProvider result, IItemProvider item, IItemProvider criterion, String[] patternLines) {
            this.result = result;
            this.item = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{item});
            this.criterion = ItemPredicate.Builder.func_200309_a().func_200308_a(criterion).func_200310_b();
            this.patternLines = patternLines;
            this.count = 1;
        }

        OneItemHolder(IItemProvider result, IItemProvider item, IItemProvider criterion, int count, String[] patternLines) {
            this.result = result;
            this.item = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{item});
            this.criterion = ItemPredicate.Builder.func_200309_a().func_200308_a(criterion).func_200310_b();
            this.patternLines = patternLines;
            this.count = count;
        }
    }

    private static class ToolHolder {
        final IItemProvider output;
        final IItemProvider input;
        final IItemProvider lead;

        ToolHolder(IItemProvider output, IItemProvider input, IItemProvider lead) {
            this.output = output;
            this.input = input;
            this.lead = lead;
        }
    }

    private static class FoodHolder {
        final IItemProvider input;
        final IItemProvider output;

        FoodHolder(IItemProvider input, IItemProvider output) {
            this.input = input;
            this.output = output;
        }
    }

    private static class TerracottaHolder {
        final IItemProvider item;
        final Tag<Item> color;

        TerracottaHolder(IItemProvider item, Tag<Item> color) {
            this.item = item;
            this.color = color;
        }
    }

    private static class SlabHolder {
        final IItemProvider item;
        final IItemProvider slab;

        SlabHolder(IItemProvider item, IItemProvider slab) {
            this.item = item;
            this.slab = slab;
        }
    }

    private static class WoodItemHolder {
        final IItemProvider boat;
        final IItemProvider fence;
        final IItemProvider fenceGate;
        final IItemProvider planks;
        final IItemProvider slab;
        final IItemProvider log;

        WoodItemHolder(IItemProvider boat, IItemProvider fence, IItemProvider fenceGate, IItemProvider planks, IItemProvider slab, IItemProvider log) {
            this.boat = boat;
            this.fence = fence;
            this.fenceGate = fenceGate;
            this.planks = planks;
            this.slab = slab;
            this.log = log;
        }
    }
}

