/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.age.stone.entities;

import com.yanny.age.stone.items.SpearItem;
import com.yanny.age.stone.subscribers.EntitySubscriber;
import com.yanny.age.stone.subscribers.ToolSubscriber;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public class FlintSpearEntity
extends AbstractArrowEntity {
    private static final DataParameter<Byte> LOYALTY_LEVEL = EntityDataManager.func_187226_a(FlintSpearEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private ItemStack thrownStack = new ItemStack((IItemProvider)ToolSubscriber.flint_spear);
    private boolean dealtDamage;
    public int returningTicks;

    public FlintSpearEntity(@Nonnull EntityType<? extends FlintSpearEntity> type, @Nonnull World worldIn) {
        super(type, worldIn);
    }

    public FlintSpearEntity(@Nonnull World worldIn, @Nonnull LivingEntity thrower, @Nonnull ItemStack thrownStackIn) {
        super(EntitySubscriber.flint_spear, thrower, worldIn);
        this.thrownStack = thrownStackIn.func_77946_l();
        this.field_70180_af.func_187227_b(LOYALTY_LEVEL, (Object)((byte)EnchantmentHelper.func_203191_f((ItemStack)thrownStackIn)));
    }

    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(LOYALTY_LEVEL, (Object)0);
    }

    public void func_70071_h_() {
        if (this.field_184552_b > 4) {
            this.dealtDamage = true;
        }
        Entity entity = this.func_212360_k();
        if ((this.dealtDamage || this.func_203047_q()) && entity != null) {
            byte i = (Byte)this.field_70180_af.func_187225_a(LOYALTY_LEVEL);
            if (i > 0 && !this.shouldReturnToThrower()) {
                if (!this.field_70170_p.field_72995_K && this.field_70251_a == AbstractArrowEntity.PickupStatus.ALLOWED) {
                    this.func_70099_a(this.func_184550_j(), 0.1f);
                }
                this.func_70106_y();
            } else if (i > 0) {
                this.func_203045_n(true);
                Vec3d vec3d = new Vec3d(entity.func_226277_ct_() - this.func_226277_ct_(), entity.func_226278_cu_() + (double)entity.func_70047_e() - this.func_226278_cu_(), entity.func_226281_cx_() - this.func_226281_cx_());
                this.func_70107_b(this.func_226277_ct_(), vec3d.field_72448_b * 0.015 * (double)i, this.func_226281_cx_());
                if (this.field_70170_p.field_72995_K) {
                    this.field_70137_T = this.func_226278_cu_();
                }
                double d0 = 0.05 * (double)i;
                this.func_213317_d(this.func_213322_ci().func_186678_a(0.95).func_178787_e(vec3d.func_72432_b().func_186678_a(d0)));
                if (this.returningTicks == 0) {
                    this.func_184185_a(SoundEvents.field_203270_il, 10.0f, 1.0f);
                }
                ++this.returningTicks;
            }
        }
        super.func_70071_h_();
    }

    @Nonnull
    public ItemStack func_184550_j() {
        return this.thrownStack.func_77946_l();
    }

    @Nullable
    public EntityRayTraceResult func_213866_a(@Nonnull Vec3d startVec, @Nonnull Vec3d endVec) {
        return this.dealtDamage ? null : super.func_213866_a(startVec, endVec);
    }

    public void func_213868_a(EntityRayTraceResult rayTraceResult) {
        BlockPos blockpos;
        Entity entity1;
        Entity entity = rayTraceResult.func_216348_a();
        float f = ((SpearItem)this.thrownStack.func_77973_b()).getAttackDamage();
        if (entity instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity;
            f += EnchantmentHelper.func_152377_a((ItemStack)this.thrownStack, (CreatureAttribute)livingentity.func_70668_bt());
        }
        DamageSource damagesource = DamageSource.func_203096_a((Entity)this, (Entity)((entity1 = this.func_212360_k()) == null ? this : entity1));
        this.dealtDamage = true;
        SoundEvent soundevent = SoundEvents.field_203268_ij;
        if (entity.func_70097_a(damagesource, f) && entity instanceof LivingEntity) {
            LivingEntity livingentity1 = (LivingEntity)entity;
            if (entity1 instanceof LivingEntity) {
                EnchantmentHelper.func_151384_a((LivingEntity)livingentity1, (Entity)entity1);
                EnchantmentHelper.func_151385_b((LivingEntity)((LivingEntity)entity1), (Entity)livingentity1);
            }
            this.func_184548_a(livingentity1);
        }
        this.func_213317_d(this.func_213322_ci().func_216372_d(-0.01, -0.1, -0.01));
        float f1 = 1.0f;
        if (this.field_70170_p instanceof ServerWorld && this.field_70170_p.func_72911_I() && EnchantmentHelper.func_203192_h((ItemStack)this.thrownStack) && this.field_70170_p.func_226660_f_(blockpos = entity.func_180425_c())) {
            LightningBoltEntity lvt_9_1_ = new LightningBoltEntity(this.field_70170_p, (double)blockpos.func_177958_n() + 0.5, (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p() + 0.5, false);
            lvt_9_1_.func_204809_d(entity1 instanceof ServerPlayerEntity ? (ServerPlayerEntity)entity1 : null);
            ((ServerWorld)this.field_70170_p).func_217468_a(lvt_9_1_);
            soundevent = SoundEvents.field_203275_iq;
            f1 = 5.0f;
        }
        this.func_184185_a(soundevent, f1, 1.0f);
    }

    @Nonnull
    public SoundEvent func_213867_k() {
        return SoundEvents.field_203269_ik;
    }

    public void func_70100_b_(@Nonnull PlayerEntity entityIn) {
        Entity entity = this.func_212360_k();
        if (entity == null || entity.func_110124_au() == entityIn.func_110124_au()) {
            super.func_70100_b_(entityIn);
        }
    }

    public void func_70037_a(@Nonnull CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("Trident", 10)) {
            this.thrownStack = ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("Trident"));
        }
        this.dealtDamage = compound.func_74767_n("DealtDamage");
        this.field_70180_af.func_187227_b(LOYALTY_LEVEL, (Object)((byte)EnchantmentHelper.func_203191_f((ItemStack)this.thrownStack)));
    }

    public void func_213281_b(@Nonnull CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_218657_a("Trident", (INBT)this.thrownStack.func_77955_b(new CompoundNBT()));
        compound.func_74757_a("DealtDamage", this.dealtDamage);
    }

    public void func_70623_bb() {
        byte i = (Byte)this.field_70180_af.func_187225_a(LOYALTY_LEVEL);
        if (this.field_70251_a != AbstractArrowEntity.PickupStatus.ALLOWED || i <= 0) {
            super.func_70623_bb();
        }
    }

    public float func_203044_p() {
        return 0.99f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_145770_h(double x, double y, double z) {
        return true;
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    private boolean shouldReturnToThrower() {
        Entity entity = this.func_212360_k();
        if (entity != null && entity.func_70089_S()) {
            return !(entity instanceof ServerPlayerEntity) || !entity.func_175149_v();
        }
        return false;
    }
}

