/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.age.stone.handlers;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import com.yanny.ages.api.utils.Tags;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.AlternativesLootEntry;
import net.minecraft.world.storage.loot.ItemLootEntry;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.ParentedLootEntry;
import net.minecraft.world.storage.loot.StandaloneLootEntry;
import net.minecraft.world.storage.loot.TableLootEntry;
import net.minecraft.world.storage.loot.conditions.ILootCondition;
import net.minecraft.world.storage.loot.conditions.MatchTool;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="stone_age", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class LootHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<String, Pair<String, Item>> REMOVE_LOOT = Maps.newHashMap();
    private static final Map<String, String> INJECT_POOL = Maps.newHashMap();
    private static final Map<String, Pair<Block, Tag<Item>>> INJECT_ITEM_POOL = Maps.newHashMap();
    private static final Map<String, Pair<Block, Tag<Item>>> INJECT_ALTERNATE_ENTRIES = Maps.newHashMap();
    private static final Map<String, Pair<Block, Tag<Item>>> CHANGE_ALTERNATE_ENTRIES = Maps.newHashMap();
    private static final Field lootEntries = ObfuscationReflectionHelper.findField(LootPool.class, (String)"field_186453_a");
    private static final Field entryItem;
    private static final Field alternativeEntries;
    private static final Field alternativeConditions;
    private static final Constructor<AlternativesLootEntry> constructAlternative;

    @SubscribeEvent
    public static void lootLoad(LootTableLoadEvent event) {
        String name = event.getName().toString();
        if (REMOVE_LOOT.containsKey(name)) {
            LootHandler.removeLootFromTable(event.getTable(), REMOVE_LOOT.get(name));
        }
        if (INJECT_POOL.containsKey(name)) {
            event.getTable().addPool(LootHandler.getInjectPool(INJECT_POOL.get(name)));
        }
        if (INJECT_ITEM_POOL.containsKey(name)) {
            LootHandler.injectItemPool(event.getTable(), INJECT_ITEM_POOL.get(name));
        }
        if (INJECT_ALTERNATE_ENTRIES.containsKey(name)) {
            LootHandler.injectMainAlternativeEntries(event.getTable(), INJECT_ALTERNATE_ENTRIES.get(name));
        }
        if (CHANGE_ALTERNATE_ENTRIES.containsKey(name)) {
            LootHandler.changeToMainAlternativeEntries(event.getTable(), CHANGE_ALTERNATE_ENTRIES.get(name));
        }
    }

    @Nonnull
    private static LootPool getInjectPool(@Nonnull String entryName) {
        return LootPool.func_216096_a().func_216045_a(LootHandler.getInjectEntry(entryName)).bonusRolls(0.0f, 1.0f).name("stone_age:inject").func_216044_b();
    }

    @Nonnull
    private static LootEntry.Builder<?> getInjectEntry(@Nonnull String name) {
        ResourceLocation table = new ResourceLocation(name);
        return TableLootEntry.func_216171_a((ResourceLocation)table).func_216086_a(1);
    }

    private static void injectItemPool(@Nonnull LootTable table, @Nonnull Pair<Block, Tag<Item>> data) {
        ItemPredicate.Builder predicate = ItemPredicate.Builder.func_200309_a().func_200307_a((Tag)data.getSecond());
        StandaloneLootEntry.Builder itemLootEntry = ((StandaloneLootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)data.getFirst())).func_212840_b_(MatchTool.func_216012_a((ItemPredicate.Builder)predicate))).func_216086_a(1);
        LootPool.Builder pool = LootPool.func_216096_a().func_216045_a((LootEntry.Builder)itemLootEntry).bonusRolls(0.0f, 1.0f).name("stone_age:inject");
        table.addPool(pool.func_216044_b());
    }

    private static void injectMainAlternativeEntries(@Nonnull LootTable table, @Nonnull Pair<Block, Tag<Item>> data) {
        try {
            LootPool pool = table.getPool("main");
            if (pool != null) {
                List entries = (List)lootEntries.get(pool);
                if (entries != null && entries.size() > 0 && entries.get(0) instanceof AlternativesLootEntry) {
                    ItemPredicate.Builder predicate = ItemPredicate.Builder.func_200309_a().func_200307_a((Tag)data.getSecond());
                    LootEntry itemLootEntry = ((StandaloneLootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)data.getFirst())).func_212840_b_(MatchTool.func_216012_a((ItemPredicate.Builder)predicate))).func_216081_b();
                    LootEntry[] aEntries = (LootEntry[])alternativeEntries.get(entries.get(0));
                    ILootCondition[] aConditions = (ILootCondition[])alternativeConditions.get(entries.get(0));
                    if (aEntries != null && aConditions != null) {
                        ArrayList list = Lists.newArrayList((Object[])new LootEntry[]{itemLootEntry});
                        list.addAll(Arrays.asList(aEntries));
                        AlternativesLootEntry newAlternative = constructAlternative.newInstance(list.toArray(new LootEntry[0]), aConditions);
                        entries.set(0, newAlternative);
                    } else {
                        LOGGER.warn("Fields not available! {}", (Object)data.toString());
                    }
                } else {
                    LOGGER.warn("Alternatives not available! {}", (Object)data.toString());
                }
            } else {
                LOGGER.warn("Main pool not available! {}", (Object)data.toString());
            }
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private static void changeToMainAlternativeEntries(@Nonnull LootTable table, @Nonnull Pair<Block, Tag<Item>> data) {
        try {
            LootPool pool = table.getPool("main");
            if (pool != null) {
                List entries = (List)lootEntries.get(pool);
                if (entries != null && entries.size() > 0) {
                    ItemPredicate.Builder predicate = ItemPredicate.Builder.func_200309_a().func_200307_a((Tag)data.getSecond());
                    LootEntry.Builder itemLootEntry = ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)data.getFirst())).func_212840_b_(MatchTool.func_216012_a((ItemPredicate.Builder)predicate));
                    ArrayList list = Lists.newArrayList((Object[])new LootEntry[]{itemLootEntry.func_216081_b()});
                    list.addAll(entries);
                    AlternativesLootEntry a = constructAlternative.newInstance(list.toArray(new LootEntry[0]), new ILootCondition[0]);
                    entries.set(0, a);
                } else {
                    LOGGER.warn("Alternatives not available! {}", (Object)data.toString());
                }
            } else {
                LOGGER.warn("Main pool not available! {}", (Object)data.toString());
            }
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static void removeLootFromTable(@Nonnull LootTable table, @Nonnull Pair<String, Item> data) {
        try {
            LootPool pool = table.getPool((String)data.getFirst());
            List entries = (List)lootEntries.get(pool);
            Iterator it = entries.iterator();
            while (it.hasNext()) {
                ItemLootEntry lootEntry;
                Item i;
                LootEntry entry = (LootEntry)it.next();
                if (!(entry instanceof ItemLootEntry) || (i = (Item)entryItem.get(lootEntry = (ItemLootEntry)entry)) != data.getSecond()) continue;
                it.remove();
                return;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    static {
        lootEntries.setAccessible(true);
        alternativeEntries = ObfuscationReflectionHelper.findField(ParentedLootEntry.class, (String)"field_216147_c");
        alternativeEntries.setAccessible(true);
        alternativeConditions = ObfuscationReflectionHelper.findField(LootEntry.class, (String)"field_216144_d");
        alternativeConditions.setAccessible(true);
        constructAlternative = ObfuscationReflectionHelper.findConstructor(AlternativesLootEntry.class, (Class[])new Class[]{LootEntry[].class, ILootCondition[].class});
        constructAlternative.setAccessible(true);
        entryItem = ObfuscationReflectionHelper.findField(ItemLootEntry.class, (String)"field_186368_a");
        entryItem.setAccessible(true);
        REMOVE_LOOT.put("minecraft:entities/horse", (Pair<String, Item>)new Pair((Object)"main", (Object)Items.field_151116_aA));
        REMOVE_LOOT.put("minecraft:entities/cow", (Pair<String, Item>)new Pair((Object)"main", (Object)Items.field_151116_aA));
        REMOVE_LOOT.put("minecraft:entities/donkey", (Pair<String, Item>)new Pair((Object)"main", (Object)Items.field_151116_aA));
        REMOVE_LOOT.put("minecraft:entities/llama", (Pair<String, Item>)new Pair((Object)"main", (Object)Items.field_151116_aA));
        REMOVE_LOOT.put("minecraft:entities/mooshroom", (Pair<String, Item>)new Pair((Object)"main", (Object)Items.field_151116_aA));
        REMOVE_LOOT.put("minecraft:entities/trader_llama", (Pair<String, Item>)new Pair((Object)"main", (Object)Items.field_151116_aA));
        INJECT_POOL.put("minecraft:blocks/dirt", "stone_age:inject/blocks/bones_and_sticks");
        INJECT_POOL.put("minecraft:blocks/coarse_dirt", "stone_age:inject/blocks/bones_and_sticks");
        INJECT_POOL.put("minecraft:blocks/gravel", "stone_age:inject/blocks/bones_and_sticks");
        INJECT_POOL.put("minecraft:blocks/sand", "stone_age:inject/blocks/bones_and_sticks");
        INJECT_POOL.put("minecraft:blocks/red_sand", "stone_age:inject/blocks/bones_and_sticks");
        INJECT_POOL.put("minecraft:blocks/grass_block", "stone_age:inject/blocks/saplings");
        INJECT_POOL.put("minecraft:entities/cod", "stone_age:inject/entities/fish_bone");
        INJECT_POOL.put("minecraft:entities/salmon", "stone_age:inject/entities/fish_bone");
        INJECT_POOL.put("minecraft:entities/tropical_fish", "stone_age:inject/entities/fish_bone");
        INJECT_POOL.put("minecraft:entities/dolphin", "stone_age:inject/entities/fish_bone");
        INJECT_POOL.put("minecraft:entities/cow", "stone_age:inject/entities/bone_fat_hide");
        INJECT_POOL.put("minecraft:entities/horse", "stone_age:inject/entities/bone_fat_hide");
        INJECT_POOL.put("minecraft:entities/donkey", "stone_age:inject/entities/bone_fat_hide");
        INJECT_POOL.put("minecraft:entities/llama", "stone_age:inject/entities/bone_fat_hide");
        INJECT_POOL.put("minecraft:entities/mooshroom", "stone_age:inject/entities/bone_fat_hide");
        INJECT_POOL.put("minecraft:entities/trader_llama", "stone_age:inject/entities/bone_fat_hide");
        INJECT_POOL.put("minecraft:entities/pig", "stone_age:inject/entities/bone_fat");
        INJECT_POOL.put("minecraft:entities/sheep", "stone_age:inject/entities/bone_fat");
        INJECT_ITEM_POOL.put("minecraft:blocks/seagrass", (Pair<Block, Tag<Item>>)new Pair((Object)Blocks.field_203198_aQ, (Object)Tags.Items.SHEARS));
        INJECT_ITEM_POOL.put("minecraft:blocks/tall_seagrass", (Pair<Block, Tag<Item>>)new Pair((Object)Blocks.field_203198_aQ, (Object)Tags.Items.SHEARS));
        INJECT_ITEM_POOL.put("minecraft:blocks/vine", (Pair<Block, Tag<Item>>)new Pair((Object)Blocks.field_150395_bd, (Object)Tags.Items.SHEARS));
        INJECT_ALTERNATE_ENTRIES.put("minecraft:blocks/stone", (Pair<Block, Tag<Item>>)new Pair((Object)Blocks.field_150351_n, (Object)Tags.Items.HAMMERS));
        INJECT_ALTERNATE_ENTRIES.put("minecraft:blocks/acacia_leaves", (Pair<Block, Tag<Item>>)new Pair((Object)Blocks.field_196572_aa, (Object)Tags.Items.SHEARS));
        INJECT_ALTERNATE_ENTRIES.put("minecraft:blocks/birch_leaves", (Pair<Block, Tag<Item>>)new Pair((Object)Blocks.field_196647_Y, (Object)Tags.Items.SHEARS));
        INJECT_ALTERNATE_ENTRIES.put("minecraft:blocks/cobweb", (Pair<Block, Tag<Item>>)new Pair((Object)Blocks.field_196553_aF, (Object)Tags.Items.SHEARS));
        INJECT_ALTERNATE_ENTRIES.put("minecraft:blocks/dark_oak_leaves", (Pair<Block, Tag<Item>>)new Pair((Object)Blocks.field_196574_ab, (Object)Tags.Items.SHEARS));
        INJECT_ALTERNATE_ENTRIES.put("minecraft:blocks/dead_bush", (Pair<Block, Tag<Item>>)new Pair((Object)Blocks.field_196555_aI, (Object)Tags.Items.SHEARS));
        INJECT_ALTERNATE_ENTRIES.put("minecraft:blocks/fern", (Pair<Block, Tag<Item>>)new Pair((Object)Blocks.field_196554_aH, (Object)Tags.Items.SHEARS));
        INJECT_ALTERNATE_ENTRIES.put("minecraft:blocks/grass", (Pair<Block, Tag<Item>>)new Pair((Object)Blocks.field_150349_c, (Object)Tags.Items.SHEARS));
        INJECT_ALTERNATE_ENTRIES.put("minecraft:blocks/jungle_leaves", (Pair<Block, Tag<Item>>)new Pair((Object)Blocks.field_196648_Z, (Object)Tags.Items.SHEARS));
        INJECT_ALTERNATE_ENTRIES.put("minecraft:blocks/large_fern", (Pair<Block, Tag<Item>>)new Pair((Object)Blocks.field_196554_aH, (Object)Tags.Items.SHEARS));
        INJECT_ALTERNATE_ENTRIES.put("minecraft:blocks/oak_leaves", (Pair<Block, Tag<Item>>)new Pair((Object)Blocks.field_196642_W, (Object)Tags.Items.SHEARS));
        INJECT_ALTERNATE_ENTRIES.put("minecraft:blocks/spruce_leaves", (Pair<Block, Tag<Item>>)new Pair((Object)Blocks.field_196645_X, (Object)Tags.Items.SHEARS));
        INJECT_ALTERNATE_ENTRIES.put("minecraft:blocks/tall_grass", (Pair<Block, Tag<Item>>)new Pair((Object)Blocks.field_150349_c, (Object)Tags.Items.SHEARS));
        CHANGE_ALTERNATE_ENTRIES.put("minecraft:blocks/sandstone", (Pair<Block, Tag<Item>>)new Pair((Object)Blocks.field_150354_m, (Object)Tags.Items.HAMMERS));
        CHANGE_ALTERNATE_ENTRIES.put("minecraft:blocks/chiseled_sandstone", (Pair<Block, Tag<Item>>)new Pair((Object)Blocks.field_150354_m, (Object)Tags.Items.HAMMERS));
        CHANGE_ALTERNATE_ENTRIES.put("minecraft:blocks/cut_sandstone", (Pair<Block, Tag<Item>>)new Pair((Object)Blocks.field_150354_m, (Object)Tags.Items.HAMMERS));
        CHANGE_ALTERNATE_ENTRIES.put("minecraft:blocks/smooth_sandstone", (Pair<Block, Tag<Item>>)new Pair((Object)Blocks.field_150354_m, (Object)Tags.Items.HAMMERS));
        CHANGE_ALTERNATE_ENTRIES.put("minecraft:blocks/red_sandstone", (Pair<Block, Tag<Item>>)new Pair((Object)Blocks.field_196611_F, (Object)Tags.Items.HAMMERS));
        CHANGE_ALTERNATE_ENTRIES.put("minecraft:blocks/chiseled_red_sandstone", (Pair<Block, Tag<Item>>)new Pair((Object)Blocks.field_196611_F, (Object)Tags.Items.HAMMERS));
        CHANGE_ALTERNATE_ENTRIES.put("minecraft:blocks/cut_red_sandstone", (Pair<Block, Tag<Item>>)new Pair((Object)Blocks.field_196611_F, (Object)Tags.Items.HAMMERS));
        CHANGE_ALTERNATE_ENTRIES.put("minecraft:blocks/smooth_red_sandstone", (Pair<Block, Tag<Item>>)new Pair((Object)Blocks.field_196611_F, (Object)Tags.Items.HAMMERS));
    }
}

