/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.age.stone.items;

import com.google.common.collect.Multimap;
import com.yanny.age.stone.entities.FlintSpearEntity;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SpearItem
extends Item {
    private final float attackDamage;
    private final float attackSpeed;

    public SpearItem(@Nonnull IItemTier tier, float attackDamageIn, float attackSpeedIn, @Nonnull Item.Properties builder) {
        super(builder);
        this.func_185043_a(new ResourceLocation("throwing"), (itemStack, world, livingEntity) -> livingEntity != null && livingEntity.func_184587_cr() && livingEntity.func_184607_cu() == itemStack ? 1.0f : 0.0f);
        this.attackDamage = attackDamageIn + tier.func_200929_c();
        this.attackSpeed = attackSpeedIn;
    }

    public boolean func_195938_a(@Nonnull BlockState state, @Nonnull World worldIn, @Nonnull BlockPos pos, PlayerEntity player) {
        return !player.func_184812_l_();
    }

    @Nonnull
    public UseAction func_77661_b(@Nonnull ItemStack stack) {
        return UseAction.SPEAR;
    }

    public int func_77626_a(@Nonnull ItemStack stack) {
        return 72000;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_77636_d(@Nonnull ItemStack stack) {
        return false;
    }

    public void func_77615_a(@Nonnull ItemStack stack, @Nonnull World worldIn, @Nonnull LivingEntity entityLiving, int timeLeft) {
        if (entityLiving instanceof PlayerEntity) {
            int j;
            PlayerEntity playerentity = (PlayerEntity)entityLiving;
            int i = this.func_77626_a(stack) - timeLeft;
            if (i >= 10 && ((j = EnchantmentHelper.func_203190_g((ItemStack)stack)) <= 0 || playerentity.func_70026_G())) {
                if (!worldIn.field_72995_K) {
                    stack.func_222118_a(1, (LivingEntity)playerentity, entity -> entity.func_213334_d(entityLiving.func_184600_cs()));
                    if (j == 0) {
                        FlintSpearEntity spearEntity = new FlintSpearEntity(worldIn, (LivingEntity)playerentity, stack);
                        spearEntity.func_184547_a((Entity)playerentity, playerentity.field_70125_A, playerentity.field_70177_z, 0.0f, 2.5f + (float)j * 0.5f, 1.0f);
                        if (playerentity.field_71075_bZ.field_75098_d) {
                            spearEntity.field_70251_a = AbstractArrowEntity.PickupStatus.CREATIVE_ONLY;
                        }
                        worldIn.func_217376_c((Entity)spearEntity);
                        worldIn.func_217384_a(null, (Entity)spearEntity, SoundEvents.field_203274_ip, SoundCategory.PLAYERS, 1.0f, 1.0f);
                        if (!playerentity.field_71075_bZ.field_75098_d) {
                            playerentity.field_71071_by.func_184437_d(stack);
                        }
                    }
                }
                playerentity.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
                if (j > 0) {
                    float f7 = playerentity.field_70177_z;
                    float f = playerentity.field_70125_A;
                    float f1 = -MathHelper.func_76126_a((float)(f7 * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(f * ((float)Math.PI / 180)));
                    float f2 = -MathHelper.func_76126_a((float)(f * ((float)Math.PI / 180)));
                    float f3 = MathHelper.func_76134_b((float)(f7 * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(f * ((float)Math.PI / 180)));
                    float f4 = MathHelper.func_76129_c((float)(f1 * f1 + f2 * f2 + f3 * f3));
                    float f5 = 3.0f * ((1.0f + (float)j) / 4.0f);
                    playerentity.func_70024_g((double)(f1 *= f5 / f4), (double)(f2 *= f5 / f4), (double)(f3 *= f5 / f4));
                    playerentity.func_204803_n(20);
                    if (playerentity.field_70122_E) {
                        playerentity.func_213315_a(MoverType.SELF, new Vec3d(0.0, 1.1999999284744263, 0.0));
                    }
                    SoundEvent soundevent = j >= 3 ? SoundEvents.field_203273_io : (j == 2 ? SoundEvents.field_203272_in : SoundEvents.field_203271_im);
                    worldIn.func_217384_a(null, (Entity)playerentity, soundevent, SoundCategory.PLAYERS, 1.0f, 1.0f);
                }
            }
        }
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World worldIn, PlayerEntity playerIn, @Nonnull Hand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        if (itemstack.func_77952_i() >= itemstack.func_77958_k()) {
            return new ActionResult(ActionResultType.FAIL, (Object)itemstack);
        }
        if (EnchantmentHelper.func_203190_g((ItemStack)itemstack) > 0 && !playerIn.func_70026_G()) {
            return new ActionResult(ActionResultType.FAIL, (Object)itemstack);
        }
        playerIn.func_184598_c(handIn);
        return new ActionResult(ActionResultType.SUCCESS, (Object)itemstack);
    }

    public boolean func_77644_a(ItemStack stack, @Nonnull LivingEntity target, @Nonnull LivingEntity attacker) {
        stack.func_222118_a(1, attacker, entity -> entity.func_213361_c(EquipmentSlotType.MAINHAND));
        return true;
    }

    public boolean func_179218_a(@Nonnull ItemStack stack, @Nonnull World worldIn, BlockState state, @Nonnull BlockPos pos, @Nonnull LivingEntity entityLiving) {
        if ((double)state.func_185887_b((IBlockReader)worldIn, pos) != 0.0) {
            stack.func_222118_a(2, entityLiving, entity -> entity.func_213361_c(EquipmentSlotType.MAINHAND));
        }
        return true;
    }

    @Nonnull
    public Multimap<String, AttributeModifier> func_111205_h(@Nonnull EquipmentSlotType equipmentSlot) {
        Multimap multimap = super.func_111205_h(equipmentSlot);
        if (equipmentSlot == EquipmentSlotType.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Tool modifier", (double)this.attackDamage, AttributeModifier.Operation.ADDITION));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Tool modifier", (double)this.attackSpeed, AttributeModifier.Operation.ADDITION));
        }
        return multimap;
    }

    public int func_77619_b() {
        return 1;
    }

    public float getAttackDamage() {
        return this.attackDamage;
    }
}

