/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.age.stone.modifiers;

import com.google.gson.JsonObject;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraft.world.storage.loot.conditions.ILootCondition;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;

public class LeavesDropModifier
extends LootModifier {
    private final float chance;

    private LeavesDropModifier(ILootCondition[] conditionsIn, float chance) {
        super(conditionsIn);
        this.chance = chance;
    }

    @Nonnull
    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        ItemStack ctxTool = (ItemStack)context.func_216031_c(LootParameters.field_216289_i);
        float chanceAfterLooting = this.chance;
        if (ctxTool != null) {
            if (EnchantmentHelper.func_82781_a((ItemStack)ctxTool).containsKey(Enchantments.field_185306_r)) {
                return generatedLoot;
            }
            if (EnchantmentHelper.func_82781_a((ItemStack)ctxTool).containsKey(Enchantments.field_185304_p)) {
                int enchantmentLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185304_p, (ItemStack)ctxTool);
                chanceAfterLooting *= (float)enchantmentLevel;
            }
        }
        if (Math.random() < (double)chanceAfterLooting) {
            generatedLoot.add(new ItemStack((IItemProvider)Items.field_151055_y, Math.max(1, Math.round(chanceAfterLooting))));
        }
        return generatedLoot;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<LeavesDropModifier> {
        public LeavesDropModifier read(ResourceLocation location, JsonObject object, ILootCondition[] conditions) {
            float chance = JSONUtils.func_151217_k((JsonObject)object, (String)"chance");
            return new LeavesDropModifier(conditions, chance);
        }
    }
}

