/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.age.stone.subscribers;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.yanny.age.stone.config.Config;
import com.yanny.age.stone.entities.SaberToothTigerEntity;
import com.yanny.age.stone.subscribers.EntitySubscriber;
import com.yanny.age.stone.subscribers.FeatureSubscriber;
import com.yanny.age.stone.subscribers.ItemSubscriber;
import com.yanny.ages.api.enums.Age;
import com.yanny.ages.api.utils.AgeUtils;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.advancements.AdvancementList;
import net.minecraft.advancements.AdvancementManager;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.ChickenEntity;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.AxeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.ProbabilityConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.AdvancementEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="stone_age", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ForgeEventSubscriber {
    private static final String PLAYER_MANUAL_NBT = "stone_age_manual";
    private static final Set<ResourceLocation> RECIPES_TO_REMOVE = Sets.newHashSet((Object[])new ResourceLocation[]{new ResourceLocation("minecraft", "wooden_axe"), new ResourceLocation("minecraft", "wooden_pickaxe"), new ResourceLocation("minecraft", "wooden_hoe"), new ResourceLocation("minecraft", "wooden_shovel"), new ResourceLocation("minecraft", "wooden_sword"), new ResourceLocation("minecraft", "stone_axe"), new ResourceLocation("minecraft", "stone_pickaxe"), new ResourceLocation("minecraft", "stone_hoe"), new ResourceLocation("minecraft", "stone_shovel"), new ResourceLocation("minecraft", "stone_sword")});
    private static final Set<ResourceLocation> ADVANCEMENTS_TO_REMOVE = Sets.newHashSet((Object[])new ResourceLocation[]{new ResourceLocation("minecraft", "recipes/tools/wooden_axe"), new ResourceLocation("minecraft", "recipes/tools/wooden_pickaxe"), new ResourceLocation("minecraft", "recipes/tools/wooden_hoe"), new ResourceLocation("minecraft", "recipes/tools/wooden_shovel"), new ResourceLocation("minecraft", "recipes/combat/wooden_sword"), new ResourceLocation("minecraft", "recipes/tools/stone_axe"), new ResourceLocation("minecraft", "recipes/tools/stone_pickaxe"), new ResourceLocation("minecraft", "recipes/tools/stone_hoe"), new ResourceLocation("minecraft", "recipes/tools/stone_shovel"), new ResourceLocation("minecraft", "recipes/combat/stone_sword")});

    @SubscribeEvent
    public static void FMLServerStartingEvent(@Nonnull FMLServerStartingEvent event) {
        if (Config.removeVanillaRecipes) {
            RecipeManager recipeManager = event.getServer().func_199529_aN();
            Class<?> recipeManagerClass = recipeManager.getClass();
            try {
                Field recipes = recipeManagerClass.getDeclaredFields()[2];
                recipes.setAccessible(true);
                Map recipesMap = (Map)recipes.get(recipeManager);
                HashMap map = Maps.newHashMap();
                recipesMap.forEach((iRecipeType, resourceLocationIRecipeMap) -> {
                    Map map1 = map.computeIfAbsent(iRecipeType, recipeType -> Maps.newHashMap());
                    resourceLocationIRecipeMap.forEach(map1::put);
                    RECIPES_TO_REMOVE.forEach(map1::remove);
                });
                recipes.set(recipeManager, ImmutableMap.copyOf((Map)map));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            AdvancementManager advancementManager = event.getServer().func_191949_aK();
            Class<?> advancementManagerClass = advancementManager.getClass();
            Field advancements = advancementManagerClass.getDeclaredFields()[2];
            advancements.setAccessible(true);
            try {
                AdvancementList advancementList = (AdvancementList)advancements.get(advancementManager);
                Class<?> list = advancementList.getClass();
                Field listField = list.getDeclaredFields()[1];
                listField.setAccessible(true);
                Map map = (Map)listField.get(advancementList);
                ADVANCEMENTS_TO_REMOVE.forEach(map::remove);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        if (Config.forceToolForWood) {
            ForgeEventSubscriber.setUseToolForWood();
        }
    }

    @SubscribeEvent
    public static void entitySpawnEvent(@Nonnull EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof SheepEntity) {
            SheepEntity sheepEntity = (SheepEntity)entity;
            sheepEntity.field_70714_bg.func_75776_a(4, (Goal)new AvoidEntityGoal((CreatureEntity)sheepEntity, SaberToothTigerEntity.class, 14.0f, 1.5, 2.2));
        }
        if (entity instanceof ChickenEntity) {
            ChickenEntity chickenEntity = (ChickenEntity)entity;
            chickenEntity.field_70714_bg.func_75776_a(4, (Goal)new AvoidEntityGoal((CreatureEntity)chickenEntity, SaberToothTigerEntity.class, 14.0f, 1.5, 2.2));
        }
    }

    @SubscribeEvent
    public static void rightClickBlockEvent(@Nonnull PlayerInteractEvent.RightClickBlock event) {
        BlockPos blockPos = event.getPos();
        BlockState blockState = event.getWorld().func_180495_p(blockPos);
        if (Config.disableVanillaCraftingTable && AgeUtils.getPlayerAge((PlayerEntity)event.getPlayer()) <= Age.STONE_AGE.value && Config.disabledUseInStoneAgeList.contains(blockState.func_177230_c())) {
            event.setUseBlock(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public static void advancementEvent(@Nonnull AdvancementEvent event) {
        if (event.getAdvancement().func_192067_g().equals((Object)new ResourceLocation("stone_age", "stone_age/end_of_stone_age")) && AgeUtils.getPlayerAge((PlayerEntity)event.getPlayer()) <= Age.STONE_AGE.value) {
            AgeUtils.setPlayerAge((PlayerEntity)event.getPlayer(), (Age)Age.BRONZE_AGE);
        }
    }

    @SubscribeEvent
    public static void litTorch(@Nonnull PlayerInteractEvent.RightClickBlock event) {
        PlayerEntity player = event.getPlayer();
        if (event.getHand() == Hand.MAIN_HAND && player.func_184614_ca().func_77973_b().equals(ItemSubscriber.unlit_torch)) {
            World world = event.getWorld();
            BlockPos pos = event.getPos();
            BlockPos facePos = event.getPos().func_177972_a(event.getFace());
            BlockState blockState = world.func_180495_p(pos);
            BlockState faceBlockState = world.func_180495_p(facePos);
            if (blockState.func_177230_c().equals(Blocks.field_222433_lV) || faceBlockState.func_177230_c().equals(Blocks.field_150480_ab) || blockState.func_177230_c().equals(Blocks.field_150478_aa)) {
                player.func_184611_a(Hand.MAIN_HAND, new ItemStack((IItemProvider)Items.field_221657_bQ, player.func_184614_ca().func_190916_E()));
                event.setUseItem(Event.Result.DENY);
            }
        }
    }

    @SubscribeEvent
    public static void disableInfinityWaterSource(@Nonnull BlockEvent.CreateFluidSourceEvent event) {
        Biome biome = event.getWorld().func_226691_t_(event.getPos());
        if (Config.aqueductRemoveWaterSource && !Config.infinityWaterSourceBiomeList.contains(biome)) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public static void makeFireWithSticksAndDriedGrass(@Nonnull PlayerInteractEvent.RightClickBlock event) {
        PlayerEntity player = event.getPlayer();
        ItemStack mainItem = player.func_184614_ca();
        ItemStack offItem = player.func_184592_cb();
        if (mainItem.func_77973_b() == Items.field_151055_y && offItem.func_77973_b() == Items.field_151055_y && event.getFace() != null) {
            World world = event.getWorld();
            BlockPos position = event.getPos().func_177972_a(event.getFace());
            BlockState blockState = world.func_180495_p(position);
            List driedGrassList = world.func_175647_a(ItemEntity.class, new AxisAlignedBB(position), itemEntity -> itemEntity.func_92059_d().func_77973_b().equals(ItemSubscriber.dried_grass));
            if (blockState.isAir((IBlockReader)world, position) && !driedGrassList.isEmpty()) {
                world.func_180501_a(position, Blocks.field_150480_ab.func_176223_P(), 11);
                player.func_213334_d(Hand.MAIN_HAND);
                player.func_213334_d(Hand.OFF_HAND);
                if (mainItem.func_190916_E() > 1) {
                    mainItem.func_190920_e(mainItem.func_190916_E() - 1);
                } else {
                    player.func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
                }
                if (offItem.func_190916_E() > 1) {
                    offItem.func_190920_e(offItem.func_190916_E() - 1);
                } else {
                    player.func_184611_a(Hand.OFF_HAND, ItemStack.field_190927_a);
                }
                driedGrassList.forEach(Entity::func_70106_y);
            }
        }
    }

    @SubscribeEvent
    public static void serverAboutToStartEvent(@Nonnull FMLServerAboutToStartEvent event) {
        for (Biome biome : ForgeRegistries.BIOMES) {
            if (Config.spawnDeerEnable && !Config.spawnDeerAllowedBiomesBlacklist == Config.spawnDeerAllowedBiomes.contains(biome)) {
                biome.func_76747_a(EntitySubscriber.deer.func_220339_d()).add(new Biome.SpawnListEntry(EntitySubscriber.deer, Config.spawnDeerWeight, Config.spawnDeerMinCount, Config.spawnDeerMaxCount));
            }
            if (Config.spawnBoarEnable && !Config.spawnBoarAllowedBiomesBlacklist == Config.spawnBoarAllowedBiomes.contains(biome)) {
                biome.func_76747_a(EntitySubscriber.boar.func_220339_d()).add(new Biome.SpawnListEntry(EntitySubscriber.boar, Config.spawnBoarWeight, Config.spawnBoarMinCount, Config.spawnBoarMaxCount));
            }
            if (Config.spawnAurochEnable && !Config.spawnAurochAllowedBiomesBlacklist == Config.spawnAurochAllowedBiomes.contains(biome)) {
                biome.func_76747_a(EntitySubscriber.auroch.func_220339_d()).add(new Biome.SpawnListEntry(EntitySubscriber.auroch, Config.spawnAurochWeight, Config.spawnAurochMinCount, Config.spawnAurochMaxCount));
            }
            if (Config.spawnFowlEnable && !Config.spawnFowlAllowedBiomesBlacklist == Config.spawnFowlAllowedBiomes.contains(biome)) {
                biome.func_76747_a(EntitySubscriber.fowl.func_220339_d()).add(new Biome.SpawnListEntry(EntitySubscriber.fowl, Config.spawnFowlWeight, Config.spawnFowlMinCount, Config.spawnFowlMaxCount));
            }
            if (Config.spawnMouflonEnable && !Config.spawnMouflonAllowedBiomesBlacklist == Config.spawnMouflonAllowedBiomes.contains(biome)) {
                biome.func_76747_a(EntitySubscriber.mouflon.func_220339_d()).add(new Biome.SpawnListEntry(EntitySubscriber.mouflon, Config.spawnMouflonWeight, Config.spawnMouflonMinCount, Config.spawnMouflonMaxCount));
            }
            if (Config.spawnMammothEnable && !Config.spawnMammothAllowedBiomesBlacklist == Config.spawnMammothAllowedBiomes.contains(biome)) {
                biome.func_76747_a(EntitySubscriber.mammoth.func_220339_d()).add(new Biome.SpawnListEntry(EntitySubscriber.mammoth, Config.spawnMammothWeight, Config.spawnMammothMinCount, Config.spawnMammothMaxCount));
            }
            if (Config.spawnSaberToothTigerEnable && !Config.spawnSaberToothTigerAllowedBiomesBlacklist == Config.spawnSaberToothTigerAllowedBiomes.contains(biome)) {
                biome.func_76747_a(EntitySubscriber.saber_tooth_tiger.func_220339_d()).add(new Biome.SpawnListEntry(EntitySubscriber.saber_tooth_tiger, Config.spawnSaberToothTigerWeight, Config.spawnSaberToothTigerMinCount, Config.spawnSaberToothTigerMaxCount));
            }
            if (Config.spawnWoollyRhinoEnable && !Config.spawnWoollyRhinoAllowedBiomesBlacklist == Config.spawnWoollyRhinoAllowedBiomes.contains(biome)) {
                biome.func_76747_a(EntitySubscriber.woolly_rhino.func_220339_d()).add(new Biome.SpawnListEntry(EntitySubscriber.woolly_rhino, Config.spawnWoollyRhinoWeight, Config.spawnWoollyRhinoMinCount, Config.spawnWoollyRhinoMaxCount));
            }
            if (Config.spawnTerrorBirdEnable && !Config.spawnTerrorBirdAllowedBiomesBlacklist == Config.spawnTerrorBirdAllowedBiomes.contains(biome)) {
                biome.func_76747_a(EntitySubscriber.terror_bird.func_220339_d()).add(new Biome.SpawnListEntry(EntitySubscriber.terror_bird, Config.spawnTerrorBirdWeight, Config.spawnTerrorBirdMinCount, Config.spawnTerrorBirdMaxCount));
            }
            if (Config.spawnCoelacanthEnable && !Config.spawnCoelacanthAllowedBiomesBlacklist == Config.spawnCoelacanthAllowedBiomes.contains(biome)) {
                biome.func_76747_a(EntitySubscriber.coelacanth.func_220339_d()).add(new Biome.SpawnListEntry(EntitySubscriber.coelacanth, Config.spawnCoelacanthWeight, Config.spawnCoelacanthMinCount, Config.spawnCoelacanthMaxCount));
            }
            if (Config.removeVanillaGeneratedAnimals) {
                biome.func_76747_a(EntityClassification.CREATURE).removeIf(entry -> Sets.newHashSet((Object[])new EntityType[]{EntityType.field_200796_j, EntityType.field_200737_ac, EntityType.field_200784_X, EntityType.field_200795_i}).contains(entry.field_200702_b));
            }
            if (Config.abandonedCampAllowedBiomes.contains(biome)) {
                biome.func_226711_a_(FeatureSubscriber.abandoned_camp_structure.func_225566_b_((IFeatureConfig)new ProbabilityConfig((float)Config.abandonedCampSpawnChance)));
                biome.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, FeatureSubscriber.abandoned_camp_structure.func_225566_b_((IFeatureConfig)new ProbabilityConfig((float)Config.abandonedCampSpawnChance)).func_227228_a_(Placement.field_215022_h.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e)));
            }
            if (!Config.burialPlaceAllowedBiomes.contains(biome)) continue;
            biome.func_226711_a_(FeatureSubscriber.burial_place_structure.func_225566_b_((IFeatureConfig)new ProbabilityConfig((float)Config.burialPlaceSpawnChance)));
            biome.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, FeatureSubscriber.burial_place_structure.func_225566_b_((IFeatureConfig)new ProbabilityConfig((float)Config.burialPlaceSpawnChance)).func_227228_a_(Placement.field_215022_h.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e)));
        }
    }

    @SubscribeEvent
    public static void axeHarvestCheck(@Nonnull PlayerEvent.HarvestCheck event) {
        BlockState state = event.getTargetBlock();
        PlayerEntity entity = event.getPlayer();
        ItemStack stack = entity.func_184586_b(Hand.MAIN_HAND);
        Item item = stack.func_77973_b();
        if (entity.func_184586_b(Hand.MAIN_HAND).func_77973_b() instanceof AxeItem && state.func_185904_a() == Material.field_151575_d && state.func_177230_c().getHarvestLevel(state) <= item.getHarvestLevel(stack, ToolType.AXE, entity, state)) {
            event.setCanHarvest(true);
        }
    }

    @SubscribeEvent
    public static void addManualToPlayer(@Nonnull PlayerEvent.PlayerLoggedInEvent event) {
        CompoundNBT persistent;
        if (!Config.givePlayerManualOnFirstConnect) {
            return;
        }
        CompoundNBT nbt = event.getPlayer().getPersistentData();
        if (!nbt.func_74764_b("PlayerPersisted")) {
            persistent = new CompoundNBT();
            nbt.func_218657_a("PlayerPersisted", (INBT)persistent);
        } else {
            persistent = nbt.func_74775_l("PlayerPersisted");
        }
        if (!persistent.func_74764_b(PLAYER_MANUAL_NBT)) {
            ItemStack book;
            persistent.func_74757_a(PLAYER_MANUAL_NBT, true);
            Item itemBook = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("patchouli", "guide_book"));
            if (itemBook != null && !(book = new ItemStack((IItemProvider)itemBook)).func_190926_b()) {
                book.func_196082_o().func_74778_a("patchouli:book", "stone_age:stone_tablet");
                event.getPlayer().field_71071_by.func_70441_a(book);
            }
        }
    }

    private static void setUseToolForWood() {
        Field field = ObfuscationReflectionHelper.findField(Material.class, (String)"field_76241_J");
        field.setAccessible(true);
        try {
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
            field.setBoolean(Material.field_151575_d, false);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
    }
}

