/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.age.stone.subscribers;

import com.yanny.age.stone.ExampleMod;
import com.yanny.age.stone.compatibility.top.TopCompatibility;
import com.yanny.age.stone.config.ConfigHelper;
import com.yanny.age.stone.config.ConfigHolder;
import com.yanny.age.stone.datagen.AgesApiItemTagGenerator;
import com.yanny.age.stone.datagen.ForgeItemTagGenerator;
import com.yanny.age.stone.datagen.LootTableGenerator;
import com.yanny.age.stone.datagen.RecipeGenerator;
import com.yanny.age.stone.subscribers.BlockSubscriber;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.data.IDataProvider;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;

@Mod.EventBusSubscriber(modid="stone_age", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModEventSubscriber {
    @SubscribeEvent
    public static void init(@Nonnull FMLCommonSetupEvent event) {
        ExampleMod.proxy.init();
    }

    @SubscribeEvent
    public static void registerTOP(@Nonnull InterModEnqueueEvent event) {
        TopCompatibility.register();
    }

    @SubscribeEvent
    public static void onModConfigEvent(@Nonnull ModConfig.ModConfigEvent event) {
        ModConfig config = event.getConfig();
        if (!config.getModId().equals("stone_age")) {
            return;
        }
        if (config.getSpec() == ConfigHolder.CLIENT_SPEC) {
            ConfigHelper.bakeClient();
        } else if (config.getSpec() == ConfigHolder.SERVER_SPEC) {
            ConfigHelper.bakeServer();
        }
    }

    @SubscribeEvent
    public static void onClientSetupEvent(@Nonnull FMLClientSetupEvent event) {
        RenderTypeLookup.setRenderLayer((Block)BlockSubscriber.fishing_net, (RenderType)RenderType.func_228641_d_());
        RenderTypeLookup.setRenderLayer((Block)BlockSubscriber.aqueduct, (RenderType)RenderType.func_228641_d_());
        RenderTypeLookup.setRenderLayer((Block)BlockSubscriber.dried_grass_bed, (RenderType)RenderType.func_228641_d_());
    }

    @SubscribeEvent
    public static void dataGen(@Nonnull GatherDataEvent event) {
        if (event.includeServer()) {
            AgesApiItemTagGenerator agesApiItemTagGenerator = new AgesApiItemTagGenerator(event.getGenerator());
            ForgeItemTagGenerator forgeItemTagGenerator = new ForgeItemTagGenerator(event.getGenerator());
            RecipeGenerator recipeGenerator = new RecipeGenerator(event.getGenerator());
            event.getGenerator().func_200390_a((IDataProvider)agesApiItemTagGenerator);
            event.getGenerator().func_200390_a((IDataProvider)forgeItemTagGenerator);
            event.getGenerator().func_200390_a((IDataProvider)recipeGenerator);
        }
        if (event.includeClient()) {
            event.getGenerator().func_200390_a((IDataProvider)new LootTableGenerator(event.getGenerator()));
        }
    }
}

