/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ages.api.items;

import com.google.common.base.Throwables;
import com.google.common.collect.Multimap;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.TieredItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class AgesToolItem
extends TieredItem {
    private final Set<Block> effectiveBlocks;
    protected float efficiency;
    private boolean displayAttackDamage;
    private boolean displayAttackSpeed;
    private boolean displayEfficiency;
    protected float attackDamage;
    protected float attackSpeed;

    public AgesToolItem(float attackDamageIn, float attackSpeedIn, IItemTier tier, Set<Block> effectiveBlocksIn, Item.Properties builder, boolean displayAttackDamage, boolean displayAttackSpeed, boolean displayEfficiency) {
        super(tier, builder);
        this.effectiveBlocks = effectiveBlocksIn;
        this.efficiency = tier.func_200928_b();
        this.attackDamage = attackDamageIn + tier.func_200929_c();
        this.attackSpeed = attackSpeedIn;
        this.displayAttackDamage = displayAttackDamage;
        this.displayAttackSpeed = displayAttackSpeed;
        this.displayEfficiency = displayEfficiency;
    }

    public float func_150893_a(ItemStack stack, BlockState state) {
        if (this.getToolTypes(stack).stream().anyMatch(arg_0 -> ((BlockState)state).isToolEffective(arg_0))) {
            return this.efficiency + AgesToolItem.getAdditionalEfficiency(stack);
        }
        return this.effectiveBlocks.contains(state.func_177230_c()) ? this.efficiency + AgesToolItem.getAdditionalEfficiency(stack) : 1.0f;
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.func_222118_a(2, attacker, livingEntity -> livingEntity.func_213361_c(EquipmentSlotType.MAINHAND));
        return true;
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if (!worldIn.field_72995_K && state.func_185887_b((IBlockReader)worldIn, pos) != 0.0f) {
            stack.func_222118_a(1, entityLiving, livingEntity -> livingEntity.func_213361_c(EquipmentSlotType.MAINHAND));
        }
        return true;
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        Multimap multimap = super.func_111205_h(slot);
        if (slot == EquipmentSlotType.MAINHAND) {
            multimap.removeAll((Object)SharedMonsterAttributes.field_111264_e.func_111108_a());
            multimap.removeAll((Object)SharedMonsterAttributes.field_188790_f.func_111108_a());
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Tool modifier", (double)(this.attackDamage + AgesToolItem.getAdditionalAttackDamage(stack)), AttributeModifier.Operation.ADDITION));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Tool modifier", (double)(this.attackSpeed + AgesToolItem.getAdditionalAttackSpeed(stack)), AttributeModifier.Operation.ADDITION));
        }
        return multimap;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (stack.func_77973_b() instanceof AgesToolItem) {
            float efficiency;
            float attackSpeed;
            float attackDamage;
            if (this.displayAttackDamage && (double)Math.abs(attackDamage = AgesToolItem.getAdditionalAttackDamage(stack)) > 0.01) {
                tooltip.add(new StringTextComponent("Attack damage: ").func_211708_a(TextFormatting.DARK_GREEN).func_150257_a(new StringTextComponent(String.format("%.2f", Float.valueOf(attackDamage))).func_211708_a(attackDamage >= 0.0f ? TextFormatting.GREEN : TextFormatting.RED)));
            }
            if (this.displayAttackSpeed && (double)Math.abs(attackSpeed = AgesToolItem.getAdditionalAttackSpeed(stack)) > 0.01) {
                tooltip.add(new StringTextComponent("Attack speed: ").func_211708_a(TextFormatting.DARK_GREEN).func_150257_a(new StringTextComponent(String.format("%.2f", Float.valueOf(attackSpeed))).func_211708_a(attackSpeed >= 0.0f ? TextFormatting.GREEN : TextFormatting.RED)));
            }
            if (this.displayEfficiency && (double)Math.abs(efficiency = AgesToolItem.getAdditionalEfficiency(stack)) > 0.01) {
                tooltip.add(new StringTextComponent("Efficiency: ").func_211708_a(TextFormatting.DARK_GREEN).func_150257_a(new StringTextComponent(String.format("%.2f", Float.valueOf(efficiency))).func_211708_a(efficiency >= 0.0f ? TextFormatting.GREEN : TextFormatting.RED)));
            }
        }
    }

    public static float getAdditionalAttackDamage(ItemStack itemStack) {
        CompoundNBT tag = itemStack.func_190925_c("additionalModifiers");
        return tag.func_74760_g("attackDamage");
    }

    public static float getAdditionalAttackSpeed(ItemStack itemStack) {
        CompoundNBT tag = itemStack.func_190925_c("additionalModifiers");
        return tag.func_74760_g("attackSpeed");
    }

    public static float getAdditionalEfficiency(ItemStack itemStack) {
        CompoundNBT tag = itemStack.func_190925_c("additionalModifiers");
        return tag.func_74760_g("efficiency");
    }

    public static void setAdditionalModifiers(ItemStack itemStack, float attackDamage, float attackSpeed, float efficiency) {
        CompoundNBT tag = itemStack.func_190925_c("additionalModifiers");
        tag.func_74776_a("attackDamage", attackDamage);
        tag.func_74776_a("attackSpeed", attackSpeed);
        tag.func_74776_a("efficiency", efficiency);
    }

    public static <T, E> T getPrivateValue(Class<? super E> classToAccess, @Nullable E instance, int fieldIndex) {
        try {
            Field f = classToAccess.getDeclaredFields()[fieldIndex];
            f.setAccessible(true);
            return (T)f.get(instance);
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

