/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ages.api.utils;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraftforge.client.ForgeHooksClient;

public class ItemStackUtils {
    public static CompoundNBT serializeStacks(@Nonnull NonNullList<ItemStack> stacks) {
        ListNBT listNBT = new ListNBT();
        CompoundNBT compoundNBT = new CompoundNBT();
        stacks.forEach(itemStack -> {
            CompoundNBT nbt = new CompoundNBT();
            itemStack.func_77955_b(nbt);
            listNBT.add((Object)nbt);
        });
        compoundNBT.func_218657_a("Items", (INBT)listNBT);
        return compoundNBT;
    }

    public static CompoundNBT serializeIngredients(@Nonnull List<Ingredient> ingredients) {
        ListNBT listNBT = new ListNBT();
        CompoundNBT compoundNBT = new CompoundNBT();
        ingredients.forEach(ingredient -> {
            ListNBT itemsNBT = new ListNBT();
            CompoundNBT itemsCompound = new CompoundNBT();
            for (ItemStack itemStack : ingredient.func_193365_a()) {
                CompoundNBT nbt = new CompoundNBT();
                itemStack.func_77955_b(nbt);
                itemsNBT.add((Object)nbt);
            }
            itemsCompound.func_218657_a("Items", (INBT)itemsNBT);
            listNBT.add((Object)itemsCompound);
        });
        compoundNBT.func_218657_a("Items", (INBT)listNBT);
        return compoundNBT;
    }

    public static void deserializeStacks(@Nonnull CompoundNBT compoundNBT, @Nonnull NonNullList<ItemStack> stacks) {
        assert (compoundNBT.func_150297_b("Items", 9));
        ListNBT listNBT = compoundNBT.func_150295_c("Items", 10);
        assert (listNBT.size() == stacks.size());
        AtomicInteger cnt = new AtomicInteger(0);
        listNBT.forEach(nbt -> {
            ItemStack itemStack = ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)nbt));
            stacks.set(cnt.getAndIncrement(), (Object)itemStack);
        });
    }

    public static void deserializeIngredients(@Nonnull CompoundNBT compoundNBT, @Nonnull List<Ingredient> ingredients) {
        assert (compoundNBT.func_150297_b("Items", 9));
        ListNBT listNBT = compoundNBT.func_150295_c("Items", 10);
        ingredients.clear();
        listNBT.forEach(nbt -> {
            assert (((CompoundNBT)nbt).func_150297_b("Items", 9));
            ListNBT itemsNBT = ((CompoundNBT)nbt).func_150295_c("Items", 10);
            ArrayList itemStacks = new ArrayList();
            itemsNBT.forEach(itemNbt -> {
                ItemStack itemStack = ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)itemNbt));
                itemStacks.add(itemStack);
            });
            ingredients.add(Ingredient.func_193369_a((ItemStack[])itemStacks.toArray(new ItemStack[0])));
        });
    }

    public static void insertItems(@Nonnull List<ItemStack> input, List<ItemStack> output, int startIndex, int endIndex) {
        assert (output.size() > startIndex && output.size() >= endIndex && startIndex < endIndex);
        for (ItemStack itemStack : input) {
            if (itemStack.func_190926_b()) {
                return;
            }
            int index = ItemStackUtils.getFirstFreeOrValid(itemStack, output, startIndex, endIndex);
            if (index < 0) {
                return;
            }
            int items = itemStack.func_190916_E();
            if (!output.get(index).func_190926_b()) {
                while (items > 0) {
                    ItemStack item = output.get(index);
                    int amount = item.func_77976_d() - item.func_190916_E();
                    if (amount < items) {
                        item.func_190917_f(amount);
                        items -= amount;
                        index = ItemStackUtils.getFirstFreeOrValid(itemStack, output, index, endIndex);
                        continue;
                    }
                    item.func_190917_f(items);
                    items = 0;
                }
                continue;
            }
            output.set(index, itemStack.func_77946_l());
        }
    }

    public static void renderItem(ItemStack itemStackIn, ItemCameraTransforms.TransformType transformTypeIn, int combinedLightIn, int combinedOverlayIn, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, float alpha) {
        ItemStackUtils.renderItem(itemStackIn, transformTypeIn, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn, alpha);
    }

    private static void renderItem(ItemStack itemStackIn, ItemCameraTransforms.TransformType transformTypeIn, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn, float alpha) {
        if (!itemStackIn.func_190926_b()) {
            IBakedModel ibakedmodel = ItemStackUtils.getItemModelWithOverrides(itemStackIn);
            ItemStackUtils.renderItem(itemStackIn, transformTypeIn, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn, ibakedmodel, alpha);
        }
    }

    private static IBakedModel getItemModelWithOverrides(ItemStack stack) {
        Item item = stack.func_77973_b();
        IBakedModel ibakedmodel = item == Items.field_203184_eO ? Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178083_a().func_174953_a(new ModelResourceLocation("minecraft:trident_in_hand#inventory")) : Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(stack);
        return ItemStackUtils.getModelWithOverrides(ibakedmodel, stack);
    }

    private static IBakedModel getModelWithOverrides(IBakedModel model, ItemStack stack) {
        IBakedModel ibakedmodel = model.func_188617_f().func_239290_a_(model, stack, null, null);
        return ibakedmodel == null ? Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178083_a().func_174951_a() : ibakedmodel;
    }

    private static void renderItem(ItemStack itemStackIn, ItemCameraTransforms.TransformType transformTypeIn, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn, IBakedModel modelIn, float alpha) {
        if (!itemStackIn.func_190926_b()) {
            boolean flag1;
            matrixStackIn.func_227860_a_();
            boolean flag = transformTypeIn == ItemCameraTransforms.TransformType.GUI;
            boolean bl = flag1 = flag || transformTypeIn == ItemCameraTransforms.TransformType.GROUND || transformTypeIn == ItemCameraTransforms.TransformType.FIXED;
            if (itemStackIn.func_77973_b() == Items.field_203184_eO && flag1) {
                modelIn = Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178083_a().func_174953_a(new ModelResourceLocation("minecraft:trident#inventory"));
            }
            modelIn = ForgeHooksClient.handleCameraTransforms((MatrixStack)matrixStackIn, (IBakedModel)modelIn, (ItemCameraTransforms.TransformType)transformTypeIn, (boolean)false);
            matrixStackIn.func_227861_a_(-0.5, -0.5, -0.5);
            if (modelIn.func_188618_c() || itemStackIn.func_77973_b() == Items.field_203184_eO && !flag1) {
                itemStackIn.func_77973_b().getItemStackTileEntityRenderer().func_239207_a_(itemStackIn, transformTypeIn, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn);
            } else {
                RenderType rendertype = RenderTypeLookup.func_239219_a_((ItemStack)itemStackIn, (boolean)true);
                RenderType rendertype1 = flag && Objects.equals(rendertype, Atlases.func_228785_j_()) ? Atlases.func_228785_j_() : rendertype;
                IVertexBuilder ivertexbuilder = ItemRenderer.func_229113_a_((IRenderTypeBuffer)bufferIn, (RenderType)rendertype1, (boolean)true, (boolean)itemStackIn.func_77962_s());
                ItemStackUtils.renderModel(modelIn, combinedLightIn, combinedOverlayIn, matrixStackIn, ivertexbuilder, alpha);
            }
            matrixStackIn.func_227865_b_();
        }
    }

    private static void renderModel(IBakedModel modelIn, int combinedLightIn, int combinedOverlayIn, MatrixStack matrixStackIn, IVertexBuilder bufferIn, float alpha) {
        Direction[] var10;
        Random random = new Random();
        for (Direction direction : var10 = Direction.values()) {
            random.setSeed(42L);
            ItemStackUtils.renderQuads(matrixStackIn, bufferIn, modelIn.func_200117_a(null, direction, random), combinedLightIn, combinedOverlayIn, alpha);
        }
        random.setSeed(42L);
        ItemStackUtils.renderQuads(matrixStackIn, bufferIn, modelIn.func_200117_a(null, null, random), combinedLightIn, combinedOverlayIn, alpha);
    }

    private static void renderQuads(MatrixStack matrixStackIn, IVertexBuilder bufferIn, List<BakedQuad> quadsIn, int combinedLightIn, int combinedOverlayIn, float alpha) {
        MatrixStack.Entry matrixstack$entry = matrixStackIn.func_227866_c_();
        for (BakedQuad bakedquad : quadsIn) {
            bufferIn.addVertexData(matrixstack$entry, bakedquad, 1.0f, 1.0f, 1.0f, alpha, combinedLightIn, combinedOverlayIn, true);
        }
    }

    private static int getFirstFreeOrValid(ItemStack item, List<ItemStack> output, int startIndex, int endIndex) {
        for (int i = startIndex; i < endIndex; ++i) {
            ItemStack itemStack = output.get(i);
            if (!(itemStack.func_77969_a(item) ? itemStack.func_190916_E() < itemStack.func_77976_d() : itemStack.func_190926_b())) continue;
            return i;
        }
        return -1;
    }
}

