/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.age.stone.blocks;

import com.yanny.age.stone.blocks.IInventoryInterface;
import com.yanny.age.stone.recipes.DryingRackRecipe;
import com.yanny.age.stone.subscribers.TileEntitySubscriber;
import com.yanny.ages.api.utils.ItemStackUtils;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class DryingRackTileEntity
extends TileEntity
implements IInventoryInterface,
ITickableTileEntity {
    public static final int ITEMS = 4;
    private final NonNullList<ItemStack> stacks = NonNullList.func_191197_a((int)8, (Object)ItemStack.field_190927_a);
    private final IItemHandlerModifiable nonSidedItemHandler = this.createNonSidedInventoryHandler(this.stacks);
    private final LazyOptional<IItemHandlerModifiable> sidedInventoryHandler = LazyOptional.of(() -> this.createSidedInventoryHandler(this.stacks));
    private final LazyOptional<IItemHandlerModifiable> nonSidedInventoryHandler = LazyOptional.of(() -> this.nonSidedItemHandler);
    private final RecipeWrapper inventoryWrapper = new RecipeWrapper(this.nonSidedItemHandler);
    private final IItemHandlerModifiable tmpItemHandler = new ItemStackHandler(1);
    private final RecipeWrapper tmpItemHandlerWrapper = new RecipeWrapper(this.tmpItemHandler);
    private final DryingItem[] items = new DryingItem[4];

    public DryingRackTileEntity() {
        super(TileEntitySubscriber.drying_rack);
        for (int i = 0; i < 4; ++i) {
            this.items[i] = new DryingItem();
        }
    }

    public void func_73660_a() {
        assert (this.field_145850_b != null);
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_72935_r()) {
            for (int i = 0; i < 4; ++i) {
                if (!this.items[i].active) continue;
                if (this.items[i].isDried()) {
                    this.stacks.set(i + 4, (Object)this.items[i].result);
                    this.stacks.set(i, (Object)ItemStack.field_190927_a);
                    this.items[i].reset();
                    this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 3);
                    continue;
                }
                --this.items[i].remaining;
            }
        }
    }

    @Override
    @Nonnull
    public IInventory getInventory() {
        return this.inventoryWrapper;
    }

    @Nonnull
    public NonNullList<ItemStack> getStacks() {
        return this.stacks;
    }

    public void func_230337_a_(@Nonnull BlockState blockState, CompoundNBT tag) {
        CompoundNBT invTag = tag.func_74775_l("inv");
        ItemStackUtils.deserializeStacks((CompoundNBT)invTag, this.stacks);
        for (int i = 0; i < 4; ++i) {
            this.items[i].read(tag.func_74775_l("items" + i));
        }
        super.func_230337_a_(blockState, tag);
    }

    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag.func_218657_a("inv", (INBT)ItemStackUtils.serializeStacks(this.stacks));
        for (int i = 0; i < 4; ++i) {
            tag.func_218657_a("items" + i, (INBT)this.items[i].write());
        }
        return super.func_189515_b(tag);
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), this.func_200662_C().hashCode(), this.func_189517_E_());
    }

    @Nonnull
    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        super.onDataPacket(net, pkt);
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (side != null) {
                return this.sidedInventoryHandler.cast();
            }
            return this.nonSidedInventoryHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void func_145843_s() {
        this.sidedInventoryHandler.invalidate();
        this.nonSidedInventoryHandler.invalidate();
        super.func_145843_s();
    }

    @Nonnull
    DryingItem getItem(int index) {
        return this.items[index];
    }

    void blockActivated(@Nonnull PlayerEntity player) {
        assert (this.field_145850_b != null);
        if (!this.field_145850_b.field_72995_K) {
            ItemStack itemStack = player.func_184614_ca();
            DryingRackRecipe recipe = this.getRecipe(itemStack).orElse(null);
            for (int i = 0; i < 4; ++i) {
                if (((ItemStack)this.stacks.get(i)).func_190926_b() && ((ItemStack)this.stacks.get(i + 4)).func_190926_b() && recipe != null) {
                    DryingItem item = this.items[i];
                    this.stacks.set(i, (Object)itemStack.func_77979_a(1));
                    item.setup(true, recipe.getDryingTime(), recipe.func_77572_b(null));
                    this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 3);
                    return;
                }
                if (((ItemStack)this.stacks.get(i + 4)).func_190926_b()) continue;
                NonNullList itemStacks = NonNullList.func_191196_a();
                itemStacks.add((Object)((ItemStack)this.stacks.get(i + 4)).func_77946_l());
                this.stacks.set(i + 4, (Object)ItemStack.field_190927_a);
                this.stacks.set(i, (Object)ItemStack.field_190927_a);
                InventoryHelper.func_219961_a((World)this.field_145850_b, (BlockPos)this.func_174877_v(), (NonNullList)itemStacks);
                this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 3);
                this.field_145850_b.func_184133_a(null, this.func_174877_v(), SoundEvents.field_187638_cR, SoundCategory.BLOCKS, 1.0f, 1.0f);
                return;
            }
        }
    }

    @Nonnull
    private Optional<DryingRackRecipe> getRecipe(@Nonnull ItemStack item) {
        assert (this.field_145850_b != null);
        this.tmpItemHandler.setStackInSlot(0, item);
        return this.field_145850_b.func_199532_z().func_215371_a(DryingRackRecipe.drying_rack, (IInventory)this.tmpItemHandlerWrapper, this.field_145850_b);
    }

    private IItemHandlerModifiable createNonSidedInventoryHandler(@Nonnull NonNullList<ItemStack> stacks) {
        return new ItemStackHandler(stacks){

            protected void onContentsChanged(int slot) {
                assert (DryingRackTileEntity.this.field_145850_b != null);
                DryingRackTileEntity.this.func_70296_d();
                DryingRackTileEntity.this.field_145850_b.func_184138_a(DryingRackTileEntity.this.func_174877_v(), DryingRackTileEntity.this.func_195044_w(), DryingRackTileEntity.this.func_195044_w(), 3);
            }
        };
    }

    private IItemHandlerModifiable createSidedInventoryHandler(@Nonnull NonNullList<ItemStack> stacks) {
        return new ItemStackHandler(stacks){

            @Nonnull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                if (slot >= 4) {
                    return super.extractItem(slot, amount, simulate);
                }
                return ItemStack.field_190927_a;
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                DryingRackRecipe recipe;
                if (slot < 4 && this.getStackInSlot(slot).func_190926_b() && DryingRackTileEntity.this.field_145850_b != null && (recipe = (DryingRackRecipe)DryingRackTileEntity.this.getRecipe(stack).orElse(null)) != null) {
                    DryingRackTileEntity.this.items[slot].setup(true, recipe.getDryingTime(), recipe.func_77572_b(null));
                    return super.insertItem(slot, stack, simulate);
                }
                return stack;
            }

            protected void onContentsChanged(int slot) {
                assert (DryingRackTileEntity.this.field_145850_b != null);
                DryingRackTileEntity.this.func_70296_d();
                DryingRackTileEntity.this.field_145850_b.func_184138_a(DryingRackTileEntity.this.func_174877_v(), DryingRackTileEntity.this.func_195044_w(), DryingRackTileEntity.this.func_195044_w(), 3);
            }
        };
    }

    static class DryingItem {
        boolean active;
        int dryingTime;
        int remaining;
        ItemStack result;

        DryingItem() {
            this.setup(false, 0, ItemStack.field_190927_a);
        }

        boolean isDried() {
            return this.active && this.remaining <= 0;
        }

        void setup(boolean active, int dryingTime, ItemStack result) {
            this.active = active;
            this.dryingTime = this.remaining = dryingTime;
            this.result = result;
        }

        void reset() {
            this.active = false;
            this.result = ItemStack.field_190927_a;
        }

        CompoundNBT write() {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74757_a("active", this.active);
            nbt.func_74768_a("dryingTime", this.dryingTime);
            nbt.func_74768_a("remaining", this.remaining);
            CompoundNBT item = new CompoundNBT();
            this.result.func_77955_b(item);
            nbt.func_218657_a("item", (INBT)item);
            return nbt;
        }

        void read(CompoundNBT nbt) {
            this.active = nbt.func_74767_n("active");
            this.dryingTime = nbt.func_74762_e("dryingTime");
            this.remaining = nbt.func_74762_e("remaining");
            this.result = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("item"));
        }
    }
}

