/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.age.stone.blocks;

import com.yanny.age.stone.blocks.FeederTileEntity;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemTier;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fml.network.NetworkHooks;

public class FeederBlock
extends HorizontalBlock {
    private static final VoxelShape SHAPE_NS = Block.func_208617_a((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)6.0, (double)12.0);
    private static final VoxelShape SHAPE_EW = Block.func_208617_a((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)6.0, (double)16.0);

    public FeederBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).harvestLevel(ItemTier.WOOD.func_200925_d()).harvestTool(ToolType.AXE).func_200943_b(2.0f));
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new FeederTileEntity();
    }

    @Nonnull
    public VoxelShape func_220053_a(BlockState state, @Nonnull IBlockReader worldIn, @Nonnull BlockPos pos, @Nonnull ISelectionContext context) {
        if (((Direction)state.func_177229_b((Property)field_185512_D)).func_176740_k() == Direction.Axis.Z) {
            return SHAPE_NS;
        }
        return SHAPE_EW;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)field_185512_D, (Comparable)context.func_195992_f().func_176734_d());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{field_185512_D});
    }

    public void func_196243_a(BlockState state, @Nonnull World worldIn, @Nonnull BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileEntity tileentity = worldIn.func_175625_s(pos);
            if (tileentity instanceof FeederTileEntity) {
                InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)((FeederTileEntity)tileentity).getInventory());
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    @Nonnull
    public ActionResultType func_225533_a_(@Nonnull BlockState state, World worldIn, @Nonnull BlockPos pos, @Nonnull PlayerEntity player, @Nonnull Hand handIn, @Nonnull BlockRayTraceResult hit) {
        FeederTileEntity tile = (FeederTileEntity)worldIn.func_175625_s(pos);
        if (tile != null) {
            if (!player.func_225608_bj_()) {
                if (!worldIn.field_72995_K) {
                    NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)tile, (BlockPos)tile.func_174877_v());
                }
                return ActionResultType.SUCCESS;
            }
            ActionResultType resultType = super.func_225533_a_(state, worldIn, pos, player, handIn, hit);
            if (player.func_225608_bj_() && resultType == ActionResultType.PASS) {
                if (!worldIn.field_72995_K) {
                    NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)tile, (BlockPos)tile.func_174877_v());
                }
                return ActionResultType.SUCCESS;
            }
        } else {
            throw new IllegalStateException("Named container provider is missing");
        }
        return super.func_225533_a_(state, worldIn, pos, player, handIn, hit);
    }
}

