/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.age.stone.datagen;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.yanny.age.stone.subscribers.RecipeSubscriber;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.IRequirementsStrategy;
import net.minecraft.advancements.criterion.RecipeUnlockedTrigger;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.lwjgl.system.NonnullDefault;

@NonnullDefault
public class DryingRackRecipeBuilder {
    private final Item result;
    private final int count;
    private final Ingredient input;
    private final Advancement.Builder advancementBuilder = Advancement.Builder.func_200278_a();
    @Nullable
    private String group = null;
    private int dryingTime = 300;

    public DryingRackRecipeBuilder(IItemProvider resultIn, IItemProvider input, int countIn) {
        this.result = resultIn.func_199767_j();
        this.input = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{input});
        this.count = countIn;
    }

    public static DryingRackRecipeBuilder recipe(IItemProvider resultIn, IItemProvider input) {
        return DryingRackRecipeBuilder.recipe(resultIn, input, 1);
    }

    public static DryingRackRecipeBuilder recipe(IItemProvider resultIn, IItemProvider input, int countIn) {
        return new DryingRackRecipeBuilder(resultIn, input, countIn);
    }

    public DryingRackRecipeBuilder dryingTime(int dryingTime) {
        this.dryingTime = dryingTime;
        return this;
    }

    public DryingRackRecipeBuilder addCriterion(String name, ICriterionInstance criterionIn) {
        this.advancementBuilder.func_200275_a(name, criterionIn);
        return this;
    }

    public DryingRackRecipeBuilder setGroup(String groupIn) {
        this.group = groupIn;
        return this;
    }

    public void build(Consumer<IFinishedRecipe> consumerIn) {
        this.build(consumerIn, Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.result)));
    }

    public void build(Consumer<IFinishedRecipe> consumerIn, String save) {
        ResourceLocation resourcelocation = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.result);
        if (new ResourceLocation(save).equals((Object)resourcelocation)) {
            throw new IllegalStateException("Shaped Recipe " + save + " should remove its 'save' argument");
        }
        this.build(consumerIn, new ResourceLocation(save));
    }

    public void build(Consumer<IFinishedRecipe> consumerIn, ResourceLocation id) {
        if (this.result.func_77640_w() == null) {
            throw new IllegalStateException("Recipe " + id + " has null group!");
        }
        this.advancementBuilder.func_200272_a(new ResourceLocation("recipes/root")).func_200275_a("has_the_recipe", (ICriterionInstance)RecipeUnlockedTrigger.func_235675_a_((ResourceLocation)id)).func_200271_a(AdvancementRewards.Builder.func_200280_c((ResourceLocation)id)).func_200270_a(IRequirementsStrategy.field_223215_b_);
        consumerIn.accept(new Result(id, this.result, this.input, this.count, this.dryingTime, this.group == null ? "" : this.group, this.advancementBuilder, new ResourceLocation(id.func_110624_b(), "recipes/" + this.result.func_77640_w().func_200300_c() + "/" + id.func_110623_a())));
    }

    public static class Result
    implements IFinishedRecipe {
        private final ResourceLocation id;
        private final Item result;
        private final int count;
        private final int dryingTime;
        private final String group;
        private final Ingredient input;
        private final Advancement.Builder advancementBuilder;
        private final ResourceLocation advancementId;

        public Result(ResourceLocation idIn, Item resultIn, Ingredient input, int countIn, int dryingTime, String groupIn, Advancement.Builder advancementBuilderIn, ResourceLocation advancementIdIn) {
            this.id = idIn;
            this.result = resultIn;
            this.count = countIn;
            this.dryingTime = dryingTime;
            this.group = groupIn;
            this.input = input;
            this.advancementBuilder = advancementBuilderIn;
            this.advancementId = advancementIdIn;
        }

        public void func_218610_a(JsonObject json) {
            if (!this.group.isEmpty()) {
                json.addProperty("group", this.group);
            }
            json.add("ingredient", this.input.func_200304_c());
            json.addProperty("dryingTime", (Number)this.dryingTime);
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("item", Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.result)).toString());
            if (this.count > 1) {
                jsonObject.addProperty("count", (Number)this.count);
            }
            json.add("result", (JsonElement)jsonObject);
        }

        public IRecipeSerializer<?> func_218609_c() {
            return RecipeSubscriber.drying_rack;
        }

        public ResourceLocation func_200442_b() {
            return this.id;
        }

        @Nullable
        public JsonObject func_200440_c() {
            return this.advancementBuilder.func_200273_b();
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return this.advancementId;
        }
    }
}

