/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.age.stone.items;

import com.yanny.age.stone.group.ModItemGroup;
import com.yanny.age.stone.items.BackpakcContainer;
import com.yanny.ages.api.utils.ItemStackUtils;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class BackpackItem
extends Item
implements INamedContainerProvider {
    public static final int INVENTORY_WIDTH = 5;
    public static final int INVENTORY_HEIGHT = 3;
    public static final int ITEMS = 15;

    public BackpackItem() {
        super(new Item.Properties().func_200916_a(ModItemGroup.AGES).func_200917_a(1));
    }

    @Nonnull
    public static NonNullList<ItemStack> getBackpackItems(@Nonnull ItemStack backpack) {
        NonNullList list = NonNullList.func_191197_a((int)15, (Object)ItemStack.field_190927_a);
        if (backpack.func_179543_a("backpack") != null) {
            ItemStackUtils.deserializeStacks((CompoundNBT)backpack.func_190925_c("backpack").func_74775_l("inv"), (NonNullList)list);
        } else {
            BackpackItem.saveBackpackItems(backpack, (NonNullList<ItemStack>)list);
        }
        return list;
    }

    public static void saveBackpackItems(@Nonnull ItemStack backpack, @Nonnull NonNullList<ItemStack> list) {
        backpack.func_190925_c("backpack").func_218657_a("inv", (INBT)ItemStackUtils.serializeStacks(list));
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, @Nonnull Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        BackpackItem.getBackpackItems(stack);
        if (!worldIn.field_72995_K && playerIn instanceof ServerPlayerEntity) {
            playerIn.func_213829_a((INamedContainerProvider)this);
            return ActionResult.func_226250_c_((Object)stack);
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext context) {
        ItemStack stack = context.func_195996_i();
        BackpackItem.getBackpackItems(stack);
        if (!context.func_195991_k().field_72995_K && context.func_195999_j() instanceof ServerPlayerEntity) {
            context.func_195999_j().func_213829_a((INamedContainerProvider)this);
        }
        return ActionResultType.SUCCESS;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(final ItemStack stack, @Nullable CompoundNBT nbts) {
        final NonNullList<ItemStack> list = BackpackItem.getBackpackItems(stack);
        return new ICapabilityProvider(){

            @Nonnull
            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                    return LazyOptional.of(() -> new ItemStackHandler(list){

                        protected void onContentsChanged(int slot) {
                            super.onContentsChanged(slot);
                            BackpackItem.saveBackpackItems(stack, (NonNullList<ItemStack>)list);
                        }
                    }).cast();
                }
                return LazyOptional.empty();
            }
        };
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        return new StringTextComponent(Objects.requireNonNull(this.getRegistryName()).func_110623_a());
    }

    @Nullable
    public Container createMenu(int id, @Nonnull PlayerInventory inventory, @Nonnull PlayerEntity entity) {
        return new BackpakcContainer(id, inventory, inventory.func_70448_g());
    }
}

