/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.age.stone.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.yanny.age.stone.recipes.TreeStumpRecipe;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class TreeStumpRecipeSerializer
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<TreeStumpRecipe> {
    private final IFactory<TreeStumpRecipe> factory;

    public TreeStumpRecipeSerializer(@Nonnull IFactory<TreeStumpRecipe> factory) {
        this.factory = factory;
    }

    @Nonnull
    public TreeStumpRecipe read(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
        ItemStack itemstack;
        String s = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
        JsonArray ingredientJsonElement = JSONUtils.func_151202_d((JsonObject)json, (String)"ingredient") ? JSONUtils.func_151214_t((JsonObject)json, (String)"ingredient") : JSONUtils.func_152754_s((JsonObject)json, (String)"ingredient");
        JsonArray toolJsonElement = JSONUtils.func_151202_d((JsonObject)json, (String)"tool") ? JSONUtils.func_151214_t((JsonObject)json, (String)"tool") : JSONUtils.func_152754_s((JsonObject)json, (String)"tool");
        Ingredient ingredient = Ingredient.func_199802_a((JsonElement)ingredientJsonElement);
        Ingredient tool = Ingredient.func_199802_a((JsonElement)toolJsonElement);
        if (!json.has("result")) {
            throw new JsonSyntaxException("Missing result, expected to find a string or object");
        }
        if (json.get("result").isJsonObject()) {
            itemstack = CraftingHelper.getItemStack((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"), (boolean)true);
        } else {
            String s1 = JSONUtils.func_151200_h((JsonObject)json, (String)"result");
            ResourceLocation resourcelocation = new ResourceLocation(s1);
            itemstack = new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(resourcelocation));
        }
        int i = JSONUtils.func_151208_a((JsonObject)json, (String)"chopTimes", (int)1);
        return this.factory.create(recipeId, s, ingredient, tool, itemstack, i);
    }

    @Nullable
    public TreeStumpRecipe read(@Nonnull ResourceLocation recipeId, PacketBuffer buffer) {
        String s = buffer.func_150789_c(Short.MAX_VALUE);
        Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
        Ingredient tool = Ingredient.func_199566_b((PacketBuffer)buffer);
        ItemStack itemstack = buffer.func_150791_c();
        int i = buffer.func_150792_a();
        return this.factory.create(recipeId, s, ingredient, tool, itemstack, i);
    }

    public void write(PacketBuffer buffer, TreeStumpRecipe recipe) {
        buffer.func_180714_a(recipe.group);
        recipe.ingredient.func_199564_a(buffer);
        recipe.tool.func_199564_a(buffer);
        buffer.func_150788_a(recipe.result);
        buffer.func_150787_b(recipe.chopTimes);
    }

    public static interface IFactory<T extends TreeStumpRecipe> {
        public T create(@Nonnull ResourceLocation var1, @Nonnull String var2, @Nonnull Ingredient var3, @Nonnull Ingredient var4, @Nonnull ItemStack var5, int var6);
    }
}

