/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.age.stone.structures;

import com.yanny.age.stone.blocks.DryingRackTileEntity;
import com.yanny.age.stone.blocks.FlintWorkbenchTileEntity;
import com.yanny.age.stone.blocks.StoneChestTileEntity;
import com.yanny.age.stone.blocks.TanningRackTileEntity;
import com.yanny.age.stone.subscribers.BlockSubscriber;
import com.yanny.age.stone.subscribers.ItemSubscriber;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BedPart;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import org.joml.Matrix3f;
import org.joml.Vector3f;

public class FeatureUtils {
    private static final Vector3f vector = new Vector3f();

    public static void fillWithAir(ISeedReader seedReader, BlockPos pos, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        for (int i = minY; i <= maxY; ++i) {
            for (int j = minX; j <= maxX; ++j) {
                for (int k = minZ; k <= maxZ; ++k) {
                    seedReader.func_180501_a(pos.func_177982_a(j, i, k), Blocks.field_150350_a.func_176223_P(), 2);
                }
            }
        }
    }

    public static void fillWithBlocks(ISeedReader seedReader, BlockPos pos, int xMin, int yMin, int zMin, int xMax, int yMax, int zMax, BlockState boundaryBlockState, BlockState insideBlockState, boolean existingOnly) {
        for (int i = yMin; i <= yMax; ++i) {
            for (int j = xMin; j <= xMax; ++j) {
                for (int k = zMin; k <= zMax; ++k) {
                    if (existingOnly && seedReader.func_180495_p(pos.func_177982_a(j, i, k)).func_196958_f()) continue;
                    if (i != yMin && i != yMax && j != xMin && j != xMax && k != zMin && k != zMax) {
                        seedReader.func_180501_a(pos.func_177982_a(j, i, k), insideBlockState, 2);
                        continue;
                    }
                    seedReader.func_180501_a(pos.func_177982_a(j, i, k), boundaryBlockState, 2);
                }
            }
        }
    }

    public static void generateRandomRack(@Nonnull ISeedReader seedReader, @Nonnull BlockPos pos, @Nonnull Random random, @Nonnull Direction direction) {
        block4: {
            block3: {
                if (!(random.nextDouble() < 0.5)) break block3;
                seedReader.func_180501_a(pos, (BlockState)BlockSubscriber.drying_rack.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)direction), 2);
                TileEntity tileentity = seedReader.func_175625_s(pos);
                if (!(tileentity instanceof DryingRackTileEntity)) break block4;
                NonNullList<ItemStack> stacks = ((DryingRackTileEntity)tileentity).getStacks();
                for (int i = stacks.size() / 2; i < stacks.size(); ++i) {
                    if (!(random.nextDouble() < 0.5)) continue;
                    stacks.set(i, (Object)new ItemStack((IItemProvider)ItemSubscriber.dried_grass));
                }
                break block4;
            }
            seedReader.func_180501_a(pos, (BlockState)BlockSubscriber.tanning_rack.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)direction), 2);
            TileEntity tileentity = seedReader.func_175625_s(pos);
            if (tileentity instanceof TanningRackTileEntity) {
                NonNullList<ItemStack> stacks = ((TanningRackTileEntity)tileentity).getStacks();
                for (int i = 0; i < stacks.size() / 2; ++i) {
                    if (!(random.nextDouble() < 0.7)) continue;
                    stacks.set(i, (Object)new ItemStack((IItemProvider)ItemSubscriber.raw_hide));
                }
            }
        }
    }

    public static void generateBed(@Nonnull ISeedReader seedReader, @Nonnull BlockPos pos, Direction direction) {
        Direction bedDirection = direction.func_176743_c() == Direction.AxisDirection.NEGATIVE ? direction : direction.func_176734_d();
        seedReader.func_180501_a(pos, (BlockState)((BlockState)BlockSubscriber.dried_grass_bed.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)bedDirection)).func_206870_a((Property)BlockStateProperties.field_208139_an, (Comparable)BedPart.HEAD), 2);
        seedReader.func_180501_a(pos.func_241872_a(direction.func_176740_k(), 1), (BlockState)((BlockState)BlockSubscriber.dried_grass_bed.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)bedDirection)).func_206870_a((Property)BlockStateProperties.field_208139_an, (Comparable)BedPart.FOOT), 2);
    }

    public static BlockPos getRotatedPos(BlockPos pos, int x, int y, int z, Matrix3f normal) {
        vector.set(x, y, z);
        vector.mulTranspose(normal);
        return pos.func_177982_a(Math.round(FeatureUtils.vector.x), Math.round(FeatureUtils.vector.y), Math.round(FeatureUtils.vector.z));
    }

    public static void generateFlintWorkbench(@Nonnull ISeedReader seedReader, @Nonnull BlockPos pos, @Nonnull Random rand, @Nonnull Direction direction) {
        seedReader.func_180501_a(pos, (BlockState)BlockSubscriber.flint_workbench.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)direction), 2);
        TileEntity tileentity = seedReader.func_175625_s(pos);
        if (tileentity instanceof FlintWorkbenchTileEntity) {
            NonNullList<ItemStack> stacks = ((FlintWorkbenchTileEntity)tileentity).getStacks();
            for (int i = 0; i < stacks.size(); ++i) {
                if (!(rand.nextDouble() < 0.25)) continue;
                stacks.set(i, (Object)new ItemStack((IItemProvider)ItemSubscriber.antler));
            }
        }
    }

    public static void generateStoneChest(@Nonnull ISeedReader seedReader, BlockPos pos, @Nonnull Random rand, @Nonnull ResourceLocation lootResource, Direction direction) {
        seedReader.func_180501_a(pos, (BlockState)BlockSubscriber.stone_chest.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)direction), 2);
        TileEntity tileentity = seedReader.func_175625_s(pos);
        if (tileentity instanceof StoneChestTileEntity) {
            ((StoneChestTileEntity)tileentity).func_189404_a(lootResource, rand.nextLong());
        }
    }

    public static void replaceAirAndLiquidDownwards(@Nonnull ISeedReader seedReader, @Nonnull BlockPos pos, @Nonnull BlockState blockState) {
        int i = pos.func_177956_o();
        BlockPos p = pos;
        while (FeatureUtils.isNotSolid(seedReader, p) && i > 1) {
            seedReader.func_180501_a(p, blockState, 2);
            p = p.func_177977_b();
        }
    }

    private static boolean isNotSolid(@Nonnull ISeedReader seedReader, @Nonnull BlockPos pos) {
        BlockState state = seedReader.func_180495_p(pos);
        return seedReader.func_175623_d(pos) || state.func_185904_a().func_76224_d() || state.func_185904_a().func_76222_j() || state.func_185904_a().equals(Material.field_151595_p) || state.func_185904_a().equals(Material.field_151578_c) || state.func_185904_a().equals(Material.field_151577_b);
    }
}

