/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.structures.jigsaw;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.legacy.structure_gel.StructureGelMod;
import com.legacy.structure_gel.structures.GelPlacementSettings;
import com.legacy.structure_gel.structures.GelStructurePiece;
import com.legacy.structure_gel.structures.GelTemplate;
import com.legacy.structure_gel.structures.processors.RemoveGelStructureProcessor;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.state.properties.StructureMode;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.jigsaw.IJigsawDeserializer;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.jigsaw.SingleJigsawPiece;
import net.minecraft.world.gen.feature.template.JigsawReplacementStructureProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class GelJigsawPiece
extends SingleJigsawPiece {
    private boolean maintainWater = true;
    private boolean ignoreEntities = false;

    public GelJigsawPiece(ResourceLocation location, List<StructureProcessor> processors, JigsawPattern.PlacementBehaviour placementBehavior) {
        super(location.toString(), processors, placementBehavior);
    }

    public GelJigsawPiece(ResourceLocation location, List<StructureProcessor> processors) {
        this(location, processors, JigsawPattern.PlacementBehaviour.RIGID);
    }

    public GelJigsawPiece(ResourceLocation location) {
        this(location, (List<StructureProcessor>)ImmutableList.of());
    }

    public GelJigsawPiece(Dynamic<?> dyn) {
        super(dyn);
        this.maintainWater = dyn.get("maintainWater").asBoolean(true);
        this.ignoreEntities = dyn.get("ignoreEntities").asBoolean(false);
    }

    public GelJigsawPiece maintainWater(boolean value) {
        this.maintainWater = value;
        return this;
    }

    public GelJigsawPiece setIgnoreEntities(boolean value) {
        this.ignoreEntities = value;
        return this;
    }

    protected PlacementSettings func_214860_a(Rotation rotation, MutableBoundingBox boundingBox) {
        GelPlacementSettings placementSettings = new GelPlacementSettings();
        placementSettings.setMaintainWater(this.maintainWater);
        placementSettings.func_186223_a(boundingBox);
        placementSettings.func_186220_a(rotation);
        placementSettings.func_215223_c(true);
        placementSettings.func_186222_a(this.ignoreEntities);
        placementSettings.func_215222_a(RemoveGelStructureProcessor.INSTANCE);
        placementSettings.func_215222_a((StructureProcessor)JigsawReplacementStructureProcessor.field_215196_a);
        this.field_214862_b.forEach(arg_0 -> ((GelPlacementSettings)placementSettings).func_215222_a(arg_0));
        this.func_214854_c().func_214937_b().forEach(arg_0 -> ((GelPlacementSettings)placementSettings).func_215222_a(arg_0));
        return placementSettings;
    }

    public boolean place(TemplateManager manager, IWorld worldIn, ChunkGenerator<?> chunkGenerator, BlockPos pos, Rotation rotation, MutableBoundingBox bounds, Random rand, GelStructurePiece gelStructurePiece) {
        PlacementSettings placementSettings;
        Template template = manager.func_200220_a(this.field_214861_a);
        if (!new GelTemplate(template).func_189962_a(worldIn, pos, placementSettings = this.func_214860_a(rotation, bounds), 18)) {
            return false;
        }
        for (Template.BlockInfo blockInfo : Template.processBlockInfos((Template)template, (IWorld)worldIn, (BlockPos)pos, (PlacementSettings)placementSettings, (List)this.func_214857_a(manager, pos, rotation, false))) {
            StructureMode mode;
            this.func_214846_a(worldIn, blockInfo, pos, rotation, rand, bounds);
            if (blockInfo.field_186244_c == null || worldIn.func_180495_p(blockInfo.field_186242_a).func_177230_c() != Blocks.field_185779_df || (mode = StructureMode.valueOf((String)blockInfo.field_186244_c.func_74779_i("mode"))) != StructureMode.DATA) continue;
            gelStructurePiece.handleDataMarker(blockInfo.field_186244_c.func_74779_i("metadata"), worldIn, blockInfo.field_186242_a, rand, bounds);
        }
        return true;
    }

    public ResourceLocation getLocation() {
        return this.field_214861_a;
    }

    public IJigsawDeserializer func_214853_a() {
        return StructureGelMod.JigsawDeserializers.GEL_SINGLE_POOL_ELEMENT;
    }

    public <T> Dynamic<T> func_214851_a(DynamicOps<T> ops) {
        return new Dynamic(ops, ops.createMap((Map)ImmutableMap.of((Object)ops.createString("location"), (Object)ops.createString(this.field_214861_a.toString()), (Object)ops.createString("processors"), (Object)ops.createList(this.field_214862_b.stream().map(processor -> processor.func_215191_b(ops).getValue())), (Object)ops.createString("maintainWater"), (Object)ops.createBoolean(this.maintainWater), (Object)ops.createString("ignoreEntities"), (Object)ops.createBoolean(this.ignoreEntities))));
    }

    public String toString() {
        return "Gel[" + this.field_214861_a + "]";
    }
}

