/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.structures.processors;

import com.google.common.collect.ImmutableMap;
import com.legacy.structure_gel.StructureGelMod;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.feature.template.IStructureProcessorType;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;

public class RandomTagSwapProcessor
extends StructureProcessor {
    private final Tag<Block> condition;
    private final float chance;
    private final BlockState changeTo;

    public RandomTagSwapProcessor(Tag<Block> condition, float chance, BlockState changeTo) {
        this.condition = condition;
        this.chance = chance;
        this.changeTo = changeTo;
    }

    public RandomTagSwapProcessor(Tag<Block> condition, BlockState changeTo) {
        this(condition, 1.0f, changeTo);
    }

    public RandomTagSwapProcessor(Tag<Block> condition, float chance, Block changeTo) {
        this(condition, chance, changeTo.func_176223_P());
    }

    public RandomTagSwapProcessor(Tag<Block> condition, Block changeTo) {
        this(condition, changeTo.func_176223_P());
    }

    public RandomTagSwapProcessor(Dynamic<?> dyn) {
        this.condition = BlockTags.func_199896_a().func_199910_a(new ResourceLocation(dyn.get("condition").asString("")));
        this.chance = dyn.get("chance").asFloat(0.0f);
        this.changeTo = BlockState.func_215698_a((Dynamic)dyn.get("change_to").orElseEmptyMap());
    }

    @Nullable
    public Template.BlockInfo func_215194_a(IWorldReader worldReaderIn, BlockPos pos, Template.BlockInfo existing, Template.BlockInfo placed, PlacementSettings settings) {
        block2: {
            block3: {
                if (!placed.field_186243_b.func_177230_c().func_203417_a(this.condition)) break block2;
                if (this.chance == 1.0f) break block3;
                Random random = new Random(MathHelper.func_180186_a((Vec3i)placed.field_186242_a));
                if (!(random.nextFloat() < this.chance)) break block2;
            }
            return new Template.BlockInfo(placed.field_186242_a, this.changeTo, null);
        }
        return placed;
    }

    protected IStructureProcessorType func_215192_a() {
        return StructureGelMod.Processors.REPLACE_TAG;
    }

    protected <T> Dynamic<T> func_215193_a(DynamicOps<T> ops) {
        return new Dynamic(ops, ops.createMap((Map)ImmutableMap.of((Object)ops.createString("condition"), (Object)ops.createString(this.condition.func_199886_b().toString()), (Object)ops.createString("chance"), (Object)ops.createFloat(this.chance), (Object)ops.createString("change_to"), (Object)BlockState.func_215689_a(ops, (BlockState)this.changeTo).getValue())));
    }
}

