/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.util;

import com.mojang.datafixers.util.Pair;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.NoPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RegistryHelper {
    public static <T extends IForgeRegistryEntry<T>> T register(IForgeRegistry<T> registry, ResourceLocation key, T registryObject) {
        registryObject.setRegistryName(key);
        registry.register(registryObject);
        return registryObject;
    }

    public static <C extends IFeatureConfig> Structure<C> registerStructure(IForgeRegistry<Feature<?>> registry, String modid, String key, Structure<C> structure) {
        return RegistryHelper.registerStructure(registry, new ResourceLocation(modid, key), structure);
    }

    public static <C extends IFeatureConfig> IStructurePieceType registerStructurePiece(String modid, String key, IStructurePieceType pieceType) {
        return RegistryHelper.registerStructurePiece(new ResourceLocation(modid, key), pieceType);
    }

    public static <C extends IFeatureConfig> Pair<Structure<C>, IStructurePieceType> registerStructureAndPiece(IForgeRegistry<Feature<?>> registry, String modid, String key, Structure<C> structure, IStructurePieceType pieceType) {
        return RegistryHelper.registerStructureAndPiece(registry, new ResourceLocation(modid, key), structure, pieceType);
    }

    public static <C extends IFeatureConfig> Structure<C> registerStructure(IForgeRegistry<Feature<?>> registry, ResourceLocation key, Structure<C> structure) {
        Structure struc = (Structure)Registry.func_218322_a((Registry)GameData.getStructureFeatures(), (ResourceLocation)key, structure);
        RegistryHelper.register(registry, key, struc);
        return struc;
    }

    public static <C extends IFeatureConfig> IStructurePieceType registerStructurePiece(ResourceLocation key, IStructurePieceType pieceType) {
        return (IStructurePieceType)Registry.func_218322_a((Registry)Registry.field_218362_C, (ResourceLocation)key, (Object)pieceType);
    }

    public static <C extends IFeatureConfig> Pair<Structure<C>, IStructurePieceType> registerStructureAndPiece(IForgeRegistry<Feature<?>> registry, ResourceLocation key, Structure<C> structure, IStructurePieceType pieceType) {
        Structure<C> struc = RegistryHelper.registerStructure(registry, key, structure);
        IStructurePieceType piece = RegistryHelper.registerStructurePiece(key, pieceType);
        return Pair.of(struc, (Object)piece);
    }

    public static <C extends IFeatureConfig, PC extends IPlacementConfig> void addFeature(Biome biome, GenerationStage.Decoration stage, Feature<C> feature, C config, Placement<PC> placement, PC placementConfig) {
        biome.func_203611_a(stage, feature.func_225566_b_(config).func_227228_a_(placement.func_227446_a_(placementConfig)));
    }

    public static <C extends IFeatureConfig> void addFeature(Biome biome, GenerationStage.Decoration stage, Feature<C> feature, C config, Placement<NoPlacementConfig> placement) {
        RegistryHelper.addFeature(biome, stage, feature, config, placement, IPlacementConfig.field_202468_e);
    }

    public static <C extends IFeatureConfig> void addFeature(Biome biome, GenerationStage.Decoration stage, Feature<C> feature, C config) {
        RegistryHelper.addFeature(biome, stage, feature, config, (Placement<NoPlacementConfig>)Placement.field_215022_h);
    }

    public static void addFeature(Biome biome, GenerationStage.Decoration stage, Feature<NoFeatureConfig> feature) {
        RegistryHelper.addFeature(biome, stage, feature, IFeatureConfig.field_202429_e);
    }

    public static <C extends IFeatureConfig> void addStructure(Biome biome, Structure<C> structure, C config) {
        biome.func_226711_a_(structure.func_225566_b_(config));
    }

    public static void addStructure(Biome biome, Structure<NoFeatureConfig> structure) {
        RegistryHelper.addStructure(biome, structure, IFeatureConfig.field_202429_e);
    }
}

