/*
 * Decompiled with CFR 0.152.
 */
package icey.survivaloverhaul;

import icey.survivaloverhaul.api.temperature.DynamicModifierBase;
import icey.survivaloverhaul.api.temperature.ModifierBase;
import icey.survivaloverhaul.api.temperature.TemperatureEnum;
import icey.survivaloverhaul.api.temperature.TemperatureUtil;
import icey.survivaloverhaul.common.capability.heartmods.HeartModifierCapability;
import icey.survivaloverhaul.common.capability.heartmods.HeartModifierStorage;
import icey.survivaloverhaul.common.capability.temperature.TemperatureCapability;
import icey.survivaloverhaul.common.capability.temperature.TemperatureStorage;
import icey.survivaloverhaul.common.capability.wetness.WetnessCapability;
import icey.survivaloverhaul.config.Config;
import icey.survivaloverhaul.config.json.JsonConfigRegistration;
import icey.survivaloverhaul.network.NetworkHandler;
import icey.survivaloverhaul.registry.BlockRegistry;
import icey.survivaloverhaul.registry.EffectRegistry;
import icey.survivaloverhaul.registry.EnchantRegistry;
import icey.survivaloverhaul.registry.ItemRegistry;
import icey.survivaloverhaul.registry.TemperatureModifierRegistry;
import icey.survivaloverhaul.util.WorldUtil;
import icey.survivaloverhaul.util.internal.TemperatureUtilInternal;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.resources.ReloadListener;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemModelsProperties;
import net.minecraft.item.ItemStack;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerStartedEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.RegistryBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="survivaloverhaul")
@Mod.EventBusSubscriber(modid="survivaloverhaul")
public class Main {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MOD_ID = "survivaloverhaul";
    public static boolean betterWeatherLoaded = false;
    public static boolean sereneSeasonsLoaded = false;
    public static boolean surviveLoaded = false;
    public static boolean curiosLoaded = false;
    public static boolean toughAsNailsLoaded = false;
    public static Path configPath = FMLPaths.CONFIGDIR.get();
    public static Path modConfigPath = Paths.get(configPath.toAbsolutePath().toString(), "survivaloverhaul");
    public static Path modConfigJsons = Paths.get(modConfigPath.toString(), "json");
    public static ForgeRegistry<ModifierBase> MODIFIERS;
    public static ForgeRegistry<DynamicModifierBase> DYNAMIC_MODIFIERS;
    @CapabilityInject(value=TemperatureCapability.class)
    public static final Capability<TemperatureCapability> TEMPERATURE_CAP;
    @CapabilityInject(value=HeartModifierCapability.class)
    public static final Capability<HeartModifierCapability> HEART_MOD_CAP;
    @CapabilityInject(value=WetnessCapability.class)
    public static final Capability<WetnessCapability> WETNESS_CAP;

    public Main() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        modBus.addListener(this::setup);
        modBus.addListener(this::onModConfigEvent);
        modBus.addListener(this::buildRegistries);
        modBus.addListener(this::clientEvents);
        ItemRegistry.ITEMS.register(modBus);
        EffectRegistry.EFFECTS.register(modBus);
        EffectRegistry.POTIONS.register(modBus);
        EnchantRegistry.ENCHANTS.register(modBus);
        BlockRegistry.BLOCKS.register(modBus);
        TemperatureModifierRegistry.MODIFIERS.register(modBus);
        TemperatureModifierRegistry.DYNAMIC_MODIFIERS.register(modBus);
        forgeBus.addListener(this::serverStarted);
        forgeBus.addListener(this::reloadListener);
        MinecraftForge.EVENT_BUS.register((Object)this);
        Config.register();
        Config.Baked.bakeClient();
        Config.Baked.bakeCommon();
        TemperatureUtil.internal = new TemperatureUtilInternal();
        this.modCompat();
    }

    private void modCompat() {
        sereneSeasonsLoaded = ModList.get().isLoaded("sereneseasons");
        curiosLoaded = ModList.get().isLoaded("curios");
        surviveLoaded = ModList.get().isLoaded("survive");
        if (sereneSeasonsLoaded) {
            LOGGER.debug("Serene Seasons is loaded, enabling compatability");
        }
        if (curiosLoaded) {
            LOGGER.debug("Curios is loaded, enabling compatability");
        }
        if (surviveLoaded) {
            LOGGER.debug("Survive is loaded, I hope you know what you're doing");
        }
    }

    private void setup(FMLCommonSetupEvent event) {
        CapabilityManager.INSTANCE.register(TemperatureCapability.class, (Capability.IStorage)new TemperatureStorage(), TemperatureCapability::new);
        CapabilityManager.INSTANCE.register(HeartModifierCapability.class, (Capability.IStorage)new HeartModifierStorage(), HeartModifierCapability::new);
        CapabilityManager.INSTANCE.register(WetnessCapability.class, (Capability.IStorage)new WetnessCapability().new WetnessCapability.Storage(), WetnessCapability::new);
        NetworkHandler.register();
        event.enqueueWork(() -> EffectRegistry.registerPotionRecipes());
    }

    private void biomeModification(BiomeLoadingEvent event) {
    }

    private void clientEvents(FMLClientSetupEvent event) {
        RenderTypeLookup.setRenderLayer((Block)((Block)BlockRegistry.COOLING_COIL.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)((Block)BlockRegistry.HEATING_COIL.get()), (RenderType)RenderType.func_228643_e_());
        event.enqueueWork(() -> {
            DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> Main.clientModelSetup());
            DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> Main.clientKeyBindsSetup());
        });
    }

    private void serverStarted(FMLServerStartedEvent event) {
    }

    private static DistExecutor.SafeRunnable clientModelSetup() {
        return new DistExecutor.SafeRunnable(){
            private static final long serialVersionUID = 1L;

            public void run() {
                ItemModelsProperties.func_239418_a_((Item)((Item)ItemRegistry.THERMOMETER.get()), (ResourceLocation)new ResourceLocation("temperature"), (IItemPropertyGetter)new IItemPropertyGetter(){

                    @OnlyIn(value=Dist.CLIENT)
                    public float call(ItemStack stack, ClientWorld clientWorld, LivingEntity entity) {
                        LivingEntity holder;
                        ClientWorld world = clientWorld;
                        Object object = holder = entity != null ? entity : stack.func_82836_z();
                        if (world == null && holder != null) {
                            world = holder.field_70170_p;
                        }
                        if (world == null) {
                            return 0.5f;
                        }
                        try {
                            int temperature = WorldUtil.calculateClientWorldEntityTemperature((World)world, (Entity)holder);
                            double d = (float)temperature / (float)TemperatureEnum.HEAT_STROKE.getUpperBound();
                            return MathHelper.func_188207_b((float)((float)d), (float)1.0333333f);
                        }
                        catch (NullPointerException e) {
                            return 0.5f;
                        }
                    }
                });
            }
        };
    }

    private static DistExecutor.SafeRunnable clientKeyBindsSetup() {
        return new DistExecutor.SafeRunnable(){
            private static final long serialVersionUID = 1L;

            public void run() {
            }
        };
    }

    private void reloadListener(AddReloadListenerEvent event) {
        event.addListener((IFutureReloadListener)new ReloadListener<Void>(){

            @Nonnull
            @ParametersAreNonnullByDefault
            protected Void prepare(IResourceManager manager, IProfiler profiler) {
                JsonConfigRegistration.clearContainers();
                return null;
            }

            @ParametersAreNonnullByDefault
            protected void apply(Void objectIn, IResourceManager resourceManagerIn, IProfiler profilerIn) {
                Config.Baked.bakeCommon();
                JsonConfigRegistration.init(modConfigJsons.toFile());
            }
        });
    }

    private void onModConfigEvent(ModConfig.ModConfigEvent event) {
        ModConfig config = event.getConfig();
        if (config.getSpec() == Config.CLIENT_SPEC) {
            Config.Baked.bakeClient();
        }
    }

    private void buildRegistries(RegistryEvent.NewRegistry event) {
        RegistryBuilder modifierBuilder = new RegistryBuilder();
        modifierBuilder.setName(new ResourceLocation(MOD_ID, "modifiers"));
        modifierBuilder.setType(ModifierBase.class);
        MODIFIERS = (ForgeRegistry)modifierBuilder.create();
        RegistryBuilder dynamicModifierBuilder = new RegistryBuilder();
        dynamicModifierBuilder.setName(new ResourceLocation(MOD_ID, "dynamic_modifiers"));
        dynamicModifierBuilder.setType(DynamicModifierBase.class);
        DYNAMIC_MODIFIERS = (ForgeRegistry)dynamicModifierBuilder.create();
    }

    static {
        TEMPERATURE_CAP = null;
        HEART_MOD_CAP = null;
        WETNESS_CAP = null;
    }
}

